/*
 * Decompiled with CFR 0.152.
 */
package com.foxinmy.weixin4j.payment.mch;

import com.alibaba.fastjson.annotation.JSONField;
import com.foxinmy.weixin4j.model.WeixinPayAccount;
import com.foxinmy.weixin4j.payment.mch.MerchantResult;
import com.foxinmy.weixin4j.util.DateUtil;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
public class Redpacket
extends MerchantResult {
    private static final long serialVersionUID = -7021352305575714281L;
    @XmlElement(name="msgappid")
    @JSONField(name="msgappid")
    private String subMsgId;
    @XmlElement(name="consume_mch_id")
    @JSONField(name="consume_mch_id")
    private String consumeMchId;
    @XmlElement(name="mch_billno")
    @JSONField(name="mch_billno")
    private String outTradeNo;
    @XmlElement(name="send_name")
    @JSONField(name="send_name")
    private String sendName;
    @XmlElement(name="re_openid")
    @JSONField(name="re_openid")
    private String openid;
    @XmlElement(name="total_amount")
    @JSONField(name="total_amount")
    private String totalAmount;
    @XmlElement(name="total_num")
    @JSONField(name="total_num")
    private int totalNum;
    @XmlElement(name="amt_type")
    @JSONField(name="amt_type")
    private String amtType;
    private String wishing;
    @XmlElement(name="client_ip")
    @JSONField(name="client_ip")
    private String clientIp;
    @XmlElement(name="act_name")
    @JSONField(name="act_name")
    private String actName;
    private String remark;

    protected Redpacket() {
    }

    public Redpacket(WeixinPayAccount weixinPayAccount, String outTradeNo, String sendName, String openid, double totalAmount, int totalNum, String wishing, String clientIp, String actName, String remark) {
        this(null, null, outTradeNo, sendName, openid, totalAmount, totalNum, wishing, clientIp, actName, remark);
    }

    public Redpacket(String subMsgId, String consumeMchId, String outTradeNo, String sendName, String openid, double totalAmount, int totalNum, String wishing, String clientIp, String actName, String remark) {
        this.subMsgId = subMsgId;
        this.consumeMchId = consumeMchId;
        this.outTradeNo = outTradeNo;
        this.sendName = sendName;
        this.openid = openid;
        this.totalNum = totalNum;
        this.wishing = wishing;
        this.clientIp = clientIp;
        this.actName = actName;
        this.remark = remark;
        this.totalAmount = DateUtil.formaFee2Fen(totalAmount);
        this.amtType = totalNum > 1 ? "ALL_RAND" : null;
    }

    public String getOutTradeNo() {
        return this.outTradeNo;
    }

    public String getSendName() {
        return this.sendName;
    }

    public String getOpenid() {
        return this.openid;
    }

    public String getTotalAmount() {
        return this.totalAmount;
    }

    public int getTotalNum() {
        return this.totalNum;
    }

    public String getWishing() {
        return this.wishing;
    }

    public String getAmtType() {
        return this.amtType;
    }

    public String getClientIp() {
        return this.clientIp;
    }

    public String getActName() {
        return this.actName;
    }

    public String getRemark() {
        return this.remark;
    }

    @Override
    public String toString() {
        return "Redpacket [subMsgId=" + this.subMsgId + ", consumeMchId=" + this.consumeMchId + ", outTradeNo=" + this.outTradeNo + ", sendName=" + this.sendName + ", openid=" + this.openid + ", totalAmount=" + this.totalAmount + ", totalNum=" + this.totalNum + ", amtType=" + this.amtType + ", wishing=" + this.wishing + ", clientIp=" + this.clientIp + ", actName=" + this.actName + ", remark=" + this.remark + ", " + super.toString() + "]";
    }
}

