/*
 * Decompiled with CFR 0.152.
 */
package com.foxinmy.weixin4j.http.weixin;

import com.alibaba.fastjson.JSONException;
import com.foxinmy.weixin4j.exception.WeixinException;
import com.foxinmy.weixin4j.http.ContentType;
import com.foxinmy.weixin4j.http.HttpClient;
import com.foxinmy.weixin4j.http.HttpClientException;
import com.foxinmy.weixin4j.http.HttpHeaders;
import com.foxinmy.weixin4j.http.HttpMethod;
import com.foxinmy.weixin4j.http.HttpParams;
import com.foxinmy.weixin4j.http.HttpRequest;
import com.foxinmy.weixin4j.http.HttpResponse;
import com.foxinmy.weixin4j.http.apache.FormBodyPart;
import com.foxinmy.weixin4j.http.apache.HttpMultipartMode;
import com.foxinmy.weixin4j.http.apache.MultipartEntity;
import com.foxinmy.weixin4j.http.entity.FormUrlEntity;
import com.foxinmy.weixin4j.http.entity.StringEntity;
import com.foxinmy.weixin4j.http.factory.HttpClientFactory;
import com.foxinmy.weixin4j.http.weixin.JsonResult;
import com.foxinmy.weixin4j.http.weixin.WeixinResponse;
import com.foxinmy.weixin4j.http.weixin.XmlResult;
import com.foxinmy.weixin4j.logging.InternalLogger;
import com.foxinmy.weixin4j.logging.InternalLoggerFactory;
import com.foxinmy.weixin4j.model.Consts;
import com.foxinmy.weixin4j.xml.XmlStream;
import java.util.Map;

public class WeixinRequestExecutor {
    protected final InternalLogger logger = InternalLoggerFactory.getInstance(this.getClass());
    protected final HttpClient httpClient = HttpClientFactory.getInstance();
    protected final HttpParams params;

    public WeixinRequestExecutor() {
        this(new HttpParams());
    }

    public WeixinRequestExecutor(HttpParams params) {
        this.params = params;
    }

    public WeixinResponse get(String url) throws WeixinException {
        HttpRequest request = new HttpRequest(HttpMethod.GET, url);
        return this.doRequest(request);
    }

    public WeixinResponse get(String url, Map<String, String> parameters) throws WeixinException {
        StringBuilder buf = new StringBuilder(url);
        if (parameters != null && !parameters.isEmpty()) {
            if (url.indexOf("?") < 0) {
                buf.append("?");
            } else {
                buf.append("&");
            }
            buf.append(FormUrlEntity.formatParameters(parameters));
        }
        return this.doRequest(new HttpRequest(HttpMethod.GET, buf.toString()));
    }

    public WeixinResponse post(String url) throws WeixinException {
        HttpRequest request = new HttpRequest(HttpMethod.POST, url);
        return this.doRequest(request);
    }

    public WeixinResponse post(String url, String body) throws WeixinException {
        StringEntity entity = new StringEntity(body);
        HttpRequest request = new HttpRequest(HttpMethod.POST, url);
        request.setEntity(entity);
        return this.doRequest(request);
    }

    public WeixinResponse post(String url, FormBodyPart ... bodyParts) throws WeixinException {
        MultipartEntity entity = new MultipartEntity(HttpMultipartMode.BROWSER_COMPATIBLE, null, Consts.UTF_8);
        for (FormBodyPart bodyPart : bodyParts) {
            entity.addPart(bodyPart);
        }
        HttpRequest request = new HttpRequest(HttpMethod.POST, url);
        request.setEntity(entity);
        return this.doRequest(request);
    }

    protected WeixinResponse doRequest(HttpRequest request) throws WeixinException {
        request.setParams(this.params);
        try {
            this.logger.info("weixin request >> " + (Object)((Object)request.getMethod()) + " " + request.getURI().toString());
            HttpResponse httpResponse = this.httpClient.execute(request);
            HttpHeaders headers = httpResponse.getHeaders();
            WeixinResponse response = new WeixinResponse(httpResponse);
            this.logger.info("weixin response << " + httpResponse.getProtocol() + httpResponse.getStatus().toString() + ":" + response.getAsString());
            String contentType = headers.getFirst("Content-Type");
            String disposition = headers.getFirst("Content-Disposition");
            if (contentType.contains(ContentType.APPLICATION_JSON.getMimeType()) || disposition != null && disposition.indexOf(".json") > 0) {
                this.checkJson(response);
            } else if (contentType.contains(ContentType.TEXT_XML.getMimeType())) {
                this.checkXml(response);
            } else if (contentType.contains(ContentType.TEXT_PLAIN.getMimeType()) || contentType.contains(ContentType.TEXT_HTML.getMimeType())) {
                try {
                    this.checkJson(response);
                    return response;
                }
                catch (JSONException e) {
                    try {
                        this.checkXml(response);
                        return response;
                    }
                    catch (IllegalArgumentException ex) {
                        throw new WeixinException(response.getAsString());
                    }
                }
            }
            return response;
        }
        catch (HttpClientException e) {
            throw new WeixinException(e);
        }
    }

    protected void checkJson(WeixinResponse response) throws WeixinException {
        JsonResult jsonResult = response.getAsJsonResult();
        response.setJsonResult(true);
        if (jsonResult.getCode() != 0) {
            throw new WeixinException(Integer.toString(jsonResult.getCode()), jsonResult.getDesc());
        }
    }

    protected void checkXml(WeixinResponse response) throws WeixinException {
        String xmlContent = response.getAsString();
        if (xmlContent.length() != xmlContent.replaceFirst("<retcode>", "<return_code>").length()) {
            xmlContent = xmlContent.replaceFirst("<root>", "<xml>").replaceFirst("<retcode>", "<return_code>").replaceFirst("</retcode>", "</return_code>").replaceFirst("<retmsg>", "<return_msg>").replaceFirst("</retmsg>", "</return_msg>").replaceFirst("</root>", "</xml>");
        }
        XmlResult xmlResult = XmlStream.fromXML(xmlContent, XmlResult.class);
        response.setText(xmlContent);
        response.setXmlResult(true);
        if ("0".equals(xmlResult.getReturnCode())) {
            return;
        }
        if (!"SUCCESS".equalsIgnoreCase(xmlResult.getReturnCode())) {
            throw new WeixinException(xmlResult.getReturnCode(), xmlResult.getReturnMsg());
        }
        if (!"SUCCESS".equalsIgnoreCase(xmlResult.getResultCode())) {
            throw new WeixinException(xmlResult.getErrCode(), xmlResult.getErrCodeDes());
        }
    }

    public HttpClient getExecuteClient() {
        return this.httpClient;
    }

    public HttpParams getExecuteParams() {
        return this.params;
    }
}

