/*
 * Decompiled with CFR 0.152.
 */
package com.foxinmy.weixin4j.http.factory;

import com.foxinmy.weixin4j.http.HttpClient;
import com.foxinmy.weixin4j.http.factory.HttpClientFactory;
import com.foxinmy.weixin4j.http.factory.Netty4HttpClient;
import io.netty.bootstrap.Bootstrap;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.codec.http.HttpClientCodec;
import io.netty.handler.codec.http.HttpContentDecompressor;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.HttpResponseDecoder;
import io.netty.handler.stream.ChunkedWriteHandler;

public class Netty4HttpClientFactory
extends HttpClientFactory {
    private final int workerThreads;
    private volatile Bootstrap bootstrap;

    public Netty4HttpClientFactory() {
        this(Runtime.getRuntime().availableProcessors() * 4);
    }

    public Netty4HttpClientFactory(int workerThreads) {
        this.workerThreads = workerThreads;
    }

    @Override
    public HttpClient newInstance() {
        if (this.bootstrap == null) {
            this.bootstrap = new Bootstrap();
            ((Bootstrap)this.bootstrap.option(ChannelOption.SO_KEEPALIVE, (Object)true)).option(ChannelOption.TCP_NODELAY, (Object)true);
            NioEventLoopGroup workerGroup = new NioEventLoopGroup(this.workerThreads);
            ((Bootstrap)((Bootstrap)this.bootstrap.group((EventLoopGroup)workerGroup)).channel(NioSocketChannel.class)).handler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

                protected void initChannel(SocketChannel channel) throws Exception {
                    ChannelPipeline pipeline = channel.pipeline();
                    pipeline.addLast(new ChannelHandler[]{new HttpClientCodec()});
                    pipeline.addLast(new ChannelHandler[]{new HttpContentDecompressor()});
                    pipeline.addLast(new ChannelHandler[]{new ChunkedWriteHandler()});
                    pipeline.addLast(new ChannelHandler[]{new HttpResponseDecoder()});
                    pipeline.addLast(new ChannelHandler[]{new HttpObjectAggregator(Integer.MAX_VALUE)});
                }
            });
        }
        return new Netty4HttpClient(this.bootstrap);
    }
}

