/*
 * Decompiled with CFR 0.152.
 */
package com.foxinmy.weixin4j.http;

import com.foxinmy.weixin4j.model.Consts;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.nio.charset.UnsupportedCharsetException;
import java.util.List;
import java.util.Locale;

public final class ContentType
implements Serializable {
    private static final long serialVersionUID = 1544245878894784980L;
    public static final ContentType APPLICATION_ATOM_XML = ContentType.create("application/atom+xml", Consts.UTF_8);
    public static final ContentType APPLICATION_FORM_URLENCODED = ContentType.create("application/x-www-form-urlencoded", Consts.UTF_8);
    public static final ContentType APPLICATION_JSON = ContentType.create("application/json", Consts.UTF_8);
    public static final ContentType APPLICATION_OCTET_STREAM = ContentType.create("application/octet-stream", (Charset)null);
    public static final ContentType APPLICATION_SVG_XML = ContentType.create("application/svg+xml", Consts.UTF_8);
    public static final ContentType APPLICATION_XHTML_XML = ContentType.create("application/xhtml+xml", Consts.UTF_8);
    public static final ContentType APPLICATION_XML = ContentType.create("application/xml", Consts.UTF_8);
    public static final ContentType MULTIPART_FORM_DATA = ContentType.create("multipart/form-data", Consts.UTF_8);
    public static final ContentType TEXT_HTML = ContentType.create("text/html", Consts.UTF_8);
    public static final ContentType TEXT_PLAIN = ContentType.create("text/plain", Consts.UTF_8);
    public static final ContentType IMAGE_JPG = ContentType.create("image/jpg", Consts.UTF_8);
    public static final ContentType AUDIO_MP3 = ContentType.create("audio/mp3", Consts.UTF_8);
    public static final ContentType VIDEO_MPEG4 = ContentType.create("video/mpeg4", Consts.UTF_8);
    public static final ContentType TEXT_XML = ContentType.create("text/xml", Consts.UTF_8);
    public static final ContentType WILDCARD = ContentType.create("*/*", (Charset)null);
    public static final ContentType DEFAULT_TEXT = TEXT_PLAIN;
    public static final ContentType DEFAULT_BINARY = APPLICATION_OCTET_STREAM;
    private final String mimeType;
    private final Charset charset;

    ContentType(String mimeType, Charset charset) {
        this.mimeType = mimeType;
        this.charset = charset;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public Charset getCharset() {
        return this.charset;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append(this.mimeType);
        if (this.charset != null) {
            buf.append("; charset=");
            buf.append(this.charset.name());
        }
        return buf.toString();
    }

    public static String toString(List<ContentType> contentTypes) {
        if (contentTypes == null || contentTypes.isEmpty()) {
            return null;
        }
        StringBuilder buf = new StringBuilder();
        for (ContentType contentType : contentTypes) {
            buf.append(contentType.toString()).append(",");
        }
        return buf.delete(buf.length() - 1, buf.length()).toString();
    }

    private static boolean valid(String s) {
        for (int i = 0; i < s.length(); ++i) {
            char ch = s.charAt(i);
            if (ch != '\"' && ch != ',' && ch != ';') continue;
            return false;
        }
        return true;
    }

    public static ContentType create(String mimeType, Charset charset) {
        if (mimeType == null) {
            throw new IllegalArgumentException("MIME type may not be null");
        }
        String type = mimeType.trim().toLowerCase(Locale.US);
        if (type.length() == 0) {
            throw new IllegalArgumentException("MIME type may not be empty");
        }
        if (!ContentType.valid(type)) {
            throw new IllegalArgumentException("MIME type may not contain reserved characters");
        }
        return new ContentType(type, charset);
    }

    public static ContentType create(String mimeType) {
        return new ContentType(mimeType, null);
    }

    public static ContentType create(String mimeType, String charset) throws UnsupportedCharsetException {
        return ContentType.create(mimeType, charset != null && charset.length() > 0 ? Charset.forName(charset) : null);
    }
}

