/*
 * Decompiled with CFR 0.152.
 */
package com.foxinmy.weixin4j.api;

import com.alibaba.fastjson.TypeReference;
import com.foxinmy.weixin4j.api.MchApi;
import com.foxinmy.weixin4j.exception.WeixinException;
import com.foxinmy.weixin4j.http.weixin.WeixinResponse;
import com.foxinmy.weixin4j.model.WeixinPayAccount;
import com.foxinmy.weixin4j.payment.coupon.CouponDetail;
import com.foxinmy.weixin4j.payment.coupon.CouponResult;
import com.foxinmy.weixin4j.payment.coupon.CouponStock;
import com.foxinmy.weixin4j.util.StringUtil;
import com.foxinmy.weixin4j.xml.XmlStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;

public class CouponApi
extends MchApi {
    public CouponApi(WeixinPayAccount weixinAccount) {
        super(weixinAccount);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CouponResult sendCoupon(InputStream certificate, String couponStockId, String partnerTradeNo, String openId, String opUserId) throws WeixinException {
        Map<String, String> map = this.createBaseRequestMap(null);
        map.put("coupon_stock_id", couponStockId);
        map.put("partner_trade_no", partnerTradeNo);
        map.put("openid", openId);
        map.put("openid_count", "1");
        if (StringUtil.isBlank(opUserId)) {
            opUserId = this.weixinAccount.getMchId();
        }
        map.put("op_user_id", opUserId);
        map.put("version", "1.0");
        map.put("type", "XML");
        map.put("sign", this.weixinSignature.sign(map));
        String param = XmlStream.map2xml(map);
        WeixinResponse response = null;
        try {
            response = this.createSSLRequestExecutor(certificate).post(this.getRequestUri("coupon_send_uri"), param);
        }
        finally {
            if (certificate != null) {
                try {
                    certificate.close();
                }
                catch (IOException e) {}
            }
        }
        return response.getAsObject(new TypeReference<CouponResult>(){});
    }

    public CouponStock queryCouponStock(String couponStockId) throws WeixinException {
        Map<String, String> map = this.createBaseRequestMap(null);
        map.put("coupon_stock_id", couponStockId);
        map.put("sign", this.weixinSignature.sign(map));
        String param = XmlStream.map2xml(map);
        WeixinResponse response = this.weixinExecutor.post(this.getRequestUri("couponstock_query_uri"), param);
        return response.getAsObject(new TypeReference<CouponStock>(){});
    }

    public CouponDetail queryCouponDetail(String couponId) throws WeixinException {
        Map<String, String> map = this.createBaseRequestMap(null);
        map.put("coupon_id", couponId);
        map.put("sign", this.weixinSignature.sign(map));
        String param = XmlStream.map2xml(map);
        WeixinResponse response = this.weixinExecutor.post(this.getRequestUri("coupondetail_query_uri"), param);
        return response.getAsObject(new TypeReference<CouponDetail>(){});
    }
}

