/*
 * Decompiled with CFR 0.152.
 */
package com.force.sdk.springsecurity.config;

import com.force.sdk.oauth.connector.ForceOAuthConnectionInfo;
import com.force.sdk.oauth.connector.ForceOAuthConnector;
import com.force.sdk.oauth.context.SecurityContextServiceImpl;
import com.force.sdk.oauth.context.store.SecurityContextCookieStore;
import com.force.sdk.oauth.context.store.SecurityContextSessionStore;
import com.force.sdk.oauth.userdata.CustomUserDataRetrievalService;
import com.force.sdk.oauth.userdata.UserDataRetrievalService;
import com.force.sdk.springsecurity.AuthenticationProcessingFilter;
import com.force.sdk.springsecurity.AuthenticationProcessingFilterEntryPoint;
import com.force.sdk.springsecurity.AuthenticationSuccessHandler;
import com.force.sdk.springsecurity.ForceConnectionStorageFilter;
import com.force.sdk.springsecurity.ForceLogoutHandler;
import com.force.sdk.springsecurity.ForceRememberMeServices;
import com.force.sdk.springsecurity.LogoutSuccessHandler;
import com.force.sdk.springsecurity.OAuthAuthenticationProvider;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.parsing.BeanComponentDefinition;
import org.springframework.beans.factory.parsing.CompositeComponentDefinition;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.beans.factory.xml.BeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.security.authentication.ProviderManager;
import org.springframework.security.config.authentication.AuthenticationManagerFactoryBean;
import org.springframework.security.web.authentication.logout.LogoutFilter;
import org.springframework.security.web.authentication.logout.SecurityContextLogoutHandler;
import org.springframework.security.web.authentication.rememberme.RememberMeAuthenticationFilter;
import org.springframework.util.StringUtils;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class OAuthBeanDefinitionParser
implements BeanDefinitionParser {
    private static final String ENDPOINT_ATTR = "endpoint";
    private static final String OAUTH_KEY_ATTR = "oauth-key";
    private static final String OAUTH_SECRET_ATTR = "oauth-secret";
    private static final String CONNECTION_URL_ATTR = "url";
    private static final String CONNECTION_NAME_ATTR = "name";
    private static final String DEFAULT_LOGIN_SUCCESS_ATTR = "default-login-success";
    private static final String DEFAULT_LOGOUT_SUCCESS_ATTR = "default-logout-success";
    private static final String LOGIN_URL_ATTR = "login-url";
    private static final String LOGOUT_URL_ATTR = "logout-url";
    private static final String LOGOUT_FROM_FORCE_DOT_COM_ATTR = "logout-from-force-dot-com";
    private static final String STORE_DATA_IN_SESSION = "store-data-in-session";
    private static final String SECURE_KEY_FILE = "secure-key-file";
    private static final String STORE_USER_NAME = "store-user-name";
    private static final String OAUTH_CONNECTION_INFO_BEAN_NAME = "oauthConnectionInfo";
    private static final String OAUTH_CONNECTOR_BEAN_NAME = "oauthConnector";
    private static final String AUTH_PROVIDER_BEAN_NAME = "oauthAuthenticationProvider";
    private static final String AUTH_MANAGER_BEAN_NAME = "authenticationManager";
    private static final String AUTH_MANAGER_BEAN_ALIAS = "authenticationManager";
    private static final String AUTH_PROCESSING_ENTRY_POINT_BEAN_NAME = "authenticationProcessingFilterEntryPoint";
    private static final String AUTH_PROCESSING_FILTER_BEAN_NAME = "authenticationFilter";
    private static final String AUTH_LOGOUT_FILTER_BEAN_NAME = "logoutFilter";
    private static final String USER_DATA_RETRIEVAL_SERVICE_BEAN_NAME = "userDataRetrievalService";
    private static final String REMEMBER_ME_FILTER_BEAN_NAME = "rememberMeFilter";
    private static final String REMEMBER_ME_SERVICES_BEAN_NAME = "forceRememberMeServices";
    private static final String CONTEXT_STORAGE_SERVICE_NAME = "securityContextStorageService";
    private static final String CONTEXT_SERVICE_NAME = "securityContextService";
    private static final String CONNECTION_STORAGE_FILTER_BEAN_NAME = "connectionStorageFilter";
    private static final String ATT_ENTRY_POINT_REF = "entry-point-ref";
    private static final String ATT_POSITION = "position";
    private static final String ATT_AFTER = "after";
    private static final String ATT_REF = "ref";
    private static final String ELEM_CUSTOM_FILTER = "custom-filter";
    private static final String CREATE_SESSION = "create-session";
    private static final String NAME_OAUTH_INFO_ELEMENT = "oauthInfo";
    private static final String NAME_CONN_URL_ELEMENT = "connectionUrl";
    private static final String NAME_CONN_NAME_ELEMENT = "connectionName";
    private static final String NAME_CUSTOM_DATA_RETRIEVER_ELEMENT = "customUserDataRetriever";

    public BeanDefinition parse(Element element, ParserContext parserContext) {
        NodeList children = element.getElementsByTagNameNS(element.getNamespaceURI(), "*");
        this.validateConfiguration(children);
        parserContext.pushContainingComponent(new CompositeComponentDefinition(element.getTagName(), parserContext.extractSource((Object)element)));
        BeanDefinition oauthConnector = this.createOAuthConnector((Element)this.getConnectionNode(children), parserContext);
        Element customDataRetrieverElement = (Element)this.getCustomDataRetrieverNode(children);
        if (customDataRetrieverElement != null) {
            parserContext.getRegistry().registerBeanDefinition(USER_DATA_RETRIEVAL_SERVICE_BEAN_NAME, this.createCustomUserDataRetrievalService(customDataRetrieverElement, element));
            oauthConnector.getPropertyValues().add(USER_DATA_RETRIEVAL_SERVICE_BEAN_NAME, (Object)new RuntimeBeanReference(USER_DATA_RETRIEVAL_SERVICE_BEAN_NAME));
        } else {
            parserContext.getRegistry().registerBeanDefinition(USER_DATA_RETRIEVAL_SERVICE_BEAN_NAME, this.createUserDataRetrievalService(element));
        }
        parserContext.getRegistry().registerBeanDefinition(OAUTH_CONNECTOR_BEAN_NAME, oauthConnector);
        parserContext.getRegistry().registerBeanDefinition(AUTH_PROVIDER_BEAN_NAME, this.createOAuthAuthenticationProvider(parserContext));
        String[] knownAlias = parserContext.getRegistry().getAliases("authenticationManager");
        if (knownAlias == null || knownAlias.length == 0) {
            parserContext.getRegistry().registerBeanDefinition("org.springframework.security.authenticationManager", this.createAuthenticationManager(element, parserContext));
        }
        parserContext.getRegistry().registerBeanDefinition(AUTH_PROCESSING_ENTRY_POINT_BEAN_NAME, this.createAuthenticationProcessingEntryPoint(parserContext));
        parserContext.getRegistry().registerBeanDefinition(CONTEXT_STORAGE_SERVICE_NAME, this.createSecurityContextStorageService(element));
        parserContext.getRegistry().registerBeanDefinition(CONTEXT_SERVICE_NAME, this.createSecurityContextService());
        parserContext.getRegistry().registerBeanDefinition(REMEMBER_ME_SERVICES_BEAN_NAME, this.createRememberMeServices());
        parserContext.getRegistry().registerBeanDefinition(AUTH_PROCESSING_FILTER_BEAN_NAME, this.createAuthenticationProcessingFilter(element, parserContext));
        parserContext.getRegistry().registerBeanDefinition(AUTH_LOGOUT_FILTER_BEAN_NAME, this.createLogoutFilter(element));
        parserContext.getRegistry().registerBeanDefinition(REMEMBER_ME_FILTER_BEAN_NAME, this.createRememberMeFilter());
        parserContext.getRegistry().registerBeanDefinition(CONNECTION_STORAGE_FILTER_BEAN_NAME, this.createConnectionStorageFilter(element));
        if (element.getParentNode() != null) {
            NodeList nodes = element.getParentNode().getChildNodes();
            for (int i = 0; i < nodes.getLength(); ++i) {
                Node node = nodes.item(i);
                if (node.getLocalName() == null || !"http".equals(node.getLocalName().toLowerCase())) continue;
                if (node.getAttributes().getNamedItem(ATT_ENTRY_POINT_REF) == null) {
                    this.addNodeAttribute(node, ATT_ENTRY_POINT_REF, AUTH_PROCESSING_ENTRY_POINT_BEAN_NAME);
                }
                if (node.getAttributes().getNamedItem(CREATE_SESSION) == null) {
                    this.addNodeAttribute(node, CREATE_SESSION, "never");
                }
                this.setCustomFilterIfMissing(node, "FORM_LOGIN_FILTER", AUTH_PROCESSING_FILTER_BEAN_NAME, ATT_POSITION);
                this.setCustomFilterIfMissing(node, "LOGOUT_FILTER", AUTH_LOGOUT_FILTER_BEAN_NAME, ATT_POSITION);
                this.setCustomFilterIfMissing(node, "REMEMBER_ME_FILTER", REMEMBER_ME_FILTER_BEAN_NAME, ATT_POSITION);
                this.setCustomFilterIfMissing(node, "REMEMBER_ME_FILTER", CONNECTION_STORAGE_FILTER_BEAN_NAME, ATT_AFTER);
                break;
            }
        }
        return null;
    }

    private void addNodeAttribute(Node node, String name, String value) {
        Attr newNode = node.getOwnerDocument().createAttributeNS(node.getNamespaceURI(), name);
        newNode.setNodeValue(value);
        node.getAttributes().setNamedItem(newNode);
    }

    private void setCustomFilterIfMissing(Node httpNode, String positionUpper, String ref, String attribute) {
        if (httpNode.hasChildNodes()) {
            NodeList children = httpNode.getChildNodes();
            for (int i = 0; i < children.getLength(); ++i) {
                Node nn;
                Node node = children.item(i);
                if (node.getLocalName() == null || !ELEM_CUSTOM_FILTER.equals(node.getLocalName().toLowerCase()) || (nn = node.getAttributes().getNamedItem(attribute)) == null || nn.getNodeValue() == null || !positionUpper.equals(nn.getNodeValue().toUpperCase())) continue;
                return;
            }
        }
        int prefix = httpNode.getNodeName().indexOf(58);
        Element newNode = httpNode.getOwnerDocument().createElementNS(httpNode.getNamespaceURI(), prefix > 0 ? httpNode.getNodeName().substring(0, prefix + 1) + ELEM_CUSTOM_FILTER : ELEM_CUSTOM_FILTER);
        httpNode.appendChild(newNode);
        this.addNodeAttribute(newNode, attribute, positionUpper);
        this.addNodeAttribute(newNode, ATT_REF, ref);
    }

    private BeanDefinition createOAuthConnector(Element connectionInfo, ParserContext parser) {
        RootBeanDefinition oauthConnInfo = null;
        if (NAME_OAUTH_INFO_ELEMENT.equals(connectionInfo.getLocalName())) {
            oauthConnInfo = new RootBeanDefinition(ForceOAuthConnectionInfo.class);
            oauthConnInfo.getPropertyValues().add(ENDPOINT_ATTR, (Object)connectionInfo.getAttribute(ENDPOINT_ATTR));
            oauthConnInfo.getPropertyValues().add("oauthKey", (Object)connectionInfo.getAttribute(OAUTH_KEY_ATTR));
            oauthConnInfo.getPropertyValues().add("oauthSecret", (Object)connectionInfo.getAttribute(OAUTH_SECRET_ATTR));
        } else if (NAME_CONN_URL_ELEMENT.equals(connectionInfo.getLocalName())) {
            oauthConnInfo = new RootBeanDefinition(ForceOAuthConnectionInfo.class);
            oauthConnInfo.getPropertyValues().add(NAME_CONN_URL_ELEMENT, (Object)connectionInfo.getAttribute(CONNECTION_URL_ATTR));
        }
        RootBeanDefinition oauthConnector = new RootBeanDefinition(ForceOAuthConnector.class);
        if (oauthConnInfo != null) {
            parser.getRegistry().registerBeanDefinition(OAUTH_CONNECTION_INFO_BEAN_NAME, (BeanDefinition)oauthConnInfo);
            oauthConnector.getPropertyValues().add("connectionInfo", (Object)oauthConnInfo);
        } else if (NAME_CONN_NAME_ELEMENT.equals(connectionInfo.getLocalName())) {
            oauthConnector.getPropertyValues().add(NAME_CONN_NAME_ELEMENT, (Object)connectionInfo.getAttribute(CONNECTION_NAME_ATTR));
        } else {
            throw new RuntimeException("Unrecognized oauth connection information child element: " + connectionInfo.getLocalName());
        }
        return oauthConnector;
    }

    private BeanDefinition createCustomUserDataRetrievalService(Element customDataRetrieverElement, Element mainElement) {
        String customDataRetrieverBeanName = customDataRetrieverElement.getAttribute(ATT_REF);
        String storeUsername = mainElement.getAttribute(STORE_USER_NAME);
        RootBeanDefinition customUserdataRetrievalService = new RootBeanDefinition(CustomUserDataRetrievalService.class);
        if ("false".equalsIgnoreCase(storeUsername)) {
            customUserdataRetrievalService.getPropertyValues().add("storeUsername", (Object)false);
        } else {
            customUserdataRetrievalService.getPropertyValues().add("storeUsername", (Object)true);
        }
        customUserdataRetrievalService.getPropertyValues().add("customDataRetriever", (Object)new RuntimeBeanReference(customDataRetrieverBeanName));
        return customUserdataRetrievalService;
    }

    private BeanDefinition createUserDataRetrievalService(Element mainElement) {
        RootBeanDefinition userdataRetrievalService = new RootBeanDefinition(UserDataRetrievalService.class);
        String storeUsername = mainElement.getAttribute(STORE_USER_NAME);
        if ("false".equalsIgnoreCase(storeUsername)) {
            userdataRetrievalService.getPropertyValues().add("storeUsername", (Object)false);
        } else {
            userdataRetrievalService.getPropertyValues().add("storeUsername", (Object)true);
        }
        return userdataRetrievalService;
    }

    private BeanDefinition createOAuthAuthenticationProvider(ParserContext parserContext) {
        RootBeanDefinition authProvider = new RootBeanDefinition(OAuthAuthenticationProvider.class);
        authProvider.getPropertyValues().add(OAUTH_CONNECTOR_BEAN_NAME, (Object)new RuntimeBeanReference(OAUTH_CONNECTOR_BEAN_NAME));
        return authProvider;
    }

    private BeanDefinition createAuthenticationManager(Element element, ParserContext parserContext) {
        RootBeanDefinition authManager = new RootBeanDefinition(ProviderManager.class);
        authManager.getPropertyValues().add("parent", (Object)new RootBeanDefinition(AuthenticationManagerFactoryBean.class));
        ManagedList providers = new ManagedList();
        providers.add(new RuntimeBeanReference(AUTH_PROVIDER_BEAN_NAME));
        authManager.getPropertyValues().add("providers", (Object)providers);
        parserContext.registerBeanComponent(new BeanComponentDefinition((BeanDefinition)authManager, "authenticationManager"));
        parserContext.getRegistry().registerAlias("authenticationManager", "authenticationManager");
        parserContext.getReaderContext().fireAliasRegistered("authenticationManager", "authenticationManager", parserContext.extractSource((Object)element));
        return authManager;
    }

    private BeanDefinition createAuthenticationProcessingEntryPoint(ParserContext parserContext) {
        RootBeanDefinition authEntyPoint = new RootBeanDefinition(AuthenticationProcessingFilterEntryPoint.class);
        authEntyPoint.getPropertyValues().add(OAUTH_CONNECTOR_BEAN_NAME, (Object)new RuntimeBeanReference(OAUTH_CONNECTOR_BEAN_NAME));
        return authEntyPoint;
    }

    private BeanDefinition createAuthenticationProcessingFilter(Element element, ParserContext parserContext) {
        RootBeanDefinition authFilter = new RootBeanDefinition(AuthenticationProcessingFilter.class);
        authFilter.getPropertyValues().add("authenticationManager", (Object)new RuntimeBeanReference("authenticationManager"));
        authFilter.getPropertyValues().add("authenticationSuccessHandler", (Object)this.createAuthenticationSuccessHandler(element));
        authFilter.getPropertyValues().add(OAUTH_CONNECTOR_BEAN_NAME, (Object)new RuntimeBeanReference(OAUTH_CONNECTOR_BEAN_NAME));
        String value = element.getAttribute(LOGIN_URL_ATTR);
        authFilter.getPropertyValues().add("filterProcessesUrl", (Object)(StringUtils.hasText((String)value) ? value : "/spring/login"));
        authFilter.getPropertyValues().add("authenticationEntryPoint", (Object)new RuntimeBeanReference(AUTH_PROCESSING_ENTRY_POINT_BEAN_NAME));
        authFilter.getPropertyValues().add("rememberMeServices", (Object)new RuntimeBeanReference(REMEMBER_ME_SERVICES_BEAN_NAME));
        return authFilter;
    }

    private BeanDefinition createAuthenticationSuccessHandler(Element element) {
        RootBeanDefinition authSuccess = new RootBeanDefinition(AuthenticationSuccessHandler.class);
        String value = element.getAttribute(DEFAULT_LOGIN_SUCCESS_ATTR);
        authSuccess.getPropertyValues().add("defaultTargetUrl", (Object)(StringUtils.hasText((String)value) ? value : "/"));
        return authSuccess;
    }

    private BeanDefinition createLogoutFilter(Element element) {
        RootBeanDefinition logout = new RootBeanDefinition(LogoutFilter.class);
        RootBeanDefinition logoutSuccessHandler = new RootBeanDefinition(LogoutSuccessHandler.class);
        String value = element.getAttribute(DEFAULT_LOGOUT_SUCCESS_ATTR);
        logoutSuccessHandler.getPropertyValues().add("defaultTargetUrl", (Object)(StringUtils.hasText((String)value) ? value : "/spring/logoutSuccess"));
        value = element.getAttribute(LOGOUT_FROM_FORCE_DOT_COM_ATTR);
        logoutSuccessHandler.getPropertyValues().add("logoutFromForceDotCom", (Object)(StringUtils.hasText((String)value) ? value : "false"));
        logoutSuccessHandler.getPropertyValues().add(OAUTH_CONNECTOR_BEAN_NAME, (Object)new RuntimeBeanReference(OAUTH_CONNECTOR_BEAN_NAME));
        logoutSuccessHandler.getPropertyValues().add(CONTEXT_SERVICE_NAME, (Object)new RuntimeBeanReference(CONTEXT_SERVICE_NAME));
        ManagedList logoutHandlers = new ManagedList();
        logoutHandlers.add(new RootBeanDefinition(ForceLogoutHandler.class));
        logoutHandlers.add(new RootBeanDefinition(SecurityContextLogoutHandler.class));
        logout.getConstructorArgumentValues().addIndexedArgumentValue(0, (Object)logoutSuccessHandler);
        logout.getConstructorArgumentValues().addIndexedArgumentValue(1, (Object)logoutHandlers);
        value = element.getAttribute(LOGOUT_URL_ATTR);
        logout.getPropertyValues().add("filterProcessesUrl", (Object)(StringUtils.hasText((String)value) ? value : "/spring/logout"));
        return logout;
    }

    private BeanDefinition createRememberMeFilter() {
        RootBeanDefinition rememberMeFilter = new RootBeanDefinition(RememberMeAuthenticationFilter.class);
        rememberMeFilter.getPropertyValues().add("rememberMeServices", (Object)new RuntimeBeanReference(REMEMBER_ME_SERVICES_BEAN_NAME));
        rememberMeFilter.getPropertyValues().add("authenticationManager", (Object)new RuntimeBeanReference("authenticationManager"));
        return rememberMeFilter;
    }

    private BeanDefinition createRememberMeServices() {
        RootBeanDefinition rememberMeServices = new RootBeanDefinition(ForceRememberMeServices.class);
        rememberMeServices.getPropertyValues().add(CONTEXT_SERVICE_NAME, (Object)new RuntimeBeanReference(CONTEXT_SERVICE_NAME));
        return rememberMeServices;
    }

    private BeanDefinition createSecurityContextService() {
        RootBeanDefinition securityContextService = new RootBeanDefinition(SecurityContextServiceImpl.class);
        securityContextService.getPropertyValues().add(CONTEXT_STORAGE_SERVICE_NAME, (Object)new RuntimeBeanReference(CONTEXT_STORAGE_SERVICE_NAME));
        securityContextService.getPropertyValues().add(USER_DATA_RETRIEVAL_SERVICE_BEAN_NAME, (Object)new RuntimeBeanReference(USER_DATA_RETRIEVAL_SERVICE_BEAN_NAME));
        return securityContextService;
    }

    private BeanDefinition createConnectionStorageFilter(Element element) {
        String storeDataInSession = element.getAttribute(STORE_DATA_IN_SESSION);
        RootBeanDefinition connectionStorageFilter = new RootBeanDefinition(ForceConnectionStorageFilter.class);
        if ("true".equalsIgnoreCase(storeDataInSession)) {
            connectionStorageFilter.getPropertyValues().add("useSession", (Object)Boolean.TRUE);
        } else {
            connectionStorageFilter.getPropertyValues().add("useSession", (Object)Boolean.FALSE);
        }
        connectionStorageFilter.getPropertyValues().add(OAUTH_CONNECTOR_BEAN_NAME, (Object)new RuntimeBeanReference(OAUTH_CONNECTOR_BEAN_NAME));
        return connectionStorageFilter;
    }

    private BeanDefinition createSecurityContextStorageService(Element element) {
        String storeDataInSession = element.getAttribute(STORE_DATA_IN_SESSION);
        String secureKeyFileName = element.getAttribute(SECURE_KEY_FILE);
        RootBeanDefinition securityContextStorageService = null;
        if ("true".equalsIgnoreCase(storeDataInSession)) {
            securityContextStorageService = new RootBeanDefinition(SecurityContextSessionStore.class);
        } else {
            securityContextStorageService = new RootBeanDefinition(SecurityContextCookieStore.class);
            securityContextStorageService.getPropertyValues().add("keyFileName", (Object)secureKeyFileName);
        }
        return securityContextStorageService;
    }

    private void validateConfiguration(NodeList children) {
        if (children.getLength() != 1 && children.getLength() != 2) {
            throw new RuntimeException("<oauth> must specify exactly one of: <oauthInfo>, <connectionUrl> or <connectionName>");
        }
        int conectionElementCount = 0;
        for (int i = 0; i < children.getLength(); ++i) {
            String name = children.item(i).getLocalName();
            if (!this.isConnectionElementName(name)) continue;
            ++conectionElementCount;
        }
        if (conectionElementCount != 1) {
            throw new RuntimeException("<oauth> must specify exactly one of: <oauthInfo>, <connectionUrl> or <connectionName>");
        }
    }

    private Node getConnectionNode(NodeList children) {
        for (int i = 0; i < children.getLength(); ++i) {
            String name = children.item(i).getLocalName();
            if (!this.isConnectionElementName(name)) continue;
            return children.item(i);
        }
        return null;
    }

    private Node getCustomDataRetrieverNode(NodeList children) {
        for (int i = 0; i < children.getLength(); ++i) {
            String name = children.item(i).getLocalName();
            if (!this.isCustomDataRetrieverElementName(name)) continue;
            return children.item(i);
        }
        return null;
    }

    private boolean isConnectionElementName(String name) {
        return NAME_CONN_NAME_ELEMENT.equals(name) || NAME_OAUTH_INFO_ELEMENT.equals(name) || NAME_CONN_URL_ELEMENT.equals(name);
    }

    private boolean isCustomDataRetrieverElementName(String name) {
        return NAME_CUSTOM_DATA_RETRIEVER_ELEMENT.equals(name);
    }
}

