/*
 * Decompiled with CFR 0.152.
 */
package com.force.sdk.springsecurity;

import com.force.sdk.connector.ForceConnectorConfig;
import com.force.sdk.connector.ForceServiceConnector;
import com.force.sdk.oauth.context.SecurityContext;
import com.sforce.ws.ConnectionException;
import com.sforce.ws.ConnectorConfig;
import com.sforce.ws.SessionRenewer;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.security.authentication.AuthenticationServiceException;
import org.springframework.security.core.Authentication;
import org.springframework.security.web.authentication.logout.LogoutHandler;

public class ForceLogoutHandler
implements LogoutHandler,
SessionRenewer {
    public void logout(HttpServletRequest request, HttpServletResponse response, Authentication authentication) {
        block3: {
            if (authentication == null || authentication.getDetails() == null || !(authentication.getDetails() instanceof SecurityContext)) {
                return;
            }
            ForceConnectorConfig config = new ForceConnectorConfig();
            try {
                SecurityContext sc = (SecurityContext)authentication.getDetails();
                request.setAttribute("__force_endpoint__", (Object)sc.getEndPoint());
                config.setServiceEndpoint(sc.getEndPoint());
                config.setSessionId(sc.getSessionId());
                config.setSessionRenewer((SessionRenewer)this);
                ForceServiceConnector connector = new ForceServiceConnector();
                connector.setConnectorConfig(config);
                connector.getConnection().logout();
            }
            catch (ConnectionException e) {
                if (config.getSessionId() == null) break block3;
                throw new AuthenticationServiceException("Unable to logout from Salesforce", (Throwable)e);
            }
        }
    }

    public SessionRenewer.SessionRenewalHeader renewSession(ConnectorConfig config) throws ConnectionException {
        config.setSessionId(null);
        return null;
    }
}

