/*
 * Decompiled with CFR 0.152.
 */
package com.force.sdk.oauth.userdata;

import com.force.sdk.oauth.context.ForceSecurityContext;
import com.force.sdk.oauth.context.SecurityContext;
import com.force.sdk.oauth.context.SecurityContextUtil;
import com.force.sdk.oauth.userdata.UserDataRetriever;
import com.sforce.ws.ConnectionException;

public class ForceUserDataRetriever
implements UserDataRetriever {
    private String sessionId;
    private String endpoint;
    private String refreshToken;
    private boolean storeUsername;

    @Override
    public SecurityContext retrieveUserData() throws ConnectionException {
        if (this.sessionId == null) {
            throw new IllegalArgumentException("session id must not be null");
        }
        if (this.endpoint == null) {
            throw new IllegalArgumentException("endpoint must not be null");
        }
        ForceSecurityContext sc = new ForceSecurityContext();
        sc.setSessionId(this.sessionId);
        sc.setEndPoint(this.endpoint);
        if (this.endpoint.indexOf("/services/Soap/u") > 0) {
            sc.setEndPointHost(this.endpoint.substring(0, this.endpoint.indexOf("/services/Soap/u")));
        }
        if (this.refreshToken != null) {
            sc.setRefreshToken(this.refreshToken);
        }
        SecurityContextUtil.initializeSecurityContextFromApi(sc);
        if (!this.storeUsername) {
            sc.setUserName(null);
        }
        return sc;
    }

    @Override
    public void setSessionId(String sessionId) {
        this.sessionId = sessionId;
    }

    @Override
    public void setEndpoint(String endpoint) {
        this.endpoint = endpoint;
    }

    @Override
    public void setRefreshToken(String refreshToken) {
        this.refreshToken = refreshToken;
    }

    protected String getSessionId() {
        return this.sessionId;
    }

    protected String getEndpoint() {
        return this.endpoint;
    }

    protected String getRefreshToken() {
        return this.refreshToken;
    }

    public boolean isStoreUsername() {
        return this.storeUsername;
    }

    @Override
    public void setStoreUsername(boolean storeUsername) {
        this.storeUsername = storeUsername;
    }
}

