/*
 * Decompiled with CFR 0.152.
 */
package com.force.sdk.oauth.connector;

import com.force.sdk.oauth.connector.ForceOAuthConnectionInfo;
import com.force.sdk.oauth.connector.TokenRetrievalService;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TokenRetrievalServiceImpl
implements TokenRetrievalService {
    private static final Logger LOGGER = LoggerFactory.getLogger(TokenRetrievalServiceImpl.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String retrieveToken(String hostAndPort, String params, String refreshToken, ForceOAuthConnectionInfo connInfo) throws IOException {
        URL accessURL = new URL(hostAndPort + "/services/oauth2/token");
        HttpURLConnection conn = (HttpURLConnection)accessURL.openConnection();
        conn.setDoOutput(true);
        conn.setRequestMethod("POST");
        conn.addRequestProperty("Content-Type", "application/x-www-form-urlencoded");
        PrintWriter writer = null;
        try {
            writer = new PrintWriter(new OutputStreamWriter(conn.getOutputStream()));
            writer.println(params);
        }
        catch (IOException e) {
            this.throwDetailedException(conn, e);
        }
        finally {
            if (writer != null) {
                writer.flush();
                writer.close();
            }
        }
        BufferedReader reader = null;
        String responsePayload = null;
        try {
            reader = new BufferedReader(new InputStreamReader(conn.getInputStream()));
            responsePayload = reader.readLine();
        }
        catch (IOException e) {
            this.throwDetailedException(conn, e);
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
        return responsePayload;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void throwDetailedException(HttpURLConnection conn, IOException e) throws IOException {
        BufferedReader errorIn = null;
        try {
            if (conn.getErrorStream() != null) {
                errorIn = new BufferedReader(new InputStreamReader(conn.getErrorStream()));
                String message = errorIn.readLine();
                if (message != null && !"".equals(message)) {
                    throw new IOException(message, e);
                }
                throw e;
            }
        }
        finally {
            if (errorIn != null) {
                try {
                    errorIn.close();
                }
                catch (IOException e1) {
                    LOGGER.error("Error closing error-input-stream from api call.");
                }
            }
        }
    }
}

