/*
 * Decompiled with CFR 0.152.
 */
package com.force.sdk.jpa.schema;

import com.force.sdk.jpa.ForceManagedConnection;
import com.force.sdk.jpa.ForceStoreManager;
import com.force.sdk.jpa.PersistenceUtils;
import com.force.sdk.jpa.table.TableImpl;
import com.force.sdk.jpa.table.TableName;
import com.sforce.soap.partner.DescribeSObjectResult;
import com.sforce.soap.partner.PartnerConnection;
import com.sforce.soap.partner.fault.InvalidSObjectFault;
import com.sforce.ws.ConnectionException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.store.StoreManager;
import org.datanucleus.store.schema.StoreSchemaData;
import org.datanucleus.store.schema.StoreSchemaHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ForceStoreSchemaHandler
implements StoreSchemaHandler {
    static final Logger LOGGER = LoggerFactory.getLogger((String)"com.force.sdk.jpa.schema");
    private static final int MAX_DESCRIBE_SOBJECT = 100;
    private ForceStoreManager storeManager;
    private ConcurrentHashMap<String, TableImpl> entityTables = new ConcurrentHashMap();
    private ConcurrentHashMap<String, TableImpl> tables = new ConcurrentHashMap();
    private Map<String, DescribeSObjectResult> sObjectResults;

    public ForceStoreSchemaHandler(ForceStoreManager storeManager) {
        this.storeManager = storeManager;
    }

    public void clear() {
    }

    public void createSchema(Object conn, String schemaName) {
        throw new NucleusUserException("DataNucleus doesnt currently support creation of schemas for Force.com");
    }

    public void deleteSchema(Object conn, String schemaName) {
        throw new NucleusUserException("DataNucleus doesnt currently support deletion of schemas for Force.com");
    }

    public StoreSchemaData getSchemaData(Object conn, String objName, Object[] values) {
        final TableImpl table = this.getTable(objName);
        return table == null ? null : new StoreSchemaData(){

            public Object getProperty(String name) {
                return table.getColumnByForceApiName(name);
            }

            public void addProperty(String name, Object value) {
                throw new NucleusUserException("DataNucleus doesnt currently support adding properties for Force.com schema data");
            }
        };
    }

    public void cacheDescribeSObjects(Collection<AbstractClassMetaData> classes, ForceManagedConnection mconn) {
        ArrayList<String> sObjectNames = new ArrayList<String>(classes.size());
        try {
            for (AbstractClassMetaData cmd : classes) {
                if (PersistenceUtils.hasNoSchema(cmd)) continue;
                TableName tableName = TableName.createTableName(mconn.getNamespace(), cmd);
                if (cmd.getSuperAbstractClassMetaData() != null) continue;
                sObjectNames.add(tableName.getForceApiName());
            }
            this.sObjectResults = new HashMap<String, DescribeSObjectResult>(sObjectNames.size());
            for (int siz = 0; siz < sObjectNames.size(); siz += 100) {
                int len = sObjectNames.size() - siz > 100 ? 100 : sObjectNames.size() - siz;
                List nameList = sObjectNames.subList(siz, siz + len);
                if (LOGGER.isDebugEnabled()) {
                    StringBuilder sb = new StringBuilder();
                    for (String s : nameList) {
                        if (sb.length() > 0) {
                            sb.append(", ");
                        }
                        sb.append(s);
                    }
                    LOGGER.debug("DescribeSObjects: " + sb);
                }
                DescribeSObjectResult[] results = ((PartnerConnection)mconn.getConnection()).describeSObjects(nameList.toArray(new String[nameList.size()]));
                for (int i = 0; i < results.length; ++i) {
                    this.sObjectResults.put((String)nameList.get(i), results[i]);
                }
            }
        }
        catch (InvalidSObjectFault ie) {
            LOGGER.trace("Describes sObjects failed: ", (Throwable)ie);
        }
        catch (ConnectionException x) {
            throw new NucleusException(x.getMessage(), (Throwable)x);
        }
    }

    public void clearDescribeSObjects() {
        this.sObjectResults.clear();
    }

    public TableImpl getTable(String objName) {
        return this.getTable(this.storeManager.getMetaDataManager().getMetaDataForEntityName(objName));
    }

    public TableImpl getTable(AbstractClassMetaData acmd) {
        if (acmd == null) {
            return null;
        }
        String objName = PersistenceUtils.getEntityName(acmd);
        return this.entityTables.get(objName.toLowerCase());
    }

    public TableImpl addTable(AbstractClassMetaData acmd, ForceManagedConnection conn) {
        String entityName = PersistenceUtils.getEntityName(acmd).toLowerCase();
        try {
            TableName tableName = TableName.createTableName(conn.getNamespace(), acmd);
            TableImpl tableImpl = this.tables.get(tableName.getForceApiName().toLowerCase());
            if (tableImpl == null) {
                tableImpl = new TableImpl(conn.getNamespace(), tableName, this.sObjectResults.get(tableName.getForceApiName()), conn);
                this.tables.put(tableName.getForceApiName().toLowerCase(), tableImpl);
            }
            this.entityTables.put(entityName, tableImpl);
            return tableImpl;
        }
        catch (ConnectionException e) {
            throw new NucleusException("Could not initialize table: " + entityName, (Throwable)e);
        }
    }

    public TableImpl addVirtualTable(AbstractClassMetaData acmd) {
        String entityName = PersistenceUtils.getEntityName(acmd).toLowerCase();
        TableName tableName = TableName.createTableName("", acmd);
        TableImpl tableImpl = this.tables.get(tableName.getForceApiName().toLowerCase());
        if (tableImpl == null) {
            tableImpl = new TableImpl(tableName, acmd);
            this.tables.put(tableName.getForceApiName().toLowerCase(), tableImpl);
        }
        this.entityTables.put(entityName, tableImpl);
        return tableImpl;
    }

    public StoreManager getStoreManager() {
        return this.storeManager;
    }
}

