/*
 * Decompiled with CFR 0.152.
 */
package com.force.sdk.jpa.schema;

import com.force.sdk.jpa.ForceManagedConnection;
import com.force.sdk.jpa.ForceStoreManager;
import com.force.sdk.jpa.schema.ForceAsyncResultProcessor;
import com.force.sdk.jpa.schema.SchemaDeleteProperty;
import com.force.sdk.jpa.table.ForceMetaData;
import com.sforce.soap.metadata.AsyncResult;
import com.sforce.soap.metadata.CustomField;
import com.sforce.soap.metadata.CustomObject;
import com.sforce.soap.metadata.DeployMessage;
import com.sforce.soap.metadata.DeployOptions;
import com.sforce.soap.metadata.DeployResult;
import com.sforce.soap.metadata.MetadataConnection;
import com.sforce.soap.metadata.PackageTypeMembers;
import com.sforce.ws.bind.TypeMapper;
import com.sforce.ws.parser.XmlOutputStream;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.datanucleus.exceptions.NucleusDataStoreException;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ForceSchemaWriter
extends ForceAsyncResultProcessor {
    private static final String DEPLOY_DIR = "target" + File.separator + "deploy";
    private static final String DEPLOY_ZIP_DIR = "target" + File.separator + "deploy" + File.separator + "zip";
    private static final String DELETE_MANIFEST_FILE = "destructiveChanges.xml";
    private static final String CREATE_MANIFEST_FILE = "package.xml";
    private static final String DEPLOY_ZIP = "deploy.zip";
    private static final String CUSTOM_OBJECT = "CustomObject";
    private static final String CUSTOM_FIELD = "CustomField";
    private static final String PACKAGE_VERSION = "21.0";
    private final SchemaDeleteProperty deleteProperty;
    private final Map<CustomObject, PackageTypeMembers> objects = new HashMap<CustomObject, PackageTypeMembers>();
    private final Map<CustomField, PackageTypeMembers> fields = new HashMap<CustomField, PackageTypeMembers>();

    public ForceSchemaWriter(SchemaDeleteProperty deleteProperty) {
        this.deleteProperty = deleteProperty;
    }

    public void addCustomObject(CustomObject object, AbstractClassMetaData cmd, ForceStoreManager storeManager, ForceMetaData fmd) {
        this.addCustomObject(object, this.deleteProperty.getDeleteSchema() ? !fmd.getIsReadOnlyTable() : !fmd.getTableImpl().getTableAlreadyExistsInOrg());
    }

    public void addCustomObject(CustomObject object, boolean includeInPackageFile) {
        PackageTypeMembers type = null;
        if (includeInPackageFile) {
            type = new PackageTypeMembers();
            type.setName(CUSTOM_OBJECT);
            type.setMembers(new String[]{object.getFullName()});
        }
        this.objects.put(object, type);
    }

    public void addCustomField(CustomObject object, CustomField field) {
        if (this.deleteProperty.getDeleteSchema() && this.objects.get(object) != null) {
            return;
        }
        PackageTypeMembers type = new PackageTypeMembers();
        type.setName(CUSTOM_FIELD);
        type.setMembers(new String[]{String.format("%s.%s", object.getFullName(), field.getFullName())});
        this.fields.put(field, type);
    }

    public void write(ForceManagedConnection mconn) throws Exception {
        File deployDir = new File(DEPLOY_DIR);
        if (!deployDir.exists() && !deployDir.mkdirs()) {
            throw new NucleusUserException("Cannot create deploy staging directory: " + deployDir);
        }
        File deployZipDir = new File(DEPLOY_ZIP_DIR);
        if (!deployZipDir.exists() && !deployZipDir.mkdirs()) {
            throw new NucleusUserException("Cannot create directory for deploy zip: " + deployZipDir);
        }
        if (this.objects.size() == 0 && this.fields.size() == 0) {
            return;
        }
        ArrayList<File> schemaFiles = new ArrayList<File>();
        if (this.deleteProperty.getDeleteSchema()) {
            ForceSchemaWriter.createPackageFile(DELETE_MANIFEST_FILE, this.objects.values(), this.fields.values());
            ForceSchemaWriter.createPackageFile(CREATE_MANIFEST_FILE, null, null);
            schemaFiles.add(new File(DEPLOY_DIR, DELETE_MANIFEST_FILE));
            schemaFiles.add(new File(DEPLOY_DIR, CREATE_MANIFEST_FILE));
        } else {
            ForceSchemaWriter.createPackageFile(CREATE_MANIFEST_FILE, this.objects.values(), this.fields.values());
            schemaFiles.add(new File(DEPLOY_DIR, CREATE_MANIFEST_FILE));
            this.createSchemaFiles(schemaFiles);
        }
        DeployOptions deployOptions = new DeployOptions();
        deployOptions.setPerformRetrieve(false);
        deployOptions.setRollbackOnError(true);
        deployOptions.setSinglePackage(true);
        deployOptions.setAutoUpdatePackage(true);
        deployOptions.setAllowMissingFiles(true);
        deployOptions.setPurgeOnDelete(this.deleteProperty.getPurgeSchemaOnDelete());
        MetadataConnection metadatabinding = mconn.getMetadataConnection();
        this.createZipFile(schemaFiles.toArray(new File[schemaFiles.size()]), DEPLOY_ZIP);
        AsyncResult asyncResult = metadatabinding.deploy(this.readZipFile(DEPLOY_ZIP), deployOptions);
        this.waitForAsyncResult(metadatabinding, new AsyncResult[]{asyncResult}, true, DEPLOY_ZIP);
        DeployResult result = metadatabinding.checkDeployStatus(asyncResult.getId());
        StringBuilder buf = new StringBuilder();
        if (result.getMessages() != null) {
            for (DeployMessage rm : result.getMessages()) {
                if (rm.getProblem() == null) continue;
                buf.append("Error deploying: " + rm.getFileName() + " - " + rm.getProblem() + " \n ");
            }
        }
        if (buf.length() > 0) {
            LOGGER.error("Deploy warnings:\n" + buf);
            throw new NucleusDataStoreException(buf.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createSchemaFiles(List<File> schemaFiles) throws IOException {
        TypeMapper typeMapper = new TypeMapper();
        for (CustomObject obj : this.objects.keySet()) {
            File f = new File(DEPLOY_DIR, obj.getFullName() + ".object");
            if (!f.exists()) {
                f.createNewFile();
            }
            FileOutputStream fos = new FileOutputStream(f);
            XmlOutputStream xout = new XmlOutputStream((OutputStream)fos, true);
            xout.setPrefix("", "http://soap.sforce.com/2006/04/metadata");
            try {
                xout.startDocument();
                obj.write(new QName("http://soap.sforce.com/2006/04/metadata", CUSTOM_OBJECT), xout, typeMapper);
            }
            finally {
                xout.endDocument();
                xout.close();
                fos.close();
            }
            schemaFiles.add(f);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createZipFile(File[] files, String zipFileName) throws IOException {
        File resultsFile = new File(DEPLOY_ZIP_DIR, zipFileName);
        ZipOutputStream zos = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(resultsFile)));
        byte[] buf = new byte[8092];
        try {
            for (File file : files) {
                String filename = file.getName();
                if (file.getName().endsWith(".object")) {
                    filename = "objects/" + filename;
                }
                LOGGER.debug("Adding file to zip: " + file.getAbsolutePath());
                zos.putNextEntry(new ZipEntry(filename));
                BufferedInputStream src = new BufferedInputStream(new FileInputStream(file));
                try {
                    int len;
                    while ((len = src.read(buf)) > 0) {
                        zos.write(buf, 0, len);
                    }
                }
                finally {
                    src.close();
                }
                zos.closeEntry();
            }
            LOGGER.debug("Results written to " + resultsFile.getAbsolutePath());
        }
        finally {
            zos.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] readZipFile(String fileName) throws Exception {
        File deployZip = new File(DEPLOY_ZIP_DIR, fileName);
        if (!deployZip.exists() || !deployZip.isFile()) {
            throw new Exception("Cannot find the zip file to deploy. Looking for " + deployZip.getAbsolutePath());
        }
        ByteArrayOutputStream bos = null;
        BufferedInputStream is = new BufferedInputStream(new FileInputStream(deployZip));
        try {
            bos = new ByteArrayOutputStream();
            int readbyte = -1;
            while ((readbyte = ((InputStream)is).read()) != -1) {
                bos.write(readbyte);
            }
        }
        finally {
            try {
                ((InputStream)is).close();
            }
            finally {
                bos.close();
            }
        }
        return bos.toByteArray();
    }

    private static void createPackageFile(String fileName, Collection<PackageTypeMembers> objects, Collection<PackageTypeMembers> fields) throws ParserConfigurationException, TransformerException, IOException {
        Element name;
        Element members;
        Element t;
        DocumentBuilder db = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        Document d = db.newDocument();
        Element p = d.createElementNS("http://soap.sforce.com/2006/04/metadata", "Package");
        Element version = d.createElement("version");
        version.appendChild(d.createTextNode(PACKAGE_VERSION));
        p.appendChild(version);
        if (fields != null && fields.size() > 0) {
            t = d.createElement("types");
            for (PackageTypeMembers type : fields) {
                members = d.createElement("members");
                members.appendChild(d.createTextNode(type.getMembers()[0]));
                t.appendChild(members);
            }
            name = d.createElement("name");
            name.appendChild(d.createTextNode(CUSTOM_FIELD));
            t.appendChild(name);
            p.appendChild(t);
        }
        if (objects != null && objects.size() > 0) {
            t = d.createElement("types");
            for (PackageTypeMembers type : objects) {
                if (type == null) continue;
                members = d.createElement("members");
                members.appendChild(d.createTextNode(type.getMembers()[0]));
                t.appendChild(members);
            }
            name = d.createElement("name");
            name.appendChild(d.createTextNode(CUSTOM_OBJECT));
            t.appendChild(name);
            p.appendChild(t);
        }
        d.appendChild(p);
        TransformerFactory tf = TransformerFactory.newInstance();
        Transformer tx = tf.newTransformer();
        DOMSource source = new DOMSource(d);
        StreamResult result = new StreamResult(new File(DEPLOY_DIR, fileName));
        tx.setOutputProperty("indent", "yes");
        tx.transform(source, result);
    }
}

