/*
 * Decompiled with CFR 0.152.
 */
package com.force.sdk.jpa.query;

import com.force.sdk.jpa.ForceManagedConnection;
import com.force.sdk.jpa.query.ForceQueryUtils;
import com.force.sdk.jpa.query.QueryListener;
import com.force.sdk.jpa.query.QueryNotifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.query.evaluator.JPQLEvaluator;
import org.datanucleus.store.ExecutionContext;
import org.datanucleus.store.query.AbstractJPQLQuery;
import org.datanucleus.store.query.AbstractJavaQuery;
import org.datanucleus.store.query.Query;
import org.datanucleus.util.NucleusLogger;

public class JPQLQuery
extends AbstractJPQLQuery
implements QueryNotifier {
    private Map<String, QueryListener> listeners = new HashMap<String, QueryListener>(4);

    public JPQLQuery(ExecutionContext ec) {
        this(ec, (AbstractJPQLQuery)null);
    }

    public JPQLQuery(ExecutionContext ec, AbstractJPQLQuery q) {
        super(ec, q);
    }

    public JPQLQuery(ExecutionContext ec, String query) {
        super(ec, query);
    }

    protected Object performExecute(Map parameters) {
        if (this.type == 1) {
            throw new NucleusException("Bulk Update is not yet supported");
        }
        ForceManagedConnection mconn = (ForceManagedConnection)this.ec.getStoreManager().getConnection(this.ec);
        try {
            long startTime = System.currentTimeMillis();
            if (NucleusLogger.QUERY.isDebugEnabled()) {
                NucleusLogger.QUERY.debug((Object)LOCALISER.msg("021046", (Object)"JPQL", (Object)this.getSingleStringQuery(), null));
            }
            Object results = null;
            if (this.type == 2) {
                results = new ForceQueryUtils(this.ec, mconn, (AbstractJavaQuery)this, parameters, this.listeners, this.getExtensions()).deleteObjectsOfCandidateType(this.candidateClass != null ? this.candidateClass : this.getFrom());
            } else if (this.candidateCollection == null) {
                List<Object> rawResults = new ForceQueryUtils(this.ec, mconn, (AbstractJavaQuery)this, parameters, this.listeners, this.getExtensions()).getObjectsOfCandidateType(this.compilation.getExprResult());
                if (ForceQueryUtils.getLimitType((Query)this) == ForceQueryUtils.LimitType.Java) {
                    JPQLEvaluator resultMapper = new JPQLEvaluator((Query)this, rawResults, this.compilation, parameters, this.ec.getClassLoaderResolver());
                    results = resultMapper.execute(false, false, false, false, true);
                } else {
                    results = rawResults;
                }
            } else {
                ArrayList candidates = new ArrayList(this.candidateCollection);
                JPQLEvaluator resultMapper = new JPQLEvaluator((Query)this, candidates, this.compilation, parameters, this.ec.getClassLoaderResolver());
                results = resultMapper.execute(true, true, true, true, true);
            }
            if (NucleusLogger.QUERY.isDebugEnabled()) {
                NucleusLogger.QUERY.debug((Object)LOCALISER.msg("021074", (Object)"JPQL", (Object)("" + (System.currentTimeMillis() - startTime))));
            }
            Long l = results;
            return l;
        }
        catch (NucleusException ne) {
            throw ne;
        }
        catch (Exception e) {
            throw new NucleusException(e.getMessage(), (Throwable)e);
        }
        finally {
            mconn.release();
        }
    }

    @Override
    public void addListener(String name, QueryListener listener) {
        this.listeners.put(name, listener);
    }

    @Override
    public void removeListener(String name) {
        this.listeners.remove(name);
    }
}

