/*
 * Decompiled with CFR 0.152.
 */
package com.force.sdk.jpa.annotation;

import com.force.sdk.jpa.annotation.CustomField;
import com.force.sdk.jpa.annotation.CustomObject;
import com.force.sdk.jpa.annotation.JoinFilter;
import com.force.sdk.jpa.annotation.PicklistValue;
import com.force.sdk.jpa.schema.ForceClassMetaData;
import com.force.sdk.jpa.schema.ForceMemberMetaData;
import java.lang.reflect.Method;
import java.util.HashMap;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.MetaData;
import org.datanucleus.metadata.MetaDataManager;
import org.datanucleus.metadata.PackageMetaData;
import org.datanucleus.metadata.annotations.AbstractAnnotationReader;
import org.datanucleus.metadata.annotations.AnnotationObject;
import org.datanucleus.metadata.annotations.Member;

public class ForceAnnotationReader
extends AbstractAnnotationReader {
    public ForceAnnotationReader(MetaDataManager mgr) {
        super(mgr);
        this.setSupportedAnnotationPackages(new String[]{ForceAnnotationReader.class.getPackage().getName()});
    }

    protected AbstractClassMetaData processClassAnnotations(PackageMetaData pmd, Class cls, AnnotationObject[] annotations, ClassLoaderResolver clr) {
        ForceClassMetaData acmd = new ForceClassMetaData(pmd, cls.getSimpleName());
        if (annotations != null && annotations.length > 0) {
            for (int i = 0; i < annotations.length; ++i) {
                AnnotationObject annotation = annotations[i];
                if (annotation.getName().equals(CustomObject.class.getName())) {
                    HashMap nameValues = annotation.getNameValueMap();
                    for (Method m : CustomObject.class.getDeclaredMethods()) {
                        Object value = nameValues.get(m.getName());
                        if (value == null || value.equals(m.getDefaultValue())) continue;
                        acmd.addExtension("force", m.getName(), value.toString());
                    }
                    continue;
                }
                throw new NucleusUserException("Unknown Force.com annotation: " + annotation.getName());
            }
        }
        return acmd;
    }

    protected AbstractMemberMetaData processMemberAnnotations(AbstractClassMetaData cmd, Member member, AnnotationObject[] annotations, boolean propertyAccessor) {
        AbstractMemberMetaData mmd = null;
        if (annotations != null && annotations.length > 0) {
            for (int i = 0; i < annotations.length; ++i) {
                AnnotationObject annotation = annotations[i];
                if (annotation.getName().equals(CustomField.class.getName())) {
                    mmd = this.addForceExtension(cmd, member, annotation, CustomField.class, "", mmd);
                    continue;
                }
                if (annotation.getName().equals(PicklistValue.class.getName())) {
                    mmd = this.addForceExtension(cmd, member, annotation, PicklistValue.class, "pv.", mmd);
                    continue;
                }
                if (annotation.getName().equals(JoinFilter.class.getName())) {
                    mmd = this.addForceExtension(cmd, member, annotation, JoinFilter.class, "jf.", mmd);
                    continue;
                }
                throw new NucleusUserException("Unknown Force.com annotation: " + annotation.getName());
            }
        }
        if (mmd != null) {
            cmd.addMember(mmd);
        }
        return mmd;
    }

    private AbstractMemberMetaData addForceExtension(AbstractClassMetaData cmd, Member member, AnnotationObject annotation, Class<?> clazz, String prefix, AbstractMemberMetaData mmd) {
        mmd = mmd == null ? new ForceMemberMetaData((MetaData)cmd, member.getName()) : mmd;
        HashMap nameValues = annotation.getNameValueMap();
        for (Method m : clazz.getDeclaredMethods()) {
            Object value = nameValues.get(m.getName());
            if (value == null || value.equals(m.getDefaultValue())) continue;
            String strValue = "";
            if (value instanceof Class) {
                for (Object o : ((Class)value).getEnumConstants()) {
                    strValue = strValue + (strValue.length() == 0 ? ((Enum)o).name() : "," + ((Enum)o).name());
                }
            } else {
                strValue = value.toString();
            }
            mmd.addExtension("force", prefix + m.getName(), strValue);
        }
        return mmd;
    }

    protected void processMethodAnnotations(AbstractClassMetaData cmd, Method method) {
    }
}

