/*
 * Decompiled with CFR 0.152.
 */
package com.force.sdk.jpa;

import com.force.sdk.jpa.table.ForceColumnMetaData;
import com.sforce.soap.metadata.FieldType;
import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.OMFContext;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.ColumnMetaData;
import org.datanucleus.metadata.ElementMetaData;
import org.datanucleus.metadata.ExtensionMetaData;
import org.datanucleus.metadata.FieldPersistenceModifier;
import org.datanucleus.metadata.InheritanceStrategy;
import org.datanucleus.metadata.MetaData;
import org.datanucleus.metadata.MetaDataManager;

public final class PersistenceUtils {
    public static final String PICKLIST_VALUE_FIELD_PREFIX = "pv.";
    public static final String JOIN_FILTER = "jf.";

    private PersistenceUtils() {
    }

    public static String getEntityName(AbstractClassMetaData acmd) {
        Map<String, String> extensions = PersistenceUtils.getForceExtensions((MetaData)acmd);
        String name = extensions.get("name") != null ? extensions.get("name") : acmd.getEntityName();
        return name != null ? name : acmd.getName();
    }

    public static boolean hasNoSchema(AbstractClassMetaData acmd) {
        return acmd.isEmbeddedOnly() || acmd.getInheritanceMetaData() != null && acmd.getInheritanceMetaData().getStrategy() == InheritanceStrategy.SUBCLASS_TABLE;
    }

    public static boolean isReadOnlySchema(AbstractClassMetaData acmd, boolean checkHierarchy) {
        boolean isReadOnlySchema = false;
        do {
            isReadOnlySchema = PersistenceUtils.isReadOnlySchemaInternal(acmd);
            acmd = acmd.getSuperAbstractClassMetaData();
        } while (!isReadOnlySchema && checkHierarchy && acmd != null);
        return isReadOnlySchema;
    }

    private static boolean isReadOnlySchemaInternal(AbstractClassMetaData acmd) {
        Map<String, String> extensions = PersistenceUtils.getForceExtensions((MetaData)acmd);
        String value = extensions.get("readOnlySchema");
        if (value == null) {
            value = extensions.get("virtualSchema");
        }
        return value != null && Boolean.valueOf(value) != false;
    }

    private static boolean isReadOnlyFieldSchema(AbstractMemberMetaData ammd, OMFContext omf) {
        AbstractClassMetaData owningAcmd = omf.getMetaDataManager().getMetaDataForClass(ammd.getClassName(), omf.getClassLoaderResolver(null));
        return PersistenceUtils.isReadOnlySchemaInternal(owningAcmd);
    }

    public static boolean isVirtualSchema(AbstractClassMetaData acmd) {
        Map<String, String> extensions = PersistenceUtils.getForceExtensions((MetaData)acmd);
        String value = extensions.get("virtualSchema");
        return value != null && Boolean.valueOf(value) != false;
    }

    public static boolean isNonPersistedColumn(AbstractMemberMetaData ammd) {
        return ammd.getPersistenceModifier() != FieldPersistenceModifier.PERSISTENT;
    }

    public static Map<String, String> getForceExtensions(MetaData md) {
        HashMap<String, String> map = new HashMap<String, String>(4);
        ExtensionMetaData[] extensions = md.getExtensions();
        if (extensions != null && extensions.length > 0) {
            for (ExtensionMetaData e : extensions) {
                if (!"force".equals(e.getVendorName())) continue;
                map.put(e.getKey(), e.getValue());
            }
        }
        return map;
    }

    public static FieldType getFieldTypeFromForceAnnotation(Map<String, String> extensions) {
        String value = extensions.get("type");
        return value != null ? FieldType.valueOf((String)value) : null;
    }

    public static boolean isOrdinalEnum(AbstractMemberMetaData ammd) {
        ColumnMetaData[] cmds = ammd.getColumnMetaData();
        if (cmds != null && cmds.length > 0 && "INTEGER".equals(cmds[0].getJdbcType())) {
            return true;
        }
        Enumerated enumerated = ((AccessibleObject)((Object)ammd.getMemberRepresented())).getAnnotation(Enumerated.class);
        return enumerated != null && (enumerated.value() == null || enumerated.value() == EnumType.ORDINAL);
    }

    public static boolean isMultiPicklist(AbstractMemberMetaData ammd) {
        if (ammd.getMemberRepresented() == null) {
            return false;
        }
        return ((AccessibleObject)((Object)ammd.getMemberRepresented())).isAnnotationPresent(Enumerated.class) && (ammd.getType().isArray() && ammd.getType().getComponentType().isEnum() || ammd.getType() == String[].class);
    }

    public static boolean isRelationship(AbstractMemberMetaData ammd) {
        AccessibleObject methodOrProp = (AccessibleObject)((Object)ammd.getMemberRepresented());
        if (methodOrProp == null) {
            return false;
        }
        return methodOrProp.isAnnotationPresent(OneToMany.class) || methodOrProp.isAnnotationPresent(ManyToOne.class);
    }

    public static Object getMemberValue(AbstractClassMetaData acmd, int position, Object entity) throws IllegalAccessException, InvocationTargetException {
        return PersistenceUtils.getMemberValue(acmd.getMetaDataForManagedMemberAtAbsolutePosition(position).getMemberRepresented(), entity);
    }

    public static Object getMemberValue(Member member, Object entity) throws IllegalAccessException, InvocationTargetException {
        if (member instanceof Method) {
            Method m = (Method)member;
            if (!m.isAccessible()) {
                m.setAccessible(true);
            }
            return m.invoke(entity, (Object[])null);
        }
        if (member instanceof Field) {
            Field f = (Field)member;
            if (!f.isAccessible()) {
                f.setAccessible(true);
            }
            return f.get(entity);
        }
        return null;
    }

    public static <T extends Annotation> T getMemberAnnotation(Member member, Class<T> annotationClass) {
        if (member instanceof Method) {
            Method m = (Method)member;
            return m.getAnnotation(annotationClass);
        }
        if (member instanceof Field) {
            Field f = (Field)member;
            return f.getAnnotation(annotationClass);
        }
        return null;
    }

    public static void setFieldValue(Class clazz, AbstractClassMetaData acmd, int position, Object entity, Object value) throws SecurityException, NoSuchFieldException, IllegalArgumentException, IllegalAccessException {
        Field field = clazz.getDeclaredField(acmd.getMetaDataForManagedMemberAtAbsolutePosition(position).getName());
        if (!field.isAccessible()) {
            field.setAccessible(true);
        }
        field.set(entity, value);
    }

    private static String getForceApiRelationshipName(AbstractMemberMetaData ammd, Map<String, String> extensions, OMFContext omf) {
        String relationshipName;
        AbstractClassMetaData acmd = PersistenceUtils.getMemberElementClassMetaData(ammd, omf.getClassLoaderResolver(null), omf.getMetaDataManager());
        AbstractMemberMetaData mmd = acmd.getMetaDataForMember(ammd.getMappedBy());
        if (mmd == null) {
            throw new NucleusUserException("Cannot access mappedBy field " + ammd.getMappedBy() + " on entity " + acmd.getName() + " at " + ammd.getFullFieldName());
        }
        String tableName = acmd.getEntityName();
        String fieldNameNoSuffix = PersistenceUtils.getFieldName(mmd, extensions);
        extensions = PersistenceUtils.getForceExtensions((MetaData)mmd);
        String childRelationshipName = extensions.get("childRelationshipName");
        String string = relationshipName = childRelationshipName != null ? childRelationshipName : String.format("%s_%ss", fieldNameNoSuffix, tableName);
        if (relationshipName.length() > 40) {
            relationshipName = relationshipName.substring(0, 40);
        }
        return relationshipName;
    }

    public static String getForceApiName(AbstractMemberMetaData ammd, OMFContext omf) {
        Map<String, String> extensions = PersistenceUtils.getForceExtensions((MetaData)ammd);
        if (ammd.getCollection() != null || ammd.getMap() != null) {
            String relationshipName = PersistenceUtils.getForceApiRelationshipName(ammd, extensions, omf);
            if (PersistenceUtils.isReadOnlyFieldSchema(ammd, omf)) {
                return relationshipName;
            }
            if (!relationshipName.endsWith("__r")) {
                return relationshipName + "__r";
            }
            return relationshipName;
        }
        String fieldName = PersistenceUtils.getFieldName(ammd, extensions);
        if (ForceColumnMetaData.STANDARD_FIELDS.contains(fieldName.toLowerCase()) || PersistenceUtils.isReadOnlyFieldSchema(ammd, omf)) {
            return fieldName;
        }
        if (!fieldName.endsWith("__c")) {
            return fieldName + "__c";
        }
        return fieldName;
    }

    public static String prependNamespace(String namespace, String name) {
        return namespace == null ? name : String.format("%s__%s", namespace, name);
    }

    public static AbstractClassMetaData getMemberElementClassMetaData(AbstractMemberMetaData ammd, ClassLoaderResolver clr, MetaDataManager mdm) {
        if (ammd.getCollection() != null) {
            return ammd.getCollection().getElementClassMetaData(clr, mdm);
        }
        if (ammd.getMap() != null) {
            return ammd.getMap().getValueClassMetaData(clr, mdm);
        }
        return mdm.getMetaDataForClass(ammd.getType(), clr);
    }

    public static String getFieldName(AbstractMemberMetaData ammd, Map<String, String> extensions) {
        String fieldName = extensions.get("name");
        if (fieldName != null) {
            return fieldName;
        }
        fieldName = PersistenceUtils.getFieldNameFromJPAAnnotation(ammd);
        if (fieldName == null) {
            fieldName = ammd.getName();
        }
        if (fieldName.indexOf(":") > -1) {
            fieldName = fieldName.substring(fieldName.indexOf(":") + 1);
        }
        return fieldName;
    }

    public static String getFieldNameFromJPAAnnotation(AbstractMemberMetaData ammd) {
        String fieldName = null;
        ColumnMetaData[] colmds = ammd.getColumnMetaData();
        if (colmds != null && colmds.length > 0) {
            fieldName = colmds[0].getName();
        } else {
            ElementMetaData elemmd = ammd.getElementMetaData();
            if (elemmd != null && (colmds = elemmd.getColumnMetaData()) != null && colmds.length > 0) {
                fieldName = colmds[0].getName();
            }
        }
        return fieldName;
    }
}

