/*
 * Decompiled with CFR 0.152.
 */
package com.force.sdk.jpa;

import com.force.sdk.jpa.ForceEntityManager;
import com.force.sdk.jpa.ForceManagedConnection;
import com.force.sdk.jpa.ForceStoreManager;
import com.force.sdk.jpa.PersistenceUtils;
import com.force.sdk.jpa.model.ForceOwner;
import com.force.sdk.jpa.table.ColumnImpl;
import com.force.sdk.jpa.table.TableImpl;
import com.sforce.ws.ConnectionException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.HashSet;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.OMFContext;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.jpa.metadata.JPAMetaDataManager;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.ClassMetaData;
import org.datanucleus.metadata.DiscriminatorMetaData;
import org.datanucleus.metadata.FileMetaData;
import org.datanucleus.metadata.PackageMetaData;
import org.datanucleus.metadata.PersistenceUnitMetaData;
import org.datanucleus.util.NucleusLogger;
import org.datanucleus.util.StringUtils;

public class ForceMetaDataManager
extends JPAMetaDataManager {
    public ForceMetaDataManager(OMFContext ctxt) {
        super(ctxt);
    }

    public FileMetaData[] loadPersistenceUnit(PersistenceUnitMetaData pumd, ClassLoader loader) {
        int j;
        PackageMetaData pmd;
        int i;
        FileMetaData[] fileMD;
        if (!this.omfContext.getPersistenceConfiguration().hasProperty("force.ConnectionName")) {
            if (pumd.getName() != null && pumd.getName().length() != 0) {
                this.omfContext.getPersistenceConfiguration().setProperty("force.ConnectionName", (Object)pumd.getName());
            } else if (this.omfContext.getPersistenceConfiguration().getStringProperty("datanucleus.ConnectionUrl") == null) {
                throw new NucleusUserException("Must specify unit name or connection url");
            }
        }
        ForceStoreManager storeManager = (ForceStoreManager)this.omfContext.getStoreManager();
        if ((pumd.getClassNames() == null || pumd.getClassNames().size() == 0) && "jar".equals(pumd.getRootURI().getScheme())) {
            try {
                String path = pumd.getRootURI().getSchemeSpecificPart();
                pumd.addJarFile(new URL(path.substring(0, path.length() - 1)));
            }
            catch (MalformedURLException ue) {
                throw new NucleusUserException(ue.getMessage());
            }
        }
        if (loader == null) {
            loader = Thread.currentThread().getContextClassLoader();
        }
        pumd.addClassName(ForceOwner.class.getName());
        for (FileMetaData md : fileMD = super.loadPersistenceUnit(pumd, loader)) {
            for (i = 0; i < md.getNoOfPackages(); ++i) {
                pmd = md.getPackage(i);
                for (j = 0; j < pmd.getNoOfClasses(); ++j) {
                    ClassLoaderResolver clr = this.omfContext.getClassLoaderResolver(null);
                    ClassMetaData cmd = pmd.getClass(j);
                    Class c = null;
                    String className = cmd.getFullClassName();
                    try {
                        c = loader == null ? Class.forName(className) : clr.classForName(className, null, false);
                    }
                    catch (ClassNotFoundException e) {
                        throw new NucleusException(e.getMessage());
                    }
                    this.createSchema(cmd, clr.classForName(cmd.getFullClassName(), c.getClassLoader()), clr, storeManager);
                    continue;
                }
            }
        }
        new ClassInitializer(){

            @Override
            void init(AbstractClassMetaData cmd, ForceStoreManager storeManager, ForceManagedConnection mconn) throws ConnectionException {
                TableImpl table = storeManager.getTable(cmd);
                table.getMetaData(cmd).emit(storeManager, mconn);
            }
        }.initialize(fileMD, storeManager);
        try {
            storeManager.getSchemaWriter().write(storeManager.createConnection());
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new NucleusException(e.getMessage(), (Throwable)e);
        }
        new ClassInitializer(){

            @Override
            void init(AbstractClassMetaData cmd, ForceStoreManager storeManager, ForceManagedConnection mconn) throws ConnectionException {
                TableImpl table = storeManager.getTable(cmd);
                if (!table.isValid()) {
                    table.refresh(null, mconn);
                }
            }
        }.initialize(fileMD, storeManager);
        for (FileMetaData md : fileMD) {
            for (i = 0; i < md.getNoOfPackages(); ++i) {
                pmd = md.getPackage(i);
                for (j = 0; j < pmd.getNoOfClasses(); ++j) {
                    ClassMetaData cmd = pmd.getClass(j);
                    if (PersistenceUtils.hasNoSchema((AbstractClassMetaData)cmd) && cmd.getTable() == null) continue;
                    try {
                        this.populateFieldNames((AbstractClassMetaData)cmd, this.getOMFContext());
                        continue;
                    }
                    catch (ConnectionException ex) {
                        throw new NucleusException("Exception during initialization", (Throwable)ex);
                    }
                }
            }
        }
        return fileMD;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createSchema(ClassMetaData cmd, Class cls, ClassLoaderResolver clr, ForceStoreManager storeManager) {
        ClassMetaData classMetaData = cmd;
        synchronized (classMetaData) {
            ForceManagedConnection mconn = storeManager.createConnection();
            TableImpl table = storeManager.getTable((AbstractClassMetaData)cmd);
            if (PersistenceUtils.hasNoSchema((AbstractClassMetaData)cmd)) {
                return;
            }
            if (storeManager.isAutoCreateTables() && (!table.getTableAlreadyExistsInOrg() || storeManager.isForDelete()) && !PersistenceUtils.isReadOnlySchema((AbstractClassMetaData)cmd, true)) {
                table.createTableAndFields((AbstractClassMetaData)cmd, storeManager, mconn);
            } else if (table.getTableAlreadyExistsInOrg() && !PersistenceUtils.isReadOnlySchema((AbstractClassMetaData)cmd, false)) {
                table.createFields((AbstractClassMetaData)cmd, storeManager);
            }
            if (!storeManager.isAutoCreateTables() && !table.getTableAlreadyExistsInOrg()) {
                StringBuilder msg = new StringBuilder(256);
                msg.append("Table does not exist in force.com and datanucleus.autoCreateTables is false, table: ").append(table.getTableName().getForceApiName());
                if (storeManager.isAutoCreateWarnOnError()) {
                    ForceEntityManager.LOGGER.warn(msg.toString());
                } else {
                    throw new NucleusUserException(msg.toString());
                }
            }
        }
    }

    protected void initialiseFileMetaDataForUse(Collection fileMetaData, ClassLoaderResolver clr) {
        HashSet<Exception> exceptions = new HashSet<Exception>();
        if (NucleusLogger.METADATA.isDebugEnabled()) {
            NucleusLogger.METADATA.debug((Object)LOCALISER.msg("044018"));
        }
        for (FileMetaData filemd : fileMetaData) {
            if (filemd.isInitialised()) continue;
            this.populateFileMetaData(filemd, clr, null);
        }
        ForceStoreManager storeManager = (ForceStoreManager)this.omfContext.getStoreManager();
        storeManager.preInitialiseFileMetaData(this.classMetaDataByClass.values());
        if (NucleusLogger.METADATA.isDebugEnabled()) {
            NucleusLogger.METADATA.debug((Object)LOCALISER.msg("044019"));
        }
        for (FileMetaData filemd : fileMetaData) {
            if (filemd.isInitialised()) continue;
            try {
                this.initialiseFileMetaData(filemd, clr, null);
            }
            catch (Exception e) {
                NucleusLogger.METADATA.error((Object)StringUtils.getStringFromStackTrace((Throwable)e));
                exceptions.add(e);
            }
        }
        if (exceptions.size() > 0) {
            throw new NucleusUserException(LOCALISER.msg("044020"), exceptions.toArray(new Throwable[exceptions.size()]));
        }
        storeManager.postInitialiseFileMetaData();
    }

    private void populateFieldNames(AbstractClassMetaData acmd, OMFContext omf) throws ConnectionException {
        ColumnImpl col;
        DiscriminatorMetaData dmd;
        ForceStoreManager storeManager = (ForceStoreManager)this.omfContext.getStoreManager();
        TableImpl table = storeManager.getTable(acmd);
        int[] fieldNumbers = acmd.getAllMemberPositions();
        if (fieldNumbers != null && fieldNumbers.length > 0) {
            for (int column : fieldNumbers) {
                this.addColumn(table, acmd.getMetaDataForManagedMemberAtAbsolutePosition(column), omf);
            }
        }
        if ((dmd = acmd.getDiscriminatorMetaData()) != null && dmd.getColumnName() != null && (col = table.getColumnByForceApiName(dmd.getColumnName())) != null) {
            String javaFieldName = dmd.getColumnName();
            table.registerJavaColumn(javaFieldName, col);
        }
    }

    private void addColumn(TableImpl table, AbstractMemberMetaData ammd, OMFContext omf) {
        if (PersistenceUtils.isNonPersistedColumn(ammd)) {
            return;
        }
        if (ammd.getEmbeddedMetaData() != null) {
            for (AbstractMemberMetaData eammd : ammd.getEmbeddedMetaData().getMemberMetaData()) {
                this.addColumn(table, eammd, omf);
            }
        } else {
            ColumnImpl col = table.getColumnByForceApiName(PersistenceUtils.getForceApiName(ammd, omf));
            if (col != null) {
                String javaFieldName = ammd.getName();
                table.registerJavaColumn(javaFieldName, col);
            }
        }
    }

    private static abstract class ClassInitializer {
        private ClassInitializer() {
        }

        abstract void init(AbstractClassMetaData var1, ForceStoreManager var2, ForceManagedConnection var3) throws ConnectionException;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void initialize(FileMetaData[] fileMD, ForceStoreManager storeManager) {
            for (FileMetaData md : fileMD) {
                for (int i = 0; i < md.getNoOfPackages(); ++i) {
                    PackageMetaData pmd = md.getPackage(i);
                    for (int j = 0; j < pmd.getNoOfClasses(); ++j) {
                        ClassMetaData cmd = pmd.getClass(j);
                        if (PersistenceUtils.hasNoSchema((AbstractClassMetaData)cmd) && cmd.getTable() == null) continue;
                        try {
                            ForceManagedConnection mconn = storeManager.createConnection();
                            try {
                                this.init((AbstractClassMetaData)cmd, storeManager, mconn);
                                continue;
                            }
                            finally {
                                mconn.close();
                            }
                        }
                        catch (ConnectionException ex) {
                            throw new NucleusException("Exception during initialization", (Throwable)ex);
                        }
                    }
                }
            }
        }
    }
}

