/*
 * Decompiled with CFR 0.152.
 */
package com.force.sdk.jpa;

import com.force.sdk.jpa.ForceManagedConnection;
import com.force.sdk.jpa.ForceStoreManager;
import com.force.sdk.jpa.PersistenceUtils;
import com.force.sdk.jpa.annotation.ForceAnnotationReader;
import com.force.sdk.jpa.schema.ForceClassMetaData;
import java.util.Calendar;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.ColumnMetaData;
import org.datanucleus.metadata.ExtensionMetaData;
import org.datanucleus.metadata.IdentityStrategy;
import org.datanucleus.metadata.IdentityType;
import org.datanucleus.metadata.InheritanceStrategy;
import org.datanucleus.metadata.InvalidMetaDataException;
import org.datanucleus.metadata.MetaDataListener;
import org.datanucleus.util.Localiser;

public class ForceMetaDataListener
implements MetaDataListener {
    protected static final Localiser LOCALISER = Localiser.getInstance((String)"org.datanucleus.Localisation", (ClassLoader)ForceStoreManager.class.getClassLoader());
    private ForceStoreManager storeManager;
    private ForceAnnotationReader annotationReader;

    ForceMetaDataListener(ForceStoreManager storeManager) {
        this.storeManager = storeManager;
        this.annotationReader = new ForceAnnotationReader(storeManager.getMetaDataManager());
    }

    public void loaded(AbstractClassMetaData cmd) {
        if (cmd.getIdentityType() == IdentityType.DATASTORE && !cmd.isEmbeddedOnly()) {
            throw new InvalidMetaDataException(LOCALISER, "force.DatastoreID", (Object)cmd.getFullClassName());
        }
        this.updateAnnotations(cmd);
        this.validateExtensions(cmd);
        this.registerObjectSchema(cmd);
    }

    private void updateAnnotations(AbstractClassMetaData cmd) {
        ClassLoaderResolver clr = this.storeManager.getOMFContext().getClassLoaderResolver(((Object)((Object)this.storeManager)).getClass().getClassLoader());
        Class clazz = clr.classForName(cmd.getFullClassName());
        AbstractClassMetaData cmdNew = this.annotationReader.getMetaDataForClass(clazz, cmd.getPackageMetaData(), clr);
        ExtensionMetaData[] extensions = cmdNew.getExtensions();
        if (extensions != null && extensions.length > 0) {
            for (ExtensionMetaData e : extensions) {
                if (!"force".equals(e.getVendorName())) continue;
                cmd.addExtension("force", e.getKey(), e.getValue());
            }
        }
        for (AbstractMemberMetaData ammdNew : ((ForceClassMetaData)cmdNew).getMembers()) {
            AbstractMemberMetaData ammd = cmd.getMetaDataForMember(ammdNew.getName());
            for (ExtensionMetaData e : ammdNew.getExtensions()) {
                ammd.addExtension(e.getVendorName(), e.getKey(), e.getValue());
            }
        }
    }

    private void validateExtensions(AbstractClassMetaData cmd) {
        AbstractClassMetaData superClass;
        if (cmd.getJoinMetaData() != null && cmd.getJoinMetaData().length > 0) {
            throw new NucleusUserException("Secondary tables are not supported by Force.com datastore. Offending entity: " + cmd.getFullClassName());
        }
        if (cmd.getPrimaryKeyMetaData() != null) {
            throw new NucleusUserException("@PrimaryKeyJoinColumn is not supported by Force.com datastore. Offending entity: " + cmd.getFullClassName());
        }
        if (cmd.getUniqueMetaData() != null && cmd.getUniqueMetaData().length > 0) {
            throw new NucleusUserException("@UniqueConstraint is not supported by Force.com datastore. Offending entity: " + cmd.getFullClassName());
        }
        if (cmd.getInheritanceMetaData() != null) {
            if (cmd.getInheritanceMetaData().getStrategyForTree() != null && !cmd.getInheritanceMetaData().getStrategyForTree().equals("SINGLE_TABLE")) {
                throw new NucleusUserException("Only SINGLE_TABLE inheritance strategy supported by Force.com datastore. Offending entity: " + cmd.getFullClassName());
            }
            if (cmd.getOverriddenMembers() != null && cmd.getOverriddenMembers().length > 0) {
                throw new NucleusUserException("@AttributeOverride or @AssociationOverride is not supported by Force.com datastore. Offending entity: " + cmd.getFullClassName());
            }
        }
        if ((superClass = cmd.getSuperAbstractClassMetaData()) != null && superClass.getInheritanceMetaData().getStrategy() != InheritanceStrategy.SUBCLASS_TABLE) {
            if (cmd.getDiscriminatorMetaData() != null && cmd.getDiscriminatorMetaData().getColumnMetaData() != null) {
                throw new NucleusUserException("@DiscriminatorColumn is only supported for base entity classes. Offending entity: " + cmd.getFullClassName() + " Super class: " + superClass.getFullClassName());
            }
            if (cmd.getTable() != null) {
                throw new NucleusUserException("@Table is only supported for base entity classes. Offending entity: " + cmd.getFullClassName() + " Super class: " + superClass.getFullClassName());
            }
            if (cmd.getPKMemberPositions().length > 1) {
                throw new NucleusUserException("@Id is only supported for base entity classes. Offending entity: " + cmd.getFullClassName() + " Super class: " + superClass.getFullClassName());
            }
        } else if (superClass == null && !cmd.isEmbeddedOnly()) {
            if (cmd.getPKMemberPositions().length != 1) {
                throw new NucleusUserException("Only single string column primary keys supported as ID by Force.com datastore. Offending entity: " + cmd.getFullClassName());
            }
            AbstractMemberMetaData ammd = cmd.getMetaDataForManagedMemberAtPosition(cmd.getPKMemberPositions()[0]);
            ForceMetaDataListener.checkColumnOrFieldName("id", ammd, ammd.getName(), String.class, "Primay field name should be ID. Offending entity: ", "ID field type should be String. Offending entity: ", cmd);
            if (ammd.getValueStrategy() == null || ammd.getValueStrategy() != IdentityStrategy.IDENTITY) {
                throw new NucleusUserException("@Id column requires value generation @GeneratedValue(strategy = GenerationType.IDENTITY). Offending entity: " + cmd.getFullClassName());
            }
        }
        if (cmd.isEmbeddedOnly() && cmd.getTable() != null) {
            throw new NucleusUserException("Embedded objects cannot have table specification. Offending entity: " + cmd.getFullClassName());
        }
        if (cmd.getVersionMetaData() != null) {
            ForceMetaDataListener.checkColumnOrFieldName("lastModifiedDate", cmd.getMetaDataForMember(cmd.getVersionMetaData().getFieldName()), cmd.getVersionMetaData().getFieldName(), Calendar.class, "Version field name should be lastModifiedDate. Offending entity: ", "Version field type should be Calendar or GregorianCalendar. Offending entity: ", cmd);
        }
    }

    private static void checkColumnOrFieldName(String expectedName, AbstractMemberMetaData ammd, String fieldName, Class<?> clazz, String message1, String message2, AbstractClassMetaData cmd) {
        ColumnMetaData[] columnMD = ammd.getColumnMetaData();
        if (columnMD != null && columnMD.length > 0 && columnMD[0].getName() != null ? !expectedName.equalsIgnoreCase(columnMD[0].getName()) : !expectedName.equalsIgnoreCase(fieldName)) {
            throw new NucleusUserException(message1 + cmd.getFullClassName());
        }
        if (!clazz.isAssignableFrom(ammd.getType())) {
            throw new NucleusUserException(message2 + cmd.getFullClassName());
        }
    }

    private void registerObjectSchema(AbstractClassMetaData cmd) {
        if (PersistenceUtils.hasNoSchema(cmd)) {
            return;
        }
        if (PersistenceUtils.isVirtualSchema(cmd)) {
            this.storeManager.addVirtualTable(cmd);
            return;
        }
        ForceManagedConnection mconn = null;
        try {
            mconn = this.storeManager.createConnection();
            this.storeManager.addTable(cmd, mconn);
        }
        catch (Exception e) {
            throw new NucleusException(e.getMessage(), (Throwable)e);
        }
        finally {
            if (mconn != null) {
                mconn.close();
            }
        }
    }
}

