/*
 * Decompiled with CFR 0.152.
 */
package com.force.sdk.jpa;

import com.force.sdk.jpa.ForceObjectManagerImpl;
import com.force.sdk.jpa.ForceStoreManager;
import com.force.sdk.jpa.PersistenceUtils;
import com.force.sdk.jpa.model.PicklistValueEnum;
import com.force.sdk.jpa.table.ColumnImpl;
import com.force.sdk.jpa.table.TableImpl;
import com.sforce.soap.partner.sobject.SObject;
import com.sforce.ws.types.Time;
import java.lang.reflect.InvocationTargetException;
import java.math.BigInteger;
import java.util.Calendar;
import java.util.Date;
import java.util.Random;
import org.datanucleus.ObjectManager;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.ColumnMetaData;
import org.datanucleus.metadata.FieldPersistenceModifier;
import org.datanucleus.state.ObjectProviderImpl;
import org.datanucleus.store.ObjectProvider;
import org.datanucleus.store.fieldmanager.AbstractFieldManager;

public class ForceInsertFieldManager
extends AbstractFieldManager {
    private static final Random PART_B = new Random(System.nanoTime());
    private final ObjectProvider objectProvider;
    private final ForceStoreManager storeManager;
    private final SObject sobject;
    private final TableImpl table;
    private final int pkIndexToSkip;
    private final int versionIndexToSkip;
    private boolean dirty;

    public ForceInsertFieldManager(ObjectProvider objectProvider, ForceStoreManager storeManager, Object pkValue) {
        this.objectProvider = objectProvider;
        this.storeManager = storeManager;
        this.sobject = new SObject();
        AbstractClassMetaData acmd = objectProvider.getClassMetaData();
        this.table = storeManager.getTable(acmd);
        if (this.table == null) {
            throw new NucleusUserException("Entity does not exist in Force.com datastore: " + acmd.getEntityName());
        }
        this.sobject.setType(this.table.getTableName().getForceApiName());
        if (pkValue != null) {
            this.sobject.addField(this.table.getPKFieldName(acmd), pkValue);
        } else {
            this.dirty = true;
        }
        this.pkIndexToSkip = acmd.getPKMemberPositions()[0];
        if (acmd.getVersionMetaData() != null && pkValue != null) {
            this.versionIndexToSkip = acmd.getAbsolutePositionOfMember(acmd.getVersionMetaData().getFieldName());
            Object version = objectProvider.provideField(this.versionIndexToSkip);
            if (version == null && storeManager.isEnableOptimisticTransactions()) {
                throw new NucleusUserException("Version field must be set to non-null value, field: " + acmd.getVersionMetaData().getFieldName() + " object id:" + this.sobject.getId());
            }
            objectProvider.setVersion(version);
        } else {
            this.versionIndexToSkip = -1;
        }
    }

    public SObject getSObject(boolean appendExternalId) {
        String name;
        if (appendExternalId && this.table.getExternalIdColumn() != null && this.sobject.getField(name = this.table.getExternalIdColumn().getFieldName()) == null) {
            this.sobject.setField(name, (Object)("" + System.nanoTime() + PART_B.nextInt()));
        }
        return this.sobject;
    }

    public boolean isDirty() {
        return this.dirty;
    }

    private void storeField(int fieldNumber, Object value) {
        if (value == null || fieldNumber == this.pkIndexToSkip || fieldNumber == this.versionIndexToSkip) {
            return;
        }
        AbstractMemberMetaData ammd = this.objectProvider.getClassMetaData().getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber);
        if (ammd.getEmbeddedMetaData() != null) {
            this.storeEmbeddedFields(ammd, value);
            return;
        }
        ColumnImpl column = this.table.getColumnFor(this.objectProvider.getClassMetaData(), ammd);
        if (column == null || column.getField() == null || !column.getField().isCreateable()) {
            return;
        }
        Object actualValue = value;
        String actualFieldName = column.getFieldName();
        try {
            switch (column.getType()) {
                case datetime: {
                    if (value instanceof Date) {
                        ColumnMetaData[] cmds = ammd.getColumnMetaData();
                        Calendar cal = Calendar.getInstance();
                        cal.setTime((Date)value);
                        if (cmds != null && cmds.length > 0 && "TIME".equals(cmds[0].getJdbcType())) {
                            actualValue = new Time(cal);
                            break;
                        }
                        actualValue = cal;
                        break;
                    }
                    if (!(value instanceof Time)) break;
                    actualValue = value;
                    break;
                }
                case currency: {
                    actualValue = value.toString();
                    break;
                }
                case reference: {
                    AbstractClassMetaData acmd = this.storeManager.getMetaDataManager().getMetaDataForClass(ammd.getType(), this.objectProvider.getExecutionContext().getClassLoaderResolver());
                    if (acmd != null) {
                        actualValue = PersistenceUtils.getMemberValue(acmd, acmd.getPKMemberPositions()[0], value);
                        if (actualValue != null) break;
                        ObjectManager om = ((ObjectProviderImpl)this.objectProvider).getStateManager().getObjectManager();
                        if (((ForceObjectManagerImpl)om).isInAllOrNothingMode()) {
                            SObject parentRef = new SObject();
                            TableImpl parent = this.storeManager.getTable(acmd);
                            if (parent.getExternalIdColumn() == null) {
                                throw new NucleusUserException("EntityManager in persistence.xml has 'force.AllOrNothing' set to true. In this mode all top parent Entities must have an externalId field. Offending entity: " + parent.getTableName().getName());
                            }
                            parentRef.setType(parent.getTableName().getForceApiName());
                            SObject parentSObject = ((ForceObjectManagerImpl)om).getParentSObject(value);
                            parentRef.setField(parent.getExternalIdColumn().getFieldName(), parentSObject.getField(parent.getExternalIdColumn().getFieldName()));
                            actualValue = parentRef;
                            actualFieldName = column.getForceApiRelationshipName();
                            break;
                        }
                        throw new NucleusUserException("Child entity cannot be saved before parent entity.");
                    }
                    if (ammd.getCollection() == null && ammd.getMap() == null) break;
                    return;
                }
                case multipicklist: {
                    if (value.getClass().isArray()) {
                        if (ammd.getType().getComponentType().isEnum()) {
                            Enum[] enums = (Enum[])value;
                            boolean isOrdinal = PersistenceUtils.isOrdinalEnum(ammd);
                            boolean isPicklistValue = PicklistValueEnum[].class.isAssignableFrom(enums.getClass());
                            StringBuilder sb = new StringBuilder(enums.length * 20);
                            for (Enum e : enums) {
                                if (sb.length() > 0) {
                                    sb.append(";");
                                }
                                if (isOrdinal) {
                                    sb.append(e.ordinal());
                                    continue;
                                }
                                if (isPicklistValue) {
                                    sb.append(((PicklistValueEnum)((Object)e)).value());
                                    continue;
                                }
                                sb.append(e.name());
                            }
                            actualValue = sb.toString();
                            break;
                        }
                        String[] values = (String[])value;
                        StringBuilder sb = new StringBuilder(values.length * 20);
                        for (String v : values) {
                            if (sb.length() > 0) {
                                sb.append(";");
                            }
                            sb.append(v);
                        }
                        actualValue = sb.toString();
                        break;
                    }
                }
                case picklist: {
                    if (!value.getClass().isEnum()) break;
                    Enum e = (Enum)value;
                    if (PersistenceUtils.isOrdinalEnum(ammd)) {
                        actualValue = "" + e.ordinal();
                        break;
                    }
                    if (e instanceof PicklistValueEnum) {
                        actualValue = ((PicklistValueEnum)((Object)e)).value();
                        break;
                    }
                    actualValue = e.name();
                    break;
                }
                case url: {
                    actualValue = value.toString();
                    break;
                }
                case base64: {
                    if (ammd.getType() == byte[].class || ammd.getType() == Byte[].class) {
                        actualValue = value;
                        break;
                    }
                    throw new NucleusUserException("Bad datatype for base64 encoding: " + ammd.getTypeName());
                }
            }
        }
        catch (InvocationTargetException x) {
            throw new NucleusException(x.getMessage(), (Throwable)x);
        }
        catch (IllegalAccessException x) {
            throw new NucleusException(x.getMessage(), (Throwable)x);
        }
        this.sobject.addField(actualFieldName, actualValue);
        this.dirty = true;
    }

    private void storeEmbeddedFields(AbstractMemberMetaData ammd, Object value) {
        AbstractClassMetaData cmd = this.objectProvider.getClassMetaData();
        for (AbstractMemberMetaData eammd : ammd.getEmbeddedMetaData().getMemberMetaData()) {
            if (eammd.getPersistenceModifier() != FieldPersistenceModifier.PERSISTENT) continue;
            try {
                Object newValue = PersistenceUtils.getMemberValue(eammd.getMemberRepresented(), value);
                if (eammd.getEmbeddedMetaData() != null) {
                    this.storeEmbeddedFields(eammd, newValue);
                    continue;
                }
                ColumnImpl column = this.table.getColumnFor(cmd, eammd);
                if (column == null) continue;
                this.sobject.addField(column.getFieldName(), newValue);
                this.dirty = true;
            }
            catch (Exception e) {
                throw new NucleusUserException(e.getMessage());
            }
        }
    }

    public void storeBooleanField(int fieldNumber, boolean value) {
        this.storeField(fieldNumber, value);
    }

    public void storeByteField(int fieldNumber, byte value) {
        this.storeField(fieldNumber, String.valueOf(value));
    }

    public void storeCharField(int fieldNumber, char value) {
        this.storeField(fieldNumber, String.valueOf(value));
    }

    public void storeDoubleField(int fieldNumber, double value) {
        this.storeField(fieldNumber, value);
    }

    public void storeFloatField(int fieldNumber, float value) {
        this.storeDoubleField(fieldNumber, value);
    }

    public void storeIntField(int fieldNumber, int value) {
        this.storeField(fieldNumber, value);
    }

    public void storeLongField(int fieldNumber, long value) {
        this.storeObjectField(fieldNumber, value);
    }

    public void storeObjectField(int fieldNumber, Object value) {
        if (value instanceof Long) {
            this.storeField(fieldNumber, value.toString());
        } else if (value instanceof Float) {
            this.storeField(fieldNumber, ((Float)value).doubleValue());
        } else if (value instanceof Short) {
            this.storeField(fieldNumber, ((Short)value).intValue());
        } else if (value instanceof Byte) {
            this.storeField(fieldNumber, ((Byte)value).toString());
        } else if (value instanceof BigInteger) {
            this.storeField(fieldNumber, value.toString());
        } else if (value instanceof Character) {
            this.storeField(fieldNumber, ((Character)value).toString());
        } else {
            this.storeField(fieldNumber, value);
        }
    }

    public void storeShortField(int fieldNumber, short value) {
        this.storeIntField(fieldNumber, value);
    }

    public void storeStringField(int fieldNumber, String value) {
        this.storeField(fieldNumber, value);
    }
}

