/*
 * Decompiled with CFR 0.152.
 */
package com.force.sdk.jpa;

import com.force.sdk.jpa.ForceManagedConnection;
import com.force.sdk.jpa.ForceStoreManager;
import com.force.sdk.jpa.PersistenceUtils;
import com.force.sdk.jpa.model.PicklistValueEnum;
import com.force.sdk.jpa.query.ForceQueryUtils;
import com.force.sdk.jpa.table.ColumnImpl;
import com.force.sdk.jpa.table.TableImpl;
import com.sforce.soap.partner.PartnerConnection;
import com.sforce.soap.partner.QueryResult;
import com.sforce.soap.partner.sobject.SObject;
import com.sforce.ws.ConnectionException;
import com.sforce.ws.bind.CalendarCodec;
import com.sforce.ws.bind.DateCodec;
import com.sforce.ws.bind.XmlObject;
import com.sforce.ws.types.Time;
import com.sforce.ws.util.Base64;
import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;
import java.math.RoundingMode;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.DecimalFormat;
import java.text.ParsePosition;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.regex.Pattern;
import javax.jdo.identity.StringIdentity;
import org.datanucleus.exceptions.NucleusObjectNotFoundException;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.store.ExecutionContext;
import org.datanucleus.store.ObjectProvider;
import org.datanucleus.store.Type;
import org.datanucleus.store.fieldmanager.AbstractFieldManager;
import org.datanucleus.store.query.Query;
import org.datanucleus.store.types.sco.SCOUtils;

public class ForceFetchFieldManager
extends AbstractFieldManager {
    private static final Pattern MULTI_SELECT_VALUE_SEPARATOR = Pattern.compile(";");
    private static final Pattern NO_PROTOCOL_URL_PATTERN = Pattern.compile("^(:|/)*[.]*");
    private final ObjectProvider objectProvider;
    private final ExecutionContext ec;
    private final AbstractClassMetaData acmd;
    private final ForceStoreManager storeManager;
    private final ForceManagedConnection mconn;
    private final XmlObject sobject;
    private final TableImpl table;
    private final Query query;

    public ForceFetchFieldManager(ObjectProvider objectProvider, ForceStoreManager storeManager, ForceManagedConnection mconn, Object pkValue, int[] fieldNumbers, Query query) throws ConnectionException {
        this.objectProvider = objectProvider;
        this.ec = objectProvider.getExecutionContext();
        this.acmd = objectProvider.getClassMetaData();
        this.storeManager = storeManager;
        this.mconn = mconn;
        this.table = storeManager.getTable(objectProvider.getClassMetaData());
        if (pkValue != null) {
            QueryResult qr = ((PartnerConnection)mconn.getConnection()).query(new ForceQueryUtils(objectProvider.getExecutionContext(), mconn, null, null, null, null).buildQueryWithPK(this.table, objectProvider.getClassMetaData(), fieldNumbers, (String)pkValue, 0, null));
            if (qr.getSize() == 0) {
                throw new NucleusObjectNotFoundException();
            }
            this.sobject = qr.getRecords()[0];
        } else {
            this.sobject = new SObject();
        }
        this.query = query;
    }

    public ForceFetchFieldManager(ObjectProvider objectProvider, ForceStoreManager storeManager, ForceManagedConnection mconn, XmlObject sobject, Query query) {
        this.objectProvider = objectProvider;
        this.ec = objectProvider.getExecutionContext();
        this.acmd = objectProvider.getClassMetaData();
        this.storeManager = storeManager;
        this.mconn = mconn;
        this.table = storeManager.getTable(this.acmd);
        this.sobject = sobject;
        this.query = query;
    }

    public ForceFetchFieldManager(ExecutionContext ec, AbstractClassMetaData acmd, ForceStoreManager storeManager, ForceManagedConnection mconn, XmlObject sobject, Query query) {
        this.objectProvider = null;
        this.ec = ec;
        this.acmd = acmd;
        this.storeManager = storeManager;
        this.mconn = mconn;
        this.table = storeManager.getTable(acmd);
        this.sobject = sobject;
        this.query = query;
    }

    public boolean fetchBooleanField(int fieldNumber) {
        String ret = this.fetchStringField(fieldNumber);
        return ret != null ? Boolean.parseBoolean(ret) : false;
    }

    public byte fetchByteField(int fieldNumber) {
        String ret = this.fetchStringField(fieldNumber);
        return ret != null ? Byte.parseByte(ret) : (byte)0;
    }

    public char fetchCharField(int fieldNumber) {
        String ret = this.fetchStringField(fieldNumber);
        return ret != null && ret.length() > 0 ? ret.charAt(0) : (char)'\u0000';
    }

    public double fetchDoubleField(int fieldNumber) {
        String ret = this.fetchStringField(fieldNumber);
        return ret != null ? Double.parseDouble(ret) : 0.0;
    }

    public float fetchFloatField(int fieldNumber) {
        String ret = this.fetchStringField(fieldNumber);
        return ret != null ? Float.parseFloat(ret) : 0.0f;
    }

    public int fetchIntField(int fieldNumber) {
        String ret = this.fetchStringField(fieldNumber);
        return ret != null ? Double.valueOf(ret).intValue() : 0;
    }

    public long fetchLongField(int fieldNumber) {
        String ret = this.fetchStringField(fieldNumber);
        if (ret == null) {
            return 0L;
        }
        try {
            return Long.parseLong(ret);
        }
        catch (NumberFormatException ne) {
            return Double.valueOf(ret).longValue();
        }
    }

    public Object fetchObjectField(int fieldNumber) {
        return this.fetchObjectField(this.acmd.getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber), null);
    }

    public short fetchShortField(int fieldNumber) {
        String ret = this.fetchStringField(fieldNumber);
        return ret != null ? Double.valueOf(ret).shortValue() : (short)0;
    }

    public String fetchStringField(int fieldNumber) {
        ColumnImpl column = this.table.getColumnAt(this.acmd, fieldNumber);
        Object ret = this.sobject.getField(column.getFieldName());
        return ret != null ? (String)ret : null;
    }

    public Object fetchObjectField(AbstractMemberMetaData ammd, Object valueOverride) {
        Object o;
        if (ammd.getCollection() != null || ammd.getMap() != null) {
            int mapKeyPosition;
            AbstractClassMetaData cmd = PersistenceUtils.getMemberElementClassMetaData(ammd, this.ec.getClassLoaderResolver(), this.ec.getMetaDataManager());
            AbstractCollection childrenColl = null;
            LinkedHashMap<Object, Object> childrenMap = null;
            int n = mapKeyPosition = cmd != null ? cmd.getPKMemberPositions()[0] : -1;
            if (ammd.getCollection() != null) {
                childrenColl = Set.class.isAssignableFrom(ammd.getType()) ? new LinkedHashSet() : new ArrayList();
            } else {
                childrenMap = new LinkedHashMap<Object, Object>();
                if (ammd.getKeyMetaData() != null) {
                    mapKeyPosition = cmd.getAbsolutePositionOfMember(ammd.getKeyMetaData().getMappedBy());
                }
            }
            ColumnImpl column = this.table.getColumnFor(cmd, ammd);
            String relationshipName = column.getSelectFieldName();
            Iterator rel = this.sobject.getChildren(relationshipName);
            while (rel.hasNext()) {
                Iterator subs = ((XmlObject)rel.next()).getChildren("records");
                int[] fieldsToLoad = cmd != null ? cmd.getDFGMemberPositions() : null;
                try {
                    while (subs.hasNext()) {
                        XmlObject child = (XmlObject)subs.next();
                        Object value = this.ec.findObjectUsingAID(new Type(this.ec.getClassLoaderResolver().classForName(cmd.getFullClassName())), ForceQueryUtils.getFieldValues2(cmd, fieldsToLoad, this.mconn, this.storeManager, child, this.query), this.query == null ? true : this.query.getIgnoreCache(), true);
                        if (childrenColl != null) {
                            childrenColl.add(value);
                            continue;
                        }
                        childrenMap.put(PersistenceUtils.getMemberValue(cmd, mapKeyPosition, value), value);
                    }
                }
                catch (Exception e) {
                    throw new NucleusUserException(e.getMessage(), (Throwable)e);
                }
            }
            if (this.objectProvider != null) {
                Cloneable ret = childrenColl != null ? childrenColl : childrenMap;
                return SCOUtils.newSCOInstance((ObjectProvider)this.objectProvider, (AbstractMemberMetaData)ammd, (Class)ammd.getType(), ret != null ? ret.getClass() : null, (Object)ret, (boolean)false, (boolean)false, (boolean)false);
            }
            return childrenColl != null ? Collections.unmodifiableCollection(childrenColl) : Collections.unmodifiableMap(childrenMap);
        }
        if (ammd.getEmbeddedMetaData() != null) {
            return this.fetchEmbeddedObject(ammd);
        }
        ColumnImpl column = this.table.getColumnFor(this.acmd, ammd);
        Object object = o = valueOverride != null ? valueOverride : this.sobject.getField(column.getSelectFieldName());
        if (o == null) {
            return null;
        }
        switch (column.getType()) {
            case _boolean: {
                return Boolean.parseBoolean((String)o);
            }
            case _int: 
            case percent: {
                if (ammd.getType() == Long.class || ammd.getType() == Long.TYPE) {
                    try {
                        return Long.parseLong((String)o);
                    }
                    catch (NumberFormatException ne) {
                        return Double.valueOf((String)o).longValue();
                    }
                }
                if (ammd.getType() == Short.class || ammd.getType() == Short.TYPE) {
                    return Double.valueOf((String)o).shortValue();
                }
                if (ammd.getType() == Float.class || ammd.getType() == Float.TYPE) {
                    return Float.valueOf(Float.parseFloat((String)o));
                }
                if (ammd.getType() == Double.class || ammd.getType() == Double.TYPE) {
                    return Double.parseDouble((String)o);
                }
                if (ammd.getType() == BigInteger.class) {
                    DecimalFormat f = new DecimalFormat("0.##################E0");
                    f.setGroupingUsed(false);
                    return new BigInteger(f.parse((String)o, new ParsePosition(0)).toString());
                }
                return Double.valueOf((String)o).intValue();
            }
            case _double: {
                if (ammd.getType() == Float.class || ammd.getType() == Float.TYPE) {
                    return Float.valueOf(Float.parseFloat((String)o));
                }
                return Double.parseDouble((String)o);
            }
            case currency: {
                return new BigDecimal((String)o, new MathContext(column.getField().getPrecision())).setScale(column.getField().getScale(), RoundingMode.HALF_DOWN);
            }
            case date: {
                Date tvalue = new DateCodec().deserialize((String)o).getTime();
                return this.objectProvider != null ? SCOUtils.newSCOInstance((ObjectProvider)this.objectProvider, (AbstractMemberMetaData)ammd, (Class)ammd.getType(), tvalue != null ? tvalue.getClass() : null, (Object)tvalue, (boolean)false, (boolean)false, (boolean)false) : tvalue;
            }
            case datetime: {
                Calendar cal = new CalendarCodec().deserialize((String)o);
                Object tvalue = ammd.getType() == Date.class ? cal.getTime() : (ammd.getType() == Time.class ? new Time(cal) : cal);
                return this.objectProvider != null ? SCOUtils.newSCOInstance((ObjectProvider)this.objectProvider, (AbstractMemberMetaData)ammd, (Class)ammd.getType(), tvalue != null ? tvalue.getClass() : null, tvalue, (boolean)false, (boolean)false, (boolean)false) : tvalue;
            }
            case reference: {
                if (o instanceof XmlObject) {
                    try {
                        AbstractClassMetaData cmd = this.ec.getMetaDataManager().getMetaDataForClass(ammd.getTypeName(), this.ec.getClassLoaderResolver());
                        return this.ec.findObjectUsingAID(new Type(this.ec.getClassLoaderResolver().classForName(cmd.getFullClassName())), ForceQueryUtils.getFieldValues2(cmd, cmd.getDFGMemberPositions(), this.mconn, this.storeManager, (XmlObject)o, this.query), this.query == null ? true : this.query.getIgnoreCache(), true);
                    }
                    catch (Exception e) {
                        throw new NucleusUserException(e.getMessage(), (Throwable)e);
                    }
                }
                return this.ec.findObject((Object)new StringIdentity(ammd.getType(), (String)o), false, false, ammd.getTypeName());
            }
            case picklist: {
                if (!ammd.getType().isEnum()) break;
                if (PersistenceUtils.isOrdinalEnum(ammd)) {
                    return ammd.getType().getEnumConstants()[Integer.parseInt((String)o)];
                }
                if (PicklistValueEnum.class.isAssignableFrom(ammd.getType())) {
                    try {
                        return ammd.getType().getMethod("fromValue", String.class).invoke((Object)ammd.getType(), (String)o);
                    }
                    catch (Exception e) {
                        throw new NucleusUserException("Unable to invoke fromValue(String) for enum " + ammd.getType(), (Throwable)e);
                    }
                }
                return Enum.valueOf(ammd.getType(), (String)o);
            }
            case multipicklist: {
                String[] values = MULTI_SELECT_VALUE_SEPARATOR.split((String)o);
                if (ammd.getType().getComponentType().isEnum()) {
                    Class<?> type = ammd.getType().getComponentType();
                    Enum[] enumObjects = (Enum[])Array.newInstance(type, values.length);
                    Enum[] enumValues = (Enum[])ammd.getType().getComponentType().getEnumConstants();
                    boolean isOrdinal = PersistenceUtils.isOrdinalEnum(ammd);
                    for (int i = 0; i < values.length; ++i) {
                        enumObjects[i] = isOrdinal ? enumValues[Integer.parseInt(values[i])] : Enum.valueOf(type, values[i]);
                    }
                    return enumObjects;
                }
                return values;
            }
            case url: {
                try {
                    return new URL((String)o);
                }
                catch (MalformedURLException me) {
                    try {
                        return new URL(NO_PROTOCOL_URL_PATTERN.matcher((String)o).replaceAll("http://"));
                    }
                    catch (MalformedURLException me2) {
                        throw new NucleusUserException(me2.getMessage());
                    }
                }
            }
            case string: {
                if (ammd.getType() == Byte.class || ammd.getType() == Byte.TYPE) {
                    return Byte.parseByte((String)o);
                }
                if (ammd.getType() != Character.class && ammd.getType() != Character.TYPE || o == null) break;
                return Character.valueOf(((String)o).charAt(0));
            }
            case base64: {
                if (ammd.getType() == byte[].class || ammd.getType() == Byte[].class) {
                    return Base64.decode((byte[])((String)o).getBytes());
                }
                throw new NucleusUserException("Bad datatype for base64 encoding: " + ammd.getTypeName());
            }
        }
        return o;
    }

    private Object fetchEmbeddedObject(AbstractMemberMetaData ammd) {
        if (this.objectProvider == null) {
            return null;
        }
        AbstractClassMetaData cmd = this.storeManager.getMetaDataManager().getMetaDataForClass(ammd.getType(), this.ec.getClassLoaderResolver());
        Object obj = null;
        try {
            obj = this.ec.getClassLoaderResolver().classForName(cmd.getFullClassName(), true).newInstance();
            for (AbstractMemberMetaData eammd : ammd.getEmbeddedMetaData().getMemberMetaData()) {
                PersistenceUtils.setFieldValue(ammd.getType(), cmd, cmd.getAbsolutePositionOfMember(eammd.getName()), obj, this.fetchObjectField(eammd, null));
            }
            this.ec.findObjectProviderForEmbedded(obj, this.objectProvider, ammd);
        }
        catch (Exception e) {
            throw new NucleusUserException(e.getMessage(), (Throwable)e);
        }
        return obj;
    }
}

