/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.module.afterburner.deser;

import com.fasterxml.jackson.module.afterburner.deser.OptimizedValueInstantiator;
import com.fasterxml.jackson.module.afterburner.util.DynamicPropertyAccessorBase;
import com.fasterxml.jackson.module.afterburner.util.MyClassLoader;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.codehaus.jackson.map.deser.ValueInstantiator;
import org.codehaus.jackson.map.deser.std.StdValueInstantiator;
import org.codehaus.jackson.map.introspect.AnnotatedWithParams;
import org.codehaus.jackson.org.objectweb.asm.ClassWriter;
import org.codehaus.jackson.org.objectweb.asm.MethodVisitor;
import org.codehaus.jackson.org.objectweb.asm.Type;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CreatorOptimizer
extends DynamicPropertyAccessorBase {
    protected final Class<?> _valueClass;
    protected final MyClassLoader _classLoader;
    protected final StdValueInstantiator _originalInstantiator;

    public CreatorOptimizer(Class<?> valueClass, MyClassLoader classLoader, StdValueInstantiator orig) {
        this._valueClass = valueClass;
        this._classLoader = classLoader;
        this._originalInstantiator = orig;
    }

    public ValueInstantiator createOptimized() {
        AnnotatedWithParams defaultCreator = this._originalInstantiator.getDefaultCreator();
        if (defaultCreator != null) {
            Method m;
            AnnotatedElement elem = defaultCreator.getAnnotated();
            if (elem instanceof Constructor) {
                return this.createSubclass((Constructor)elem, null);
            }
            if (elem instanceof Method && Modifier.isStatic((m = (Method)elem).getModifiers())) {
                return this.createSubclass(null, m);
            }
        }
        return null;
    }

    protected ValueInstantiator createSubclass(Constructor<?> ctor, Method factory) {
        ValueInstantiator inst;
        MyClassLoader loader = this._classLoader == null ? new MyClassLoader(this._valueClass.getClassLoader(), true) : this._classLoader;
        String srcName = this._valueClass.getName() + "$Creator4JacksonDeserializer";
        Class<?> impl = null;
        try {
            impl = loader.loadClass(srcName);
        }
        catch (ClassNotFoundException e) {
            // empty catch block
        }
        if (impl == null) {
            byte[] bytecode = this.generateOptimized(srcName, ctor, factory);
            impl = loader.loadAndResolve(srcName, bytecode);
        }
        try {
            inst = (ValueInstantiator)impl.newInstance();
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to generate accessor class '" + srcName + "': " + e.getMessage(), e);
        }
        return inst;
    }

    protected byte[] generateOptimized(String srcName, Constructor<?> ctor, Method factory) {
        ClassWriter cw = new ClassWriter(1);
        String superClass = CreatorOptimizer.internalClassName(OptimizedValueInstantiator.class.getName());
        String generatedClass = CreatorOptimizer.internalClassName(srcName);
        cw.visit(49, 33, generatedClass, null, superClass, null);
        cw.visitSource(srcName + ".java", null);
        String optimizedValueInstDesc = Type.getDescriptor(OptimizedValueInstantiator.class);
        String stdValueInstDesc = Type.getDescriptor(StdValueInstantiator.class);
        MethodVisitor mv = cw.visitMethod(1, "<init>", "()V", null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(183, superClass, "<init>", "()V");
        mv.visitInsn(177);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
        mv = cw.visitMethod(1, "<init>", "(" + stdValueInstDesc + ")V", null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitVarInsn(25, 1);
        mv.visitMethodInsn(183, superClass, "<init>", "(" + stdValueInstDesc + ")V");
        mv.visitInsn(177);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
        mv = cw.visitMethod(1, "with", "(" + stdValueInstDesc + ")" + optimizedValueInstDesc, null, null);
        mv.visitCode();
        mv.visitTypeInsn(187, generatedClass);
        mv.visitInsn(89);
        mv.visitVarInsn(25, 1);
        mv.visitMethodInsn(183, generatedClass, "<init>", "(" + stdValueInstDesc + ")V");
        mv.visitInsn(176);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
        mv = cw.visitMethod(1, "createUsingDefault", "()Ljava/lang/Object;", null, null);
        mv.visitCode();
        if (ctor != null) {
            this.addCreator(mv, ctor);
        } else {
            this.addCreator(mv, factory);
        }
        mv.visitInsn(176);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
        cw.visitEnd();
        return cw.toByteArray();
    }

    protected void addCreator(MethodVisitor mv, Constructor<?> ctor) {
        String valueClassInternal = Type.getInternalName(ctor.getDeclaringClass());
        mv.visitTypeInsn(187, valueClassInternal);
        mv.visitInsn(89);
        mv.visitMethodInsn(183, valueClassInternal, "<init>", "()V");
    }

    protected void addCreator(MethodVisitor mv, Method factory) {
        Class<?> valueClass = factory.getReturnType();
        mv.visitMethodInsn(184, Type.getInternalName(factory.getDeclaringClass()), factory.getName(), "()" + Type.getDescriptor(valueClass));
    }
}

