/*
 * Decompiled with CFR 0.152.
 */
package com.diffblue.deeptestutils;

import com.diffblue.deeptestutils.DeeptestUtilsRuntimeException;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import javassist.CannotCompileException;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtMember;
import javassist.CtMethod;
import javassist.NotFoundException;
import org.objenesis.ObjenesisStd;

public final class Reflector {
    private static HashMap<String, Class<?>> classMap = new HashMap();

    private Reflector() {
    }

    public static void setField(Object obj, String fieldName, Object newVal) {
        try {
            Reflector.setField(obj.getClass(), obj, fieldName, newVal);
        }
        catch (IllegalArgumentException e) {
            throw new DeeptestUtilsRuntimeException(e.getMessage(), e.getCause());
        }
    }

    public static <T> void setStaticField(Class<T> c, String fieldName, Object newVal) {
        try {
            Reflector.setField(c, null, fieldName, newVal);
        }
        catch (IllegalArgumentException e) {
            throw new DeeptestUtilsRuntimeException(e.getMessage(), e.getCause());
        }
    }

    public static <T> void setField(Class<T> c, Object o, String fieldName, Object newVal) {
        if (c == null) {
            throw new DeeptestUtilsRuntimeException("Class of the field to be set cannot be null.", new NoSuchFieldException().getCause());
        }
        Field field = null;
        for (Field f : c.getDeclaredFields()) {
            if (!f.getName().equals(fieldName)) continue;
            field = f;
            break;
        }
        if (field == null) {
            Reflector.setField(c.getSuperclass(), o, fieldName, newVal);
        } else {
            Field modifiersField;
            Field property = field;
            property.setAccessible(true);
            try {
                modifiersField = Field.class.getDeclaredField("modifiers");
            }
            catch (NoSuchFieldException e) {
                throw new DeeptestUtilsRuntimeException(e.getMessage(), e.getCause());
            }
            modifiersField.setAccessible(true);
            try {
                modifiersField.setInt(property, property.getModifiers() & 0xFFFFFFEF);
            }
            catch (IllegalAccessException e) {
                throw new DeeptestUtilsRuntimeException(e.getMessage(), e.getCause());
            }
            try {
                property.set(o, newVal);
            }
            catch (IllegalAccessException ex) {
                throw new DeeptestUtilsRuntimeException(ex.getMessage(), ex.getCause());
            }
        }
    }

    public static <T> Object getInstanceField(Class<T> c, Object o, String fieldName) {
        if (c == null) {
            throw new DeeptestUtilsRuntimeException(fieldName + " is not a field in class " + c, new NoSuchFieldException());
        }
        Field field = null;
        for (Field f : c.getDeclaredFields()) {
            if (!f.getName().equals(fieldName)) continue;
            field = f;
            break;
        }
        if (field == null) {
            return Reflector.getInstanceField(c.getSuperclass(), o, fieldName);
        }
        Field property = field;
        property.setAccessible(true);
        try {
            return property.get(o);
        }
        catch (IllegalArgumentException e) {
            throw new DeeptestUtilsRuntimeException(e.getMessage(), e.getCause());
        }
        catch (IllegalAccessException e) {
            throw new DeeptestUtilsRuntimeException(e.getMessage(), e.getCause());
        }
    }

    public static Object getInstanceField(Object obj, String fieldName) {
        return Reflector.getInstanceField(obj.getClass(), obj, fieldName);
    }

    public static Class<?> forName(String className) {
        if (className.equals("float")) {
            return Float.TYPE;
        }
        if (className.equals("byte")) {
            return Byte.TYPE;
        }
        if (className.equals("char")) {
            return Character.TYPE;
        }
        if (className.equals("short")) {
            return Short.TYPE;
        }
        if (className.equals("double")) {
            return Double.TYPE;
        }
        if (className.equals("int")) {
            return Integer.TYPE;
        }
        if (className.equals("long")) {
            return Long.TYPE;
        }
        if (className.equals("boolean")) {
            return Boolean.TYPE;
        }
        String cleanedName = className.replaceAll("\\s+", "");
        if (cleanedName.endsWith("[]")) {
            String arrayPrefix = "";
            while (cleanedName.endsWith("[]")) {
                int parenthesisIndex = cleanedName.length() - 2;
                arrayPrefix = arrayPrefix + "[";
                cleanedName = cleanedName.substring(0, parenthesisIndex);
            }
            cleanedName = cleanedName.equals("float") ? "F" : (cleanedName.equals("byte") ? "B" : (cleanedName.equals("char") ? "C" : (cleanedName.equals("short") ? "S" : (cleanedName.equals("double") ? "D" : (cleanedName.equals("int") ? "I" : (cleanedName.equals("long") ? "J" : (cleanedName.equals("boolean") ? "Z" : "L" + cleanedName + ";")))))));
            try {
                return Class.forName(arrayPrefix + cleanedName);
            }
            catch (ClassNotFoundException e) {
                throw new DeeptestUtilsRuntimeException(e.getMessage(), e.getCause());
            }
        }
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            throw new DeeptestUtilsRuntimeException(e.getMessage(), e.getCause());
        }
    }

    public static Class<? extends Throwable> toThrowableClass(String className) {
        Class<Throwable> throwableClass = Throwable.class;
        Class<?> cl = Reflector.forName(className);
        if (throwableClass.isAssignableFrom(cl)) {
            return cl;
        }
        throw new DeeptestUtilsRuntimeException("Cannot cast " + className + " to Throwable", new ClassCastException());
    }

    public static String removePackageFromName(String className) {
        int lastSeparator = className.lastIndexOf(46);
        if (lastSeparator != -1) {
            return className.substring(lastSeparator + 1);
        }
        return className;
    }

    private static void makePublic(CtMember m) {
        int modifier = m.getModifiers();
        modifier &= 0xFFFFFFF9;
        m.setModifiers(modifier |= 1);
    }

    private static void makePublic(CtClass c) {
        int modifier = c.getModifiers();
        modifier &= 0xFFFFFFF9;
        c.setModifiers(modifier |= 1);
    }

    private static void makeFullyPublic(CtClass cl) {
        for (CtMethod ctMethod : cl.getDeclaredMethods()) {
            Reflector.makePublic((CtMember)ctMethod);
        }
        for (CtMethod ctMethod : cl.getDeclaredConstructors()) {
            Reflector.makePublic((CtMember)ctMethod);
        }
        for (CtMethod ctMethod : cl.getDeclaredFields()) {
            Reflector.makePublic((CtMember)ctMethod);
        }
        Reflector.makePublic(cl);
    }

    public static <T> T getInstance(Class<T> cl) throws InvocationTargetException {
        try {
            return (T)new ObjenesisStd().newInstance(cl);
        }
        catch (ExceptionInInitializerError ex) {
            throw new InvocationTargetException(ex.getCause());
        }
    }

    public static <T> Object getInstance(String className) throws InvocationTargetException {
        CtClass cl;
        ClassPool pool = ClassPool.getDefault();
        try {
            cl = pool.get(className);
        }
        catch (NotFoundException e) {
            throw new DeeptestUtilsRuntimeException(e.getMessage(), e.getCause());
        }
        if (Reflector.isAbstract(cl) || cl.isInterface()) {
            Class implementingClass;
            Reflector.makeFullyPublic(cl);
            String implementingClassName = "com.diffblue.cover" + Reflector.removePackageFromName(className) + "Impl";
            CtClass implementingCtClass = pool.getOrNull(implementingClassName);
            if (implementingCtClass != null) {
                return Reflector.getInstance(classMap.get(implementingClassName));
            }
            implementingCtClass = pool.makeClass(implementingClassName);
            if (cl.isInterface()) {
                implementingCtClass.setInterfaces(new CtClass[]{cl});
            } else {
                try {
                    implementingCtClass.setSuperclass(cl);
                }
                catch (CannotCompileException e) {
                    throw new DeeptestUtilsRuntimeException(e.getMessage(), e.getCause());
                }
            }
            try {
                implementingClass = pool.toClass(implementingCtClass);
            }
            catch (CannotCompileException e) {
                throw new DeeptestUtilsRuntimeException(e.getMessage(), e.getCause());
            }
            classMap.put(implementingClassName, implementingClass);
            return Reflector.getInstance(implementingClass);
        }
        try {
            return Reflector.getInstance(Class.forName(className));
        }
        catch (ExceptionInInitializerError ex) {
            throw new InvocationTargetException(ex.getCause());
        }
        catch (ClassNotFoundException e) {
            throw new DeeptestUtilsRuntimeException(e.getMessage(), e.getCause());
        }
    }

    private static boolean isAbstract(CtClass c) {
        return (c.getModifiers() & 0x400) != 0;
    }
}

