/*
 * Decompiled with CFR 0.152.
 */
package com.blade.mvc.route;

import com.blade.kit.PathKit;
import com.blade.mvc.http.HttpMethod;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;

public class Route {
    private HttpMethod httpMethod;
    private String path;
    private Object target;
    private Class<?> targetType;
    private Method action;
    private int sort = Integer.MAX_VALUE;
    private Map<String, String> pathParams = new HashMap<String, String>();

    public Route() {
    }

    public Route(HttpMethod httpMethod, String path, Class<?> targetType, Method action) {
        this.httpMethod = httpMethod;
        this.path = PathKit.fixPath(path);
        this.targetType = targetType;
        this.action = action;
    }

    public Route(HttpMethod httpMethod, String path, Object target, Class<?> targetType, Method action) {
        this.httpMethod = httpMethod;
        this.path = PathKit.fixPath(path);
        this.target = target;
        this.targetType = targetType;
        this.action = action;
    }

    public HttpMethod getHttpMethod() {
        return this.httpMethod;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public Object getTarget() {
        return this.target;
    }

    public void setTarget(Object target) {
        this.target = target;
    }

    public Method getAction() {
        return this.action;
    }

    public Class<?> getTargetType() {
        return this.targetType;
    }

    public Map<String, String> getPathParams() {
        return this.pathParams;
    }

    public void setPathParams(Map<String, String> pathParams) {
        this.pathParams = pathParams;
    }

    public int getSort() {
        return this.sort;
    }

    public void setSort(int sort) {
        this.sort = sort;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Route route = (Route)o;
        if (this.sort != route.sort) {
            return false;
        }
        if (this.httpMethod != route.httpMethod) {
            return false;
        }
        if (this.path != null ? !this.path.equals(route.path) : route.path != null) {
            return false;
        }
        if (this.target != null ? !this.target.equals(route.target) : route.target != null) {
            return false;
        }
        if (this.targetType != null ? !this.targetType.equals(route.targetType) : route.targetType != null) {
            return false;
        }
        if (this.action != null ? !this.action.equals(route.action) : route.action != null) {
            return false;
        }
        return !(this.pathParams != null ? !this.pathParams.equals(route.pathParams) : route.pathParams != null);
    }

    public int hashCode() {
        int result = this.httpMethod != null ? this.httpMethod.hashCode() : 0;
        result = 31 * result + (this.path != null ? this.path.hashCode() : 0);
        result = 31 * result + (this.target != null ? this.target.hashCode() : 0);
        result = 31 * result + (this.targetType != null ? this.targetType.hashCode() : 0);
        result = 31 * result + (this.action != null ? this.action.hashCode() : 0);
        result = 31 * result + this.sort;
        result = 31 * result + (this.pathParams != null ? this.pathParams.hashCode() : 0);
        return result;
    }

    public String toString() {
        return (Object)((Object)this.httpMethod) + "\t" + this.path;
    }
}

