/*
 * Decompiled with CFR 0.152.
 */
package com.blade.mvc.http;

import com.blade.kit.JsonKit;
import com.blade.mvc.WebContext;
import com.blade.mvc.http.Cookie;
import com.blade.mvc.ui.ModelAndView;
import com.blade.mvc.wrapper.OutputStreamWrapper;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.util.CharsetUtil;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import lombok.NonNull;

public interface Response {
    public int statusCode();

    public Response status(int var1);

    default public Response badRequest() {
        return this.status(400);
    }

    default public Response unauthorized() {
        return this.status(401);
    }

    default public Response notFound() {
        return this.status(404);
    }

    public Response contentType(String var1);

    public String contentType();

    public Map<String, String> headers();

    public Response header(String var1, String var2);

    public Map<String, String> cookies();

    public Response cookie(Cookie var1);

    public Response cookie(String var1, String var2);

    public Response cookie(String var1, String var2, int var3);

    public Response cookie(String var1, String var2, int var3, boolean var4);

    public Response cookie(String var1, String var2, String var3, int var4, boolean var5);

    public Response removeCookie(String var1);

    default public void text(@NonNull String text) {
        if (text == null) {
            throw new NullPointerException("text");
        }
        DefaultFullHttpResponse response = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.valueOf((int)this.statusCode()), Unpooled.wrappedBuffer((byte[])text.getBytes(CharsetUtil.UTF_8)));
        this.contentType("text/plain; charset=UTF-8");
        this.send((FullHttpResponse)response);
    }

    default public void html(@NonNull String html) {
        if (html == null) {
            throw new NullPointerException("html");
        }
        DefaultFullHttpResponse response = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.valueOf((int)this.statusCode()), Unpooled.wrappedBuffer((byte[])html.getBytes(CharsetUtil.UTF_8)));
        this.contentType("text/html; charset=UTF-8");
        this.send((FullHttpResponse)response);
    }

    default public void json(@NonNull String json) {
        if (json == null) {
            throw new NullPointerException("json");
        }
        DefaultFullHttpResponse response = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.valueOf((int)this.statusCode()), Unpooled.wrappedBuffer((byte[])json.getBytes(CharsetUtil.UTF_8)));
        if (!WebContext.request().isIE()) {
            this.contentType("application/json; charset=UTF-8");
        }
        this.send((FullHttpResponse)response);
    }

    default public void json(@NonNull Object bean) {
        if (bean == null) {
            throw new NullPointerException("bean");
        }
        this.json(JsonKit.toString(bean));
    }

    default public void body(@NonNull String data) {
        if (data == null) {
            throw new NullPointerException("data");
        }
        DefaultFullHttpResponse response = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.valueOf((int)this.statusCode()), Unpooled.wrappedBuffer((byte[])data.getBytes(CharsetUtil.UTF_8)));
        this.send((FullHttpResponse)response);
    }

    default public void body(@NonNull byte[] data) {
        if (data == null) {
            throw new NullPointerException("data");
        }
        DefaultFullHttpResponse response = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.valueOf((int)this.statusCode()), Unpooled.wrappedBuffer((byte[])data));
        this.send((FullHttpResponse)response);
    }

    default public void body(@NonNull ByteBuf byteBuf) {
        if (byteBuf == null) {
            throw new NullPointerException("byteBuf");
        }
        DefaultFullHttpResponse response = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.valueOf((int)this.statusCode()), byteBuf);
        this.send((FullHttpResponse)response);
    }

    public void download(String var1, File var2) throws Exception;

    public OutputStreamWrapper outputStream() throws IOException;

    default public void render(@NonNull String view) {
        if (view == null) {
            throw new NullPointerException("view");
        }
        this.render(new ModelAndView(view));
    }

    public void render(ModelAndView var1);

    public void redirect(String var1);

    public boolean isCommit();

    public void send(FullHttpResponse var1);
}

