/*
 * Decompiled with CFR 0.152.
 */
package com.blade.kit.json;

import com.blade.kit.ReflectKit;
import com.blade.kit.StringKit;
import com.blade.kit.json.Ason;
import com.blade.kit.json.JsonIgnore;
import com.blade.kit.json.JsonProperty;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BeanSerializer {
    private static final Logger log = LoggerFactory.getLogger(BeanSerializer.class);

    public static Object serialize(Object bean) throws NullPointerException {
        if (bean == null) {
            return null;
        }
        if (ReflectKit.isPrimitive(bean) || bean instanceof Number) {
            return bean;
        }
        if (bean instanceof Collection) {
            return BeanSerializer.serialize(((Collection)bean).toArray());
        }
        if (bean.getClass().isArray()) {
            int length = Array.getLength(bean);
            ArrayList<Object> array = new ArrayList<Object>(length);
            for (int i = 0; i < length; ++i) {
                array.add(BeanSerializer.serialize(Array.get(bean, i)));
            }
            return array;
        }
        if (bean instanceof Map) {
            Map map = (Map)bean;
            map.forEach((key, value) -> map.put(key, BeanSerializer.serialize(value)));
            return map;
        }
        ArrayList<Integer> indexs = new ArrayList<Integer>();
        ArrayList<Object> values = new ArrayList<Object>();
        ArrayList<String> keys = new ArrayList<String>();
        int pos = 0;
        for (Field field : bean.getClass().getDeclaredFields()) {
            Object value2 = null;
            try {
                String key2 = field.getName();
                if ("this$0".equals(key2) || "serialVersionUID".equals(key2)) continue;
                field.setAccessible(true);
                JsonIgnore jsonIgnore = field.getAnnotation(JsonIgnore.class);
                if (null != jsonIgnore) continue;
                JsonProperty jsonProperty = field.getAnnotation(JsonProperty.class);
                if (jsonProperty != null) {
                    value2 = BeanSerializer.serialize(field.get(bean));
                    if (!jsonProperty.value().isEmpty()) {
                        key2 = jsonProperty.value();
                    }
                } else {
                    value2 = BeanSerializer.serialize(field.get(bean));
                }
                int positon = indexs.size();
                indexs.add(positon, pos++);
                values.add(positon, value2);
                keys.add(positon, key2);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        Ason ason = new Ason(indexs.size());
        for (int i = 0; i < indexs.size(); ++i) {
            ason.put(keys.get(i), values.get(i));
        }
        return ason;
    }

    public static <T> Collection deserialize(Collection template, Class<T> genericType, Collection collection) throws Exception {
        return BeanSerializer.deserialize(template, genericType, collection.toArray());
    }

    public static <T, A> Collection deserialize(Collection template, Class<T> genericType, A[] array) throws Exception {
        Object[] list = template.toArray();
        template.clear();
        for (int i = 0; i < array.length; ++i) {
            if (i < list.length) {
                template.add(BeanSerializer.deserialize(list[i], array[i]));
                continue;
            }
            template.add(BeanSerializer.deserialize(genericType, array[i]));
        }
        return template;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static <T> T deserialize(T template, Map map) {
        for (Field field : template.getClass().getDeclaredFields()) {
            Collection value = null;
            try {
                JsonProperty jsonProperty;
                field.setAccessible(true);
                JsonIgnore jsonIgnore = field.getAnnotation(JsonIgnore.class);
                if (null != jsonIgnore || (jsonProperty = field.getAnnotation(JsonProperty.class)) == null) continue;
                String name = jsonProperty.value();
                if (name.isEmpty()) {
                    name = field.getName();
                }
                value = (Collection)map.get(name);
                Object tmp = field.get(template);
                Class<?> clazz = field.getType();
                if (Collection.class.isAssignableFrom(clazz)) {
                    Class genericType = Object.class;
                    try {
                        genericType = (Class)((ParameterizedType)field.getGenericType()).getActualTypeArguments()[0];
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (tmp == null || ((Collection)tmp).size() == 0) {
                        if (value instanceof Collection) {
                            value = BeanSerializer.deserialize(clazz, genericType, value);
                        } else {
                            if (!value.getClass().isArray()) return null;
                            value = BeanSerializer.deserialize(clazz, genericType, (Object[])value);
                        }
                    } else if (value instanceof Collection) {
                        value = BeanSerializer.deserialize((Collection)tmp, genericType, value);
                    } else {
                        if (!value.getClass().isArray()) return null;
                        value = BeanSerializer.deserialize((Collection)tmp, genericType, (Object[])value);
                    }
                } else {
                    value = tmp == null || tmp.getClass().isArray() && Array.getLength(tmp) == 0 ? (Collection)BeanSerializer.deserialize(clazz, value) : BeanSerializer.deserialize(tmp, value);
                }
                field.set(template, value);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return template;
    }

    public static <T> T deserialize(T template, Object object) throws Exception {
        if (object instanceof Number || object instanceof String || object instanceof Boolean) {
            return (T)object;
        }
        if (object instanceof Collection) {
            return BeanSerializer.deserialize(template, (Object)((Collection)object).toArray());
        }
        if (template instanceof Collection) {
            if (!object.getClass().isArray()) {
                return null;
            }
            return (T)BeanSerializer.deserialize((Collection)template, Object.class, (Object[])object);
        }
        if (template.getClass().isArray()) {
            if (!object.getClass().isArray()) {
                return null;
            }
            int desLength = Array.getLength(template);
            int srcLength = Array.getLength(object);
            boolean isAppend = desLength == 0;
            Class<?> componentType = template.getClass().getComponentType();
            int length = desLength > srcLength ? srcLength : desLength;
            Object array = Array.newInstance(componentType, length);
            for (int i = 0; i < length; ++i) {
                if (isAppend) {
                    Array.set(array, i, BeanSerializer.deserialize(componentType, Array.get(object, i)));
                    continue;
                }
                if (i >= Array.getLength(template)) continue;
                Array.set(array, i, BeanSerializer.deserialize(Array.get(template, i), Array.get(object, i)));
            }
            return (T)array;
        }
        if (object instanceof Map) {
            if (template instanceof Map) {
                Map des = (Map)template;
                Map src = (Map)object;
                boolean isAppend = des.isEmpty();
                for (Object key : src.keySet()) {
                    if (isAppend) {
                        des.put(key, src.get(key));
                        continue;
                    }
                    if (!des.containsKey(key)) continue;
                    des.replace(key, BeanSerializer.deserialize(des.get(key), src.get(key)));
                }
            } else {
                return BeanSerializer.deserialize(template, (Map)object);
            }
        }
        return null;
    }

    public static <T> T deserialize(Class<T> klass, Map map) throws Exception {
        T bean = klass.newInstance();
        for (Field field : klass.getDeclaredFields()) {
            Collection<Object> value = null;
            try {
                field.setAccessible(true);
                JsonIgnore jsonIgnore = field.getAnnotation(JsonIgnore.class);
                if (null != jsonIgnore) continue;
                JsonProperty jsonProperty = field.getAnnotation(JsonProperty.class);
                String name = field.getName();
                if (jsonProperty != null && StringKit.isNotBlank(jsonProperty.value())) {
                    name = jsonProperty.value();
                }
                value = (Collection<Object>)map.get(name);
                Class<?> clazz = field.getType();
                if (Collection.class.isAssignableFrom(clazz)) {
                    Class genericType = Object.class;
                    try {
                        genericType = (Class)((ParameterizedType)field.getGenericType()).getActualTypeArguments()[0];
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    value = value instanceof Collection ? BeanSerializer.deserialize(clazz, genericType, (Collection)value) : (value.getClass().isArray() ? BeanSerializer.deserialize(clazz, genericType, (Object[])value) : null);
                } else {
                    value = (Collection<Object>)BeanSerializer.deserialize(clazz, value);
                }
                field.set(bean, value);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return bean;
    }

    public static <T, A> Collection<T> deserialize(Class<? extends Collection> klass, Class<T> genericType, A[] array) throws Exception {
        Collection collection = klass.newInstance();
        for (int i = 0; i < array.length; ++i) {
            collection.add(BeanSerializer.deserialize(genericType, array[i]));
        }
        return collection;
    }

    public static <T> Collection<T> deserialize(Class<? extends Collection> klass, Class<T> genericType, Collection array) throws Exception {
        return BeanSerializer.deserialize(klass, genericType, array.toArray());
    }

    public static <T> T[] deserialize(Class<T> componentType, Collection array) throws Exception {
        return BeanSerializer.deserialize(componentType, array.toArray());
    }

    public static <T, A> T[] deserialize(Class<T> componentType, A[] array) throws Exception {
        Object[] collection = (Object[])Array.newInstance(componentType, array.length);
        for (int i = 0; i < array.length; ++i) {
            collection[i] = BeanSerializer.deserialize(componentType, array[i]);
        }
        return collection;
    }

    public static <T> T deserialize(Class<T> klass, Object object) {
        try {
            if (ReflectKit.isPrimitive(object)) {
                return (T)object;
            }
            if (object instanceof Map) {
                if (Map.class.isAssignableFrom(klass)) {
                    return klass.cast(object);
                }
                return BeanSerializer.deserialize(klass, (Map)object);
            }
            if (Collection.class.isAssignableFrom(klass)) {
                if (object instanceof Collection) {
                    return (T)BeanSerializer.deserialize(klass, Object.class, (Collection)object);
                }
                if (object.getClass().isArray()) {
                    return (T)BeanSerializer.deserialize(klass, Object.class, (Object[])object);
                }
            } else if (klass.isArray()) {
                if (object instanceof Collection) {
                    return (T)BeanSerializer.deserialize(klass.getComponentType(), (Collection)object);
                }
                if (object.getClass().isArray()) {
                    return (T)BeanSerializer.deserialize(klass.getComponentType(), (Object[])object);
                }
            }
            return null;
        }
        catch (Exception e) {
            log.error("json deserialize error", (Throwable)e);
            return null;
        }
    }
}

