/*
 * Decompiled with CFR 0.152.
 */
package com.blade.ioc.reader;

import com.blade.ioc.reader.ClassInfo;
import com.blade.ioc.reader.ClassReader;
import com.blade.kit.BladeKit;
import java.io.File;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractClassReader
implements ClassReader {
    private static final Logger log = LoggerFactory.getLogger(AbstractClassReader.class);

    @Override
    public Set<ClassInfo> getClass(String packageName, boolean recursive) {
        return this.getClassByAnnotation(packageName, null, null, recursive);
    }

    @Override
    public Set<ClassInfo> getClass(String packageName, Class<?> parent, boolean recursive) {
        return this.getClassByAnnotation(packageName, parent, null, recursive);
    }

    private Set<ClassInfo> findClassByPackage(String packageName, String packagePath, Class<?> parent, Class<? extends Annotation> annotation, boolean recursive, Set<ClassInfo> classes) throws ClassNotFoundException {
        File[] dirFiles;
        File dir = new File(packagePath);
        if (!dir.exists() || !dir.isDirectory()) {
            log.warn("The package [{}] not found.", (Object)packageName);
        }
        if (null != (dirFiles = this.accept(dir, recursive)) && dirFiles.length > 0) {
            for (File file : dirFiles) {
                if (file.isDirectory()) {
                    this.findClassByPackage(packageName + '.' + file.getName(), file.getAbsolutePath(), parent, annotation, recursive, classes);
                    continue;
                }
                String className = file.getName().substring(0, file.getName().length() - 6);
                Class<?> clazz = Class.forName(packageName + '.' + className);
                if (null != parent && null != annotation) {
                    if (null == clazz.getSuperclass() || !clazz.getSuperclass().equals(parent) || null == clazz.getAnnotation(annotation)) continue;
                    classes.add(new ClassInfo(clazz));
                    continue;
                }
                if (null != parent) {
                    if (null != clazz.getSuperclass() && clazz.getSuperclass().equals(parent)) {
                        classes.add(new ClassInfo(clazz));
                        continue;
                    }
                    if (null == clazz.getInterfaces() || clazz.getInterfaces().length <= 0 || !clazz.getInterfaces()[0].equals(parent)) continue;
                    classes.add(new ClassInfo(clazz));
                    continue;
                }
                if (null != annotation) {
                    if (null == clazz.getAnnotation(annotation)) continue;
                    classes.add(new ClassInfo(clazz));
                    continue;
                }
                classes.add(new ClassInfo(clazz));
            }
        }
        return classes;
    }

    private File[] accept(File file, boolean recursive) {
        File[] dirFiles = file.listFiles(file1 -> recursive && file1.isDirectory() || file1.getName().endsWith(".class"));
        return dirFiles;
    }

    @Override
    public Set<ClassInfo> getClassByAnnotation(String packageName, Class<? extends Annotation> annotation, boolean recursive) {
        return this.getClassByAnnotation(packageName, null, annotation, recursive);
    }

    @Override
    public Set<ClassInfo> getClassByAnnotation(String packageName, Class<?> parent, Class<? extends Annotation> annotation, boolean recursive) {
        HashSet<ClassInfo> classes = new HashSet<ClassInfo>();
        String packageDirName = packageName.replace('.', '/');
        try {
            Enumeration<URL> dirs = this.getClass().getClassLoader().getResources(packageDirName);
            while (dirs.hasMoreElements()) {
                URL url = dirs.nextElement();
                String filePath = new URI(url.getFile()).getPath();
                Set<ClassInfo> subClasses = this.findClassByPackage(packageName, filePath, parent, annotation, recursive, classes);
                if (!BladeKit.isNotEmpty(subClasses)) continue;
                classes.addAll(subClasses);
            }
        }
        catch (IOException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        catch (URISyntaxException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        catch (ClassNotFoundException e) {
            log.error("Add user custom view class error Can't find such Class files.");
        }
        return classes;
    }
}

