/*
 * Decompiled with CFR 0.152.
 */
package com.blade.ioc;

import com.blade.ioc.Injector;
import com.blade.ioc.Ioc;
import java.lang.reflect.Field;

public class FieldInjector
implements Injector {
    private Ioc ioc;
    private Field field;

    public FieldInjector(Ioc ioc, Field field) {
        this.ioc = ioc;
        this.field = field;
    }

    @Override
    public void injection(Object bean) {
        try {
            Class<?> fieldType = this.field.getType();
            Object value = this.ioc.getBean(fieldType);
            if (value == null) {
                throw new IllegalStateException("Can't inject bean: " + fieldType.getName() + " for field: " + this.field);
            }
            this.field.setAccessible(true);
            this.field.set(bean, value);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

