/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.mybatisplus.extension.spring;

import com.baomidou.mybatisplus.annotation.DbType;
import com.baomidou.mybatisplus.core.MybatisConfiguration;
import com.baomidou.mybatisplus.core.MybatisSqlSessionFactoryBuilder;
import com.baomidou.mybatisplus.core.MybatisXMLConfigBuilder;
import com.baomidou.mybatisplus.core.config.GlobalConfig;
import com.baomidou.mybatisplus.core.enums.IEnum;
import com.baomidou.mybatisplus.core.toolkit.ArrayUtils;
import com.baomidou.mybatisplus.core.toolkit.ExceptionUtils;
import com.baomidou.mybatisplus.core.toolkit.GlobalConfigUtils;
import com.baomidou.mybatisplus.extension.handlers.EnumTypeHandler;
import com.baomidou.mybatisplus.extension.toolkit.AopUtils;
import com.baomidou.mybatisplus.extension.toolkit.JdbcUtils;
import com.baomidou.mybatisplus.extension.toolkit.PackageHelper;
import com.baomidou.mybatisplus.extension.toolkit.SqlHelper;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Stream;
import javax.sql.DataSource;
import org.apache.ibatis.builder.xml.XMLMapperBuilder;
import org.apache.ibatis.cache.Cache;
import org.apache.ibatis.executor.ErrorContext;
import org.apache.ibatis.io.VFS;
import org.apache.ibatis.mapping.DatabaseIdProvider;
import org.apache.ibatis.mapping.Environment;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.reflection.factory.ObjectFactory;
import org.apache.ibatis.reflection.wrapper.ObjectWrapperFactory;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.session.SqlSessionFactory;
import org.apache.ibatis.session.SqlSessionFactoryBuilder;
import org.apache.ibatis.transaction.TransactionFactory;
import org.apache.ibatis.type.TypeHandler;
import org.apache.ibatis.type.TypeHandlerRegistry;
import org.mybatis.logging.Logger;
import org.mybatis.logging.LoggerFactory;
import org.mybatis.spring.SqlSessionFactoryBean;
import org.mybatis.spring.transaction.SpringManagedTransactionFactory;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.core.NestedIOException;
import org.springframework.core.io.Resource;
import org.springframework.jdbc.datasource.TransactionAwareDataSourceProxy;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public class MybatisSqlSessionFactoryBean
implements FactoryBean<SqlSessionFactory>,
InitializingBean,
ApplicationListener<ApplicationEvent> {
    private static final Logger LOGGER = LoggerFactory.getLogger(SqlSessionFactoryBean.class);
    private Resource configLocation;
    private MybatisConfiguration configuration;
    private Resource[] mapperLocations;
    private DataSource dataSource;
    private TransactionFactory transactionFactory;
    private Properties configurationProperties;
    private SqlSessionFactoryBuilder sqlSessionFactoryBuilder = new MybatisSqlSessionFactoryBuilder();
    private SqlSessionFactory sqlSessionFactory;
    private String environment = MybatisSqlSessionFactoryBean.class.getSimpleName();
    private boolean failFast;
    private Interceptor[] plugins;
    private TypeHandler<?>[] typeHandlers;
    private String typeHandlersPackage;
    private Class<?>[] typeAliases;
    private String typeAliasesPackage;
    private String typeEnumsPackage;
    private Class<?> typeAliasesSuperType;
    private DatabaseIdProvider databaseIdProvider;
    private Class<? extends VFS> vfs;
    private Cache cache;
    private ObjectFactory objectFactory;
    private ObjectWrapperFactory objectWrapperFactory;
    private GlobalConfig globalConfig;

    public void setGlobalConfig(GlobalConfig globalConfig) {
        this.globalConfig = globalConfig;
    }

    public void setObjectFactory(ObjectFactory objectFactory) {
        this.objectFactory = objectFactory;
    }

    public void setObjectWrapperFactory(ObjectWrapperFactory objectWrapperFactory) {
        this.objectWrapperFactory = objectWrapperFactory;
    }

    public DatabaseIdProvider getDatabaseIdProvider() {
        return this.databaseIdProvider;
    }

    public void setDatabaseIdProvider(DatabaseIdProvider databaseIdProvider) {
        this.databaseIdProvider = databaseIdProvider;
    }

    public Class<? extends VFS> getVfs() {
        return this.vfs;
    }

    public void setVfs(Class<? extends VFS> vfs) {
        this.vfs = vfs;
    }

    public Cache getCache() {
        return this.cache;
    }

    public void setCache(Cache cache) {
        this.cache = cache;
    }

    public void setPlugins(Interceptor[] plugins) {
        this.plugins = plugins;
    }

    public void setTypeAliasesPackage(String typeAliasesPackage) {
        this.typeAliasesPackage = typeAliasesPackage;
    }

    public void setTypeEnumsPackage(String typeEnumsPackage) {
        this.typeEnumsPackage = typeEnumsPackage;
    }

    public void setTypeAliasesSuperType(Class<?> typeAliasesSuperType) {
        this.typeAliasesSuperType = typeAliasesSuperType;
    }

    public void setTypeHandlersPackage(String typeHandlersPackage) {
        this.typeHandlersPackage = typeHandlersPackage;
    }

    public void setTypeHandlers(TypeHandler<?>[] typeHandlers) {
        this.typeHandlers = typeHandlers;
    }

    public void setTypeAliases(Class<?>[] typeAliases) {
        this.typeAliases = typeAliases;
    }

    public void setFailFast(boolean failFast) {
        this.failFast = failFast;
    }

    public void setConfigLocation(Resource configLocation) {
        this.configLocation = configLocation;
    }

    public void setConfiguration(MybatisConfiguration configuration) {
        this.configuration = configuration;
    }

    public void setMapperLocations(Resource[] mapperLocations) {
        this.mapperLocations = mapperLocations;
    }

    public void setConfigurationProperties(Properties sqlSessionFactoryProperties) {
        this.configurationProperties = sqlSessionFactoryProperties;
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource instanceof TransactionAwareDataSourceProxy ? ((TransactionAwareDataSourceProxy)dataSource).getTargetDataSource() : dataSource;
    }

    public void setSqlSessionFactoryBuilder(SqlSessionFactoryBuilder sqlSessionFactoryBuilder) {
        this.sqlSessionFactoryBuilder = sqlSessionFactoryBuilder;
    }

    public void setTransactionFactory(TransactionFactory transactionFactory) {
        this.transactionFactory = transactionFactory;
    }

    public void setEnvironment(String environment) {
        this.environment = environment;
    }

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.dataSource, (String)"Property 'dataSource' is required");
        Assert.notNull((Object)this.sqlSessionFactoryBuilder, (String)"Property 'sqlSessionFactoryBuilder' is required");
        Assert.state((this.configuration == null && this.configLocation == null || this.configuration == null || this.configLocation == null ? 1 : 0) != 0, (String)"Property 'configuration' and 'configLocation' can not specified with together");
        this.sqlSessionFactory = this.buildSqlSessionFactory();
    }

    protected SqlSessionFactory buildSqlSessionFactory() throws Exception {
        SqlSessionFactory sqlSessionFactory;
        MybatisConfiguration configuration;
        MybatisXMLConfigBuilder xmlConfigBuilder = null;
        if (this.configuration != null) {
            configuration = this.configuration;
            if (configuration.getVariables() == null) {
                configuration.setVariables(this.configurationProperties);
            } else if (this.configurationProperties != null) {
                configuration.getVariables().putAll((Map<?, ?>)this.configurationProperties);
            }
        } else if (this.configLocation != null) {
            xmlConfigBuilder = new MybatisXMLConfigBuilder(this.configLocation.getInputStream(), null, this.configurationProperties);
            configuration = xmlConfigBuilder.getConfiguration();
        } else {
            LOGGER.debug(() -> "Property 'configuration' or 'configLocation' not specified, using default MyBatis Configuration");
            configuration = new MybatisConfiguration();
            Optional.ofNullable(this.configurationProperties).ifPresent(arg_0 -> ((MybatisConfiguration)configuration).setVariables(arg_0));
        }
        this.globalConfig = Optional.ofNullable(this.globalConfig).orElseGet(GlobalConfigUtils::defaults);
        this.globalConfig.setDbConfig(Optional.ofNullable(this.globalConfig.getDbConfig()).orElseGet(GlobalConfig.DbConfig::new));
        configuration.init(this.globalConfig);
        Optional.ofNullable(this.objectFactory).ifPresent(arg_0 -> ((MybatisConfiguration)configuration).setObjectFactory(arg_0));
        Optional.ofNullable(this.objectWrapperFactory).ifPresent(arg_0 -> ((MybatisConfiguration)configuration).setObjectWrapperFactory(arg_0));
        Optional.ofNullable(this.vfs).ifPresent(arg_0 -> ((MybatisConfiguration)configuration).setVfsImpl(arg_0));
        if (StringUtils.hasLength((String)this.typeAliasesPackage)) {
            ArrayList<Object> typeAliasPackageList = new ArrayList<Object>();
            if (this.typeAliasesPackage.contains("*") && !this.typeAliasesPackage.contains(",") && !this.typeAliasesPackage.contains(";")) {
                Object[] convertTypeAliasesPackages = PackageHelper.convertTypeAliasesPackage(this.typeAliasesPackage);
                if (ArrayUtils.isEmpty((Object[])convertTypeAliasesPackages)) {
                    LOGGER.warn(() -> "Can't find class in '[" + this.typeAliasesPackage + "]' package. Please check your configuration.");
                } else {
                    typeAliasPackageList.addAll(Arrays.asList(convertTypeAliasesPackages));
                }
            } else {
                String[] typeAliasPackageArray = StringUtils.tokenizeToStringArray((String)this.typeAliasesPackage, (String)",; \t\n");
                Stream.of(typeAliasPackageArray).forEach(pkg -> {
                    if (pkg.contains("*")) {
                        Object[] convertTypeAliasesPackages = PackageHelper.convertTypeAliasesPackage(pkg);
                        if (ArrayUtils.isEmpty((Object[])convertTypeAliasesPackages)) {
                            LOGGER.warn(() -> "Can't find class in '[" + pkg + "]' package. Please check your configuration.");
                        } else {
                            typeAliasPackageList.addAll(Arrays.asList(convertTypeAliasesPackages));
                        }
                    } else {
                        typeAliasPackageList.add(pkg);
                    }
                });
            }
            typeAliasPackageList.forEach(packageToScan -> {
                configuration.getTypeAliasRegistry().registerAliases(packageToScan, this.typeAliasesSuperType == null ? Object.class : this.typeAliasesSuperType);
                LOGGER.debug(() -> "Scanned package: '" + packageToScan + "' for aliases");
            });
        }
        if (StringUtils.hasLength((String)this.typeEnumsPackage)) {
            Set<Class> classes;
            if (this.typeEnumsPackage.contains("*") && !this.typeEnumsPackage.contains(",") && !this.typeEnumsPackage.contains(";")) {
                classes = PackageHelper.scanTypePackage(this.typeEnumsPackage);
                if (classes.isEmpty()) {
                    LOGGER.warn(() -> "Can't find class in '[" + this.typeEnumsPackage + "]' package. Please check your configuration.");
                }
            } else {
                String[] typeEnumsPackageArray = StringUtils.tokenizeToStringArray((String)this.typeEnumsPackage, (String)",; \t\n");
                com.baomidou.mybatisplus.core.toolkit.Assert.notNull((Object)typeEnumsPackageArray, (String)("not find typeEnumsPackage:" + this.typeEnumsPackage), (Object[])new Object[0]);
                classes = new HashSet<Class>();
                Stream.of(typeEnumsPackageArray).forEach(typePackage -> {
                    Set<Class> scanTypePackage = PackageHelper.scanTypePackage(typePackage);
                    if (scanTypePackage.isEmpty()) {
                        LOGGER.warn(() -> "Can't find class in '[" + typePackage + "]' package. Please check your configuration.");
                    } else {
                        classes.addAll(PackageHelper.scanTypePackage(typePackage));
                    }
                });
            }
            TypeHandlerRegistry typeHandlerRegistry = configuration.getTypeHandlerRegistry();
            classes.stream().filter(Class::isEnum).filter(cls -> IEnum.class.isAssignableFrom((Class<?>)cls) || EnumTypeHandler.dealEnumType(cls).isPresent()).forEach(cls -> typeHandlerRegistry.register(cls, EnumTypeHandler.class));
        }
        if (!ObjectUtils.isEmpty((Object[])this.typeAliases)) {
            Stream.of(this.typeAliases).forEach(typeAlias -> {
                configuration.getTypeAliasRegistry().registerAlias(typeAlias);
                LOGGER.debug(() -> "Registered type alias: '" + typeAlias + "'");
            });
        }
        if (!ObjectUtils.isEmpty((Object[])this.plugins)) {
            Stream.of(this.plugins).forEach(plugin -> {
                configuration.addInterceptor(plugin);
                LOGGER.debug(() -> "Registered plugin: '" + plugin + "'");
            });
        }
        if (StringUtils.hasLength((String)this.typeHandlersPackage)) {
            String[] typeHandlersPackageArray = StringUtils.tokenizeToStringArray((String)this.typeHandlersPackage, (String)",; \t\n");
            Stream.of(typeHandlersPackageArray).forEach(packageToScan -> {
                configuration.getTypeHandlerRegistry().register(packageToScan);
                LOGGER.debug(() -> "Scanned package: '" + packageToScan + "' for type handlers");
            });
        }
        if (!ObjectUtils.isEmpty((Object[])this.typeHandlers)) {
            Stream.of(this.typeHandlers).forEach(typeHandler -> {
                configuration.getTypeHandlerRegistry().register(typeHandler);
                LOGGER.debug(() -> "Registered type handler: '" + typeHandler + "'");
            });
        }
        if (this.databaseIdProvider != null) {
            try {
                configuration.setDatabaseId(this.databaseIdProvider.getDatabaseId(this.dataSource));
            }
            catch (SQLException e) {
                throw new NestedIOException("Failed getting a databaseId", (Throwable)e);
            }
        }
        Optional.ofNullable(this.cache).ifPresent(arg_0 -> ((MybatisConfiguration)configuration).addCache(arg_0));
        if (xmlConfigBuilder != null) {
            try {
                xmlConfigBuilder.parse();
                LOGGER.debug(() -> "Parsed configuration file: '" + this.configLocation + "'");
            }
            catch (Exception ex) {
                throw new NestedIOException("Failed to parse config resource: " + this.configLocation, (Throwable)ex);
            }
            finally {
                ErrorContext.instance().reset();
            }
        }
        configuration.setEnvironment(new Environment(this.environment, (TransactionFactory)(this.transactionFactory == null ? new SpringManagedTransactionFactory() : this.transactionFactory), this.dataSource));
        if (this.globalConfig.getDbConfig().getDbType() == DbType.OTHER) {
            try {
                Resource[] resourceArray = null;
                try (Connection connection = AopUtils.getTargetObject(this.dataSource).getConnection();){
                    this.globalConfig.getDbConfig().setDbType(JdbcUtils.getDbType(connection.getMetaData().getURL()));
                }
                catch (Throwable object) {
                    resourceArray = object;
                    throw object;
                }
            }
            catch (Exception e) {
                throw ExceptionUtils.mpe((String)("Error: GlobalConfigUtils setMetaData Fail !  Cause:" + e), (Object[])new Object[0]);
            }
        }
        SqlHelper.FACTORY = sqlSessionFactory = this.sqlSessionFactoryBuilder.build((Configuration)configuration);
        this.globalConfig.signGlobalConfig(sqlSessionFactory);
        if (!ObjectUtils.isEmpty((Object[])this.mapperLocations)) {
            for (Resource mapperLocation : this.mapperLocations) {
                if (mapperLocation == null) continue;
                try {
                    XMLMapperBuilder xmlMapperBuilder = new XMLMapperBuilder(mapperLocation.getInputStream(), (Configuration)configuration, mapperLocation.toString(), configuration.getSqlFragments());
                    xmlMapperBuilder.parse();
                }
                catch (Exception e) {
                    throw new NestedIOException("Failed to parse mapping resource: '" + mapperLocation + "'", (Throwable)e);
                }
                finally {
                    ErrorContext.instance().reset();
                }
                LOGGER.debug(() -> "Parsed mapper file: '" + mapperLocation + "'");
            }
        } else {
            LOGGER.debug(() -> "Property 'mapperLocations' was not specified or no matching resources found");
        }
        return sqlSessionFactory;
    }

    public SqlSessionFactory getObject() throws Exception {
        if (this.sqlSessionFactory == null) {
            this.afterPropertiesSet();
        }
        return this.sqlSessionFactory;
    }

    public Class<? extends SqlSessionFactory> getObjectType() {
        return this.sqlSessionFactory == null ? SqlSessionFactory.class : this.sqlSessionFactory.getClass();
    }

    public boolean isSingleton() {
        return true;
    }

    public void onApplicationEvent(ApplicationEvent event) {
        if (this.failFast && event instanceof ContextRefreshedEvent) {
            this.sqlSessionFactory.getConfiguration().getMappedStatementNames();
        }
    }
}

