/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.kisso.web.interceptor;

import com.baomidou.kisso.SSOConfig;
import com.baomidou.kisso.SSOHelper;
import com.baomidou.kisso.SSOToken;
import com.baomidou.kisso.annotation.Action;
import com.baomidou.kisso.annotation.Permission;
import com.baomidou.kisso.common.shiro.SSOAuthToken;
import com.baomidou.kisso.web.interceptor.SSOPermissionInterceptor;
import java.lang.reflect.Method;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.session.Session;
import org.apache.shiro.subject.Subject;
import org.springframework.web.method.HandlerMethod;

public class SSOShiroInterceptor
extends SSOPermissionInterceptor {
    private static final Logger logger = Logger.getLogger("SSOShiroInterceptor");

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        if (handler instanceof HandlerMethod) {
            String uri;
            SSOToken token = (SSOToken)SSOHelper.attrToken(request);
            if (token == null) {
                return true;
            }
            Subject currentUser = SecurityUtils.getSubject();
            Session session = currentUser.getSession(false);
            if (session != null) {
                session.touch();
            }
            if (!currentUser.isAuthenticated()) {
                currentUser.login((AuthenticationToken)new SSOAuthToken(token));
                logger.fine(" shiro login success. ");
            }
            if (SSOConfig.getInstance().isPermissionUri() && ((uri = request.getRequestURI()) == null || currentUser.isPermitted(uri))) {
                return true;
            }
            HandlerMethod handlerMethod = (HandlerMethod)handler;
            Method method = handlerMethod.getMethod();
            Permission pm = method.getAnnotation(Permission.class);
            if (pm != null) {
                if (pm.action() == Action.Skip) {
                    return true;
                }
                if (!"".equals(pm.value()) && currentUser.isPermitted(pm.value())) {
                    return true;
                }
            }
            return this.unauthorizedAccess(request, response);
        }
        return true;
    }
}

