/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.kisso;

import com.baomidou.kisso.AuthToken;
import com.baomidou.kisso.SSOConfig;
import com.baomidou.kisso.Token;
import com.baomidou.kisso.common.util.RandomUtil;
import com.baomidou.kisso.service.ConfigurableAbstractKissoService;
import java.io.IOException;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SSOHelper {
    protected static final Logger logger = Logger.getLogger("SSOHelper");
    protected static ConfigurableAbstractKissoService kissService = null;

    public static ConfigurableAbstractKissoService getKissoService() {
        if (kissService == null) {
            kissService = new ConfigurableAbstractKissoService();
        }
        return kissService;
    }

    public static String getSecretKey() {
        return RandomUtil.getCharacterAndNumber(18);
    }

    public static String getLoginCount(HttpServletRequest request) {
        return SSOHelper.getKissoService().getLoginCount(request);
    }

    public static void setSSOCookie(HttpServletRequest request, HttpServletResponse response, Token token, boolean invalidate) {
        if (invalidate) {
            SSOHelper.getKissoService().authSSOCookie(request, response, token);
        } else {
            SSOHelper.getKissoService().setSSOCookie(request, response, token);
        }
    }

    public static <T extends Token> T getToken(HttpServletRequest request) {
        return (T)SSOHelper.getKissoService().getToken(request);
    }

    public static <T extends Token> T attrToken(HttpServletRequest request) {
        return SSOHelper.getKissoService().attrToken(request);
    }

    public static void logout(HttpServletRequest request, HttpServletResponse response) throws IOException {
        SSOHelper.getKissoService().logout(request, response);
    }

    public static boolean clearLogin(HttpServletRequest request, HttpServletResponse response) {
        return SSOHelper.getKissoService().clearLogin(request, response);
    }

    public static void clearRedirectLogin(HttpServletRequest request, HttpServletResponse response) throws IOException {
        SSOHelper.getKissoService().clearRedirectLogin(request, response);
    }

    public static String getTokenCacheKey(HttpServletRequest request) {
        return ((Token)SSOHelper.getToken(request)).toCacheKey();
    }

    public static String getTokenCacheKey(Object userId) {
        return SSOConfig.toCacheKey(userId);
    }

    public static boolean kickLogin(Object userId) {
        return SSOHelper.getKissoService().kickLogin(userId);
    }

    public static AuthToken askCiphertext(HttpServletRequest request, HttpServletResponse response, String privateKey) {
        return SSOHelper.getKissoService().askCiphertext(request, response, privateKey);
    }

    public static AuthToken replyCiphertext(HttpServletRequest request, String askData) {
        return SSOHelper.getKissoService().replyCiphertext(request, askData);
    }

    public static AuthToken ok(HttpServletRequest request, HttpServletResponse response, String replyData, String atPk, String ssoPrk) {
        return SSOHelper.getKissoService().ok(request, response, replyData, atPk, ssoPrk);
    }
}

