/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.persistence;

import com.atomikos.logging.Logger;
import com.atomikos.logging.LoggerFactory;
import com.atomikos.util.IOHelper;
import java.io.File;
import java.io.IOException;
import java.util.Properties;

public class Utils {
    private static final Logger LOGGER = LoggerFactory.createLogger(Utils.class);

    public static String findOrCreateFolder(String path) {
        String result;
        File ret = new File(".");
        if (path != null) {
            File tmp = new File(path);
            if (tmp.exists()) {
                if (tmp.isDirectory()) {
                    ret = tmp;
                } else {
                    String msg = path + " is not a directory - using default";
                    LOGGER.logWarning(msg);
                }
            } else {
                String msg = path + " could not be created - using default";
                try {
                    if (IOHelper.createPathTo((File)tmp, (boolean)true)) {
                        ret = tmp;
                    } else {
                        LOGGER.logWarning(msg);
                    }
                }
                catch (IOException e) {
                    LOGGER.logWarning(msg);
                }
            }
        }
        if (!(result = ret.getAbsolutePath()).endsWith(File.separator)) {
            result = result + File.separator;
        }
        return result;
    }

    public static String getTrimmedProperty(String name, Properties p) {
        String ret = null;
        ret = p.getProperty(name);
        if (ret != null) {
            ret = ret.trim();
        }
        return ret;
    }
}

