/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.xml;

import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.net.URL;
import java.net.URLConnection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public final class XmlUtils {
    private XmlUtils() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Document parseXml(URL url) throws IOException, ParserConfigurationException, SAXException {
        URLConnection conn = url.openConnection();
        InputStream in = conn.getInputStream();
        try {
            Document document = XmlUtils.parseXml(in);
            return document;
        }
        finally {
            in.close();
        }
    }

    public static Document parseXml(InputStream in) throws IOException, ParserConfigurationException, SAXException {
        DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = builderFactory.newDocumentBuilder();
        return builder.parse(in);
    }

    public static Iterable<Node> iterableNodes(final NodeList nodeList) {
        return new Iterable<Node>(){

            @Override
            public Iterator<Node> iterator() {
                return new Iterator<Node>(){
                    int index = 0;

                    @Override
                    public boolean hasNext() {
                        return this.index < nodeList.getLength();
                    }

                    @Override
                    public Node next() {
                        if (this.hasNext()) {
                            return nodeList.item(this.index++);
                        }
                        throw new NoSuchElementException();
                    }

                    @Override
                    public void remove() throws UnsupportedOperationException {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }

    public static Iterable<Element> iterableElements(final NodeList nodeList) {
        return new Iterable<Element>(){

            @Override
            public Iterator<Element> iterator() {
                return new Iterator<Element>(){
                    int index = 0;

                    @Override
                    public boolean hasNext() {
                        while (this.index < nodeList.getLength() && !(nodeList.item(this.index) instanceof Element)) {
                            ++this.index;
                        }
                        return this.index < nodeList.getLength();
                    }

                    @Override
                    public Element next() {
                        if (this.hasNext()) {
                            return (Element)nodeList.item(this.index++);
                        }
                        throw new NoSuchElementException();
                    }

                    @Override
                    public void remove() throws UnsupportedOperationException {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }

    public static Iterable<Element> iterableChildElementsByTagName(final Element element, final String childTagName) {
        return new Iterable<Element>(){

            @Override
            public Iterator<Element> iterator() {
                return new Iterator<Element>(){
                    NodeList children;
                    int index;
                    {
                        this.children = element.getChildNodes();
                        this.index = 0;
                    }

                    @Override
                    public boolean hasNext() {
                        Element childElem;
                        Node child;
                        while (!(this.index >= this.children.getLength() || (child = this.children.item(this.index)) instanceof Element && childTagName.equals((childElem = (Element)child).getTagName()))) {
                            ++this.index;
                        }
                        return this.index < this.children.getLength();
                    }

                    @Override
                    public Element next() {
                        if (this.hasNext()) {
                            return (Element)this.children.item(this.index++);
                        }
                        throw new NoSuchElementException();
                    }

                    @Override
                    public void remove() throws UnsupportedOperationException {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }

    public static Element getChildElementByTagName(Element element, String childTagName) {
        Element matched = null;
        NodeList children = element.getChildNodes();
        int len = children.getLength();
        for (int index = 0; index < len; ++index) {
            Element childElem;
            Node child = children.item(index);
            if (!(child instanceof Element) || !childTagName.equals((childElem = (Element)child).getTagName())) continue;
            if (matched != null) {
                throw new IllegalStateException("More than one child found: " + childTagName);
            }
            matched = childElem;
        }
        return matched;
    }

    public static String getChildTextContent(Element element, String childTagName) {
        Element childElem = XmlUtils.getChildElementByTagName(element, childTagName);
        return childElem == null ? null : childElem.getTextContent();
    }

    @Deprecated
    public static String toString(Document document) throws TransformerConfigurationException, TransformerException {
        return XmlUtils.toString((Node)document);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String toString(Node node) throws TransformerConfigurationException, TransformerException {
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        transformerFactory.setAttribute("indent-number", 4);
        Transformer transformer = transformerFactory.newTransformer();
        transformer.setOutputProperty("method", "xml");
        transformer.setOutputProperty("indent", "yes");
        StringWriter writer = new StringWriter();
        try {
            transformer.transform(new DOMSource(node), new StreamResult(writer));
        }
        finally {
            try {
                writer.close();
            }
            catch (IOException e) {
                AssertionError ae = new AssertionError((Object)"IOException should never be thrown from StringWriter");
                ((Throwable)((Object)ae)).initCause(e);
                throw ae;
            }
        }
        return writer.toString();
    }
}

