/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.util.i18n;

import com.aoindustries.text.MessageFormatFactory;
import com.aoindustries.util.i18n.ThreadLocale;
import java.io.Serializable;
import java.text.FieldPosition;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class ApplicationResourcesAccessor
implements Serializable {
    private static final long serialVersionUID = -8735217773587095120L;
    private static final ConcurrentMap<String, ApplicationResourcesAccessor> accessors = new ConcurrentHashMap<String, ApplicationResourcesAccessor>();
    private static final ListenersLock listenersLock = new ListenersLock();
    private static List<Listener> listeners;
    private final String baseName;

    public static ApplicationResourcesAccessor getInstance(String baseName) {
        ApplicationResourcesAccessor newAccessor;
        ApplicationResourcesAccessor existing = (ApplicationResourcesAccessor)accessors.get(baseName);
        if (existing == null && (existing = accessors.putIfAbsent(baseName, newAccessor = new ApplicationResourcesAccessor(baseName))) == null) {
            existing = newAccessor;
        }
        return existing;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addListener(Listener listener) {
        ListenersLock listenersLock = ApplicationResourcesAccessor.listenersLock;
        synchronized (listenersLock) {
            List<Listener> newListeners;
            if (listeners == null) {
                newListeners = Collections.singletonList(listener);
            } else {
                newListeners = new ArrayList<Listener>(listeners.size() + 1);
                newListeners.addAll(listeners);
                newListeners.add(listener);
            }
            listeners = newListeners;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeListener(Listener listener) {
        ListenersLock listenersLock = ApplicationResourcesAccessor.listenersLock;
        synchronized (listenersLock) {
            if (listeners != null) {
                ArrayList<Listener> newListeners = new ArrayList<Listener>(listeners.size() - 1);
                for (Listener l : listeners) {
                    if (l == listener) continue;
                    newListeners.add(l);
                }
                if (newListeners.isEmpty()) {
                    listeners = null;
                } else if (newListeners.size() == 1) {
                    listeners = Collections.singletonList(newListeners.get(0));
                } else {
                    newListeners.trimToSize();
                    listeners = newListeners;
                }
            }
        }
    }

    private ApplicationResourcesAccessor(String baseName) {
        this.baseName = baseName;
    }

    private Object readResolve() {
        return ApplicationResourcesAccessor.getInstance(this.baseName);
    }

    public String getBaseName() {
        return this.baseName;
    }

    public ResourceBundle getResourceBundle(Locale locale) {
        return ResourceBundle.getBundle(this.baseName, locale);
    }

    public String getMessage(String key) {
        return this.getMessage(ThreadLocale.get(), key);
    }

    public String getMessage(Locale locale, String key) {
        String string = null;
        try {
            string = this.getResourceBundle(locale).getString(key);
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        if (string == null) {
            return "???" + locale.toString() + "." + key + "???";
        }
        return string;
    }

    public String getMessage(String key, Object ... args) {
        return this.getMessage(ThreadLocale.get(), key, args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getMessage(Locale locale, String key, Object ... args) {
        List<Listener> myListeners;
        String resource = null;
        try {
            resource = this.getResourceBundle(locale).getString(key);
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        if (resource == null) {
            return "???" + locale.toString() + '.' + key + "???";
        }
        String result = args.length == 0 ? new String(resource) : MessageFormatFactory.getMessageFormat(resource, locale).format(args, new StringBuffer(resource.length() << 1), (FieldPosition)null).toString();
        ListenersLock listenersLock = ApplicationResourcesAccessor.listenersLock;
        synchronized (listenersLock) {
            myListeners = listeners;
        }
        if (myListeners != null) {
            for (Listener l : myListeners) {
                l.onGetMessage(this, locale, key, args, resource, result);
            }
        }
        return result;
    }

    private static class ListenersLock {
        private ListenersLock() {
        }
    }

    public static interface Listener {
        public void onGetMessage(ApplicationResourcesAccessor var1, Locale var2, String var3, Object[] var4, String var5, String var6);
    }
}

