/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.util;

import com.aoindustries.util.AoCollections;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class MinimalList {
    private MinimalList() {
    }

    public static <E> List<E> add(List<E> list, E elem) {
        if (list == null) {
            list = Collections.singletonList(elem);
        } else if (list.size() == 1) {
            ArrayList<E> newList = new ArrayList<E>(8);
            newList.add(list.get(0));
            newList.add(elem);
            list = newList;
        } else {
            list.add(elem);
        }
        return list;
    }

    public static <E> E get(List<E> list, int index) throws IndexOutOfBoundsException {
        if (list == null) {
            throw new IndexOutOfBoundsException();
        }
        return list.get(index);
    }

    public static <E> List<E> copy(List<E> list) {
        if (list == null) {
            return null;
        }
        if (list.size() == 1) {
            return list;
        }
        return new ArrayList<E>(list);
    }

    public static <E> List<E> unmodifiable(List<E> list) {
        if (list == null) {
            return Collections.emptyList();
        }
        return AoCollections.optimalUnmodifiableList(list);
    }
}

