/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.text;

import com.aoindustries.lang.ObjectUtils;
import java.math.BigDecimal;
import java.text.Collator;
import java.util.Comparator;
import java.util.Locale;

public class SmartComparator
implements Comparator<Object> {
    private final Collator collator;

    public SmartComparator(Collator collator) {
        this.collator = collator;
    }

    public SmartComparator(Locale locale) {
        this(Collator.getInstance(locale));
    }

    public SmartComparator() {
        this(Collator.getInstance());
    }

    static final Token nextToken(String value, int pos) {
        int len = value.length();
        if (pos > len) {
            throw new IllegalArgumentException();
        }
        if (pos == len) {
            return new Token(TokenType.EMPTY, value, pos, len);
        }
        for (int i = pos; i < len; ++i) {
            char ch2;
            int prefixLen;
            boolean dotUsed;
            boolean isNumeric;
            char ch1 = value.charAt(i);
            if (ch1 >= '0' && ch1 <= '9') {
                isNumeric = true;
                dotUsed = false;
                prefixLen = 1;
            } else if (ch1 == '.' && i < len - 1 && (ch2 = value.charAt(i + 1)) >= '0' && ch2 <= '9') {
                isNumeric = true;
                dotUsed = true;
                prefixLen = 2;
            } else if (ch1 == '-' && i < len - 1 && (ch2 = value.charAt(i + 1)) >= '0' && ch2 <= '9') {
                isNumeric = true;
                dotUsed = false;
                prefixLen = 2;
            } else if (ch1 == '-' && i < len - 2 && value.charAt(i + 1) == '.' && (ch2 = value.charAt(i + 2)) >= '0' && ch2 <= '9') {
                isNumeric = true;
                dotUsed = true;
                prefixLen = 3;
            } else {
                isNumeric = false;
                dotUsed = false;
                prefixLen = 0;
            }
            if (!isNumeric) continue;
            if (i == pos) {
                i += prefixLen;
                while (i < len) {
                    char ch = value.charAt(i);
                    if (ch == '.') {
                        if (dotUsed) break;
                        dotUsed = true;
                    } else if (ch < '0' || ch > '9') break;
                    ++i;
                }
                return new Token(TokenType.NUMERIC, value, pos, i);
            }
            return new Token(TokenType.STRING, value, pos, i);
        }
        return new Token(TokenType.STRING, value, pos, len);
    }

    @Override
    public int compare(Object o1, Object o2) {
        return this.compare(ObjectUtils.toString(o1), ObjectUtils.toString(o2));
    }

    @Override
    public int compare(String s1, String s2) {
        if (s1 == null) {
            if (s2 == null) {
                return 0;
            }
            return 1;
        }
        if (s2 == null) {
            return -1;
        }
        int len1 = s1.length();
        int len2 = s2.length();
        int pos1 = 0;
        int pos2 = 0;
        while (pos1 < len1 || pos2 < len2) {
            Token t1 = SmartComparator.nextToken(s1, pos1);
            Token t2 = SmartComparator.nextToken(s2, pos2);
            TokenType type1 = t1.tokenType;
            TokenType type2 = t2.tokenType;
            if (type1 == TokenType.EMPTY && type2 == TokenType.EMPTY) {
                return 0;
            }
            if (type1 != type2) {
                String remainder2;
                String remainder1 = s1.substring(t1.begin);
                int diff = this.collator.compare(remainder1, remainder2 = s2.substring(t2.begin));
                if (diff == 0) {
                    diff = remainder1.compareTo(remainder2);
                }
                return diff;
            }
            String sub1 = t1.value.substring(t1.begin, t1.end);
            String sub2 = t2.value.substring(t2.begin, t2.end);
            if (type1 == TokenType.NUMERIC) {
                assert (type2 == TokenType.NUMERIC);
                BigDecimal bd1 = new BigDecimal(sub1);
                BigDecimal bd2 = new BigDecimal(sub2);
                int diff = bd1.compareTo(bd2);
                if (diff == 0) {
                    diff = sub1.compareTo(sub2);
                }
                if (diff != 0) {
                    return diff;
                }
            } else if (type1 == TokenType.STRING) {
                assert (type2 == TokenType.STRING);
                int diff = this.collator.compare(sub1, sub2);
                if (diff == 0) {
                    diff = sub1.compareTo(sub2);
                }
                if (diff != 0) {
                    return diff;
                }
            } else {
                throw new AssertionError();
            }
            pos1 = t1.end;
            pos2 = t2.end;
        }
        return 0;
    }

    static class Token {
        final TokenType tokenType;
        final String value;
        final int begin;
        final int end;

        Token(TokenType tokenType, String value, int begin, int end) {
            this.tokenType = tokenType;
            this.value = value;
            this.begin = begin;
            this.end = end;
        }
    }

    static enum TokenType {
        EMPTY,
        NUMERIC,
        STRING;

    }
}

