/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.security;

import com.aoindustries.util.WrappedException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.spec.InvalidKeySpecException;
import java.util.Arrays;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;

public class HashedPassword {
    private static final String PBKDF2_ALGORITHM = "PBKDF2WithHmacSHA1";
    public static final int SALT_BYTES = 32;
    public static final int HASH_BYTES = 32;
    public static final int RECOMMENDED_ITERATIONS = 1000;
    private static final SecureRandom secureRandom = new SecureRandom();
    private final byte[] salt;
    private final int iterations;
    private final byte[] hash;

    public static byte[] generateSalt() {
        byte[] salt = new byte[32];
        secureRandom.nextBytes(salt);
        return salt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] hash(String password, byte[] salt, int iterations) {
        byte[] byArray;
        char[] chars = password.toCharArray();
        try {
            PBEKeySpec spec = new PBEKeySpec(chars, salt, iterations, 256);
            SecretKeyFactory skf = SecretKeyFactory.getInstance(PBKDF2_ALGORITHM);
            byte[] hash = skf.generateSecret(spec).getEncoded();
            assert (hash.length == 32);
            byArray = hash;
        }
        catch (Throwable throwable) {
            try {
                Arrays.fill(chars, '\u0000');
                throw throwable;
            }
            catch (InvalidKeySpecException e) {
                throw new WrappedException(e);
            }
            catch (NoSuchAlgorithmException e) {
                throw new WrappedException(e);
            }
        }
        Arrays.fill(chars, '\u0000');
        return byArray;
    }

    public HashedPassword(byte[] salt, int iterations, byte[] hash) {
        this.salt = Arrays.copyOf(salt, salt.length);
        Arrays.fill(salt, (byte)0);
        this.iterations = iterations;
        this.hash = Arrays.copyOf(hash, hash.length);
        Arrays.fill(hash, (byte)0);
    }

    public String toString() {
        return "*";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean matches(String password) {
        byte[] newHash = HashedPassword.hash(password, this.salt, this.iterations);
        try {
            boolean bl = HashedPassword.slowEquals(this.hash, newHash);
            return bl;
        }
        finally {
            Arrays.fill(newHash, (byte)0);
        }
    }

    private static boolean slowEquals(byte[] a, byte[] b) {
        int diff = a.length ^ b.length;
        for (int i = 0; i < a.length && i < b.length; ++i) {
            diff |= a[i] ^ b[i];
        }
        return diff == 0;
    }
}

