/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.lang;

import com.aoindustries.util.BufferManager;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.InterruptedIOException;
import java.io.Reader;
import java.nio.charset.Charset;

public class ProcessResult {
    private final int exitVal;
    private final String stdout;
    private final String stderr;

    public static ProcessResult exec(String ... command) throws IOException {
        return ProcessResult.getProcessResult(Runtime.getRuntime().exec(command), Charset.defaultCharset());
    }

    public static ProcessResult exec(String[] command, Charset charset) throws IOException {
        return ProcessResult.getProcessResult(Runtime.getRuntime().exec(command), charset);
    }

    public static ProcessResult getProcessResult(Process process) throws IOException {
        return ProcessResult.getProcessResult(process, Charset.defaultCharset());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ProcessResult getProcessResult(final Process process, final Charset charset) throws IOException {
        process.getOutputStream().close();
        final String[] stderrWrapper = new String[1];
        final IOException[] stderrException = new IOException[1];
        Thread stderrThread = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public void run() {
                StringBuilder stderrBuilder = null;
                try {
                    String[] stderrIn = new InputStreamReader(process.getErrorStream(), charset);
                    try {
                        char[] buff = BufferManager.getChars();
                        try {
                            int count;
                            while ((count = stderrIn.read(buff, 0, 4096)) != -1) {
                                if (count <= 0) continue;
                                if (stderrBuilder == null) {
                                    stderrBuilder = new StringBuilder(Math.max(count, 16));
                                }
                                stderrBuilder.append(buff, 0, count);
                            }
                        }
                        finally {
                            BufferManager.release(buff, false);
                        }
                    }
                    finally {
                        stderrIn.close();
                    }
                    stderrIn = stderrWrapper;
                }
                catch (IOException exc) {
                    try {
                        IOException[] iOExceptionArray = stderrException;
                        synchronized (stderrException) {
                            stderrException[0] = exc;
                            // ** MonitorExit[var3_6] (shouldn't be in output)
                            String[] stringArray = stderrWrapper;
                        }
                    }
                    catch (Throwable throwable) {
                        String[] stringArray = stderrWrapper;
                        synchronized (stderrWrapper) {
                            stderrWrapper[0] = stderrBuilder == null ? "" : stderrBuilder.toString();
                            // ** MonitorExit[var11_14] (shouldn't be in output)
                            throw throwable;
                        }
                    }
                    {
                        synchronized (stderrWrapper) {
                            stderrWrapper[0] = stderrBuilder == null ? "" : stderrBuilder.toString();
                            // ** MonitorExit[var2_4] (shouldn't be in output)
                            return;
                        }
                    }
                }
                synchronized (stderrWrapper) {
                    stderrWrapper[0] = stderrBuilder == null ? "" : stderrBuilder.toString();
                    // ** MonitorExit[stderrIn] (shouldn't be in output)
                    return;
                }
            }
        });
        stderrThread.start();
        try {
            Object[] buff;
            StringBuilder stdoutBuilder = null;
            IOException stdoutException = null;
            try {
                InputStreamReader stdoutIn = new InputStreamReader(process.getInputStream(), charset);
                try {
                    buff = BufferManager.getChars();
                    try {
                        int count;
                        while ((count = ((Reader)stdoutIn).read((char[])buff, 0, 4096)) != -1) {
                            if (count <= 0) continue;
                            if (stdoutBuilder == null) {
                                stdoutBuilder = new StringBuilder(Math.max(count, 16));
                            }
                            stdoutBuilder.append((char[])buff, 0, count);
                        }
                    }
                    finally {
                        BufferManager.release(buff, false);
                    }
                }
                finally {
                    ((Reader)stdoutIn).close();
                }
            }
            catch (IOException exc) {
                stdoutException = exc;
            }
            stderrThread.join();
            int exitVal = process.waitFor();
            if (stdoutException != null) {
                throw stdoutException;
            }
            buff = stderrException;
            synchronized (stderrException) {
                if (stderrException[0] != null) {
                    throw stderrException[0];
                }
                // ** MonitorExit[buff /* !! */ ] (shouldn't be in output)
                String stdout = stdoutBuilder == null ? "" : stdoutBuilder.toString();
                String[] stringArray = stderrWrapper;
                synchronized (stderrWrapper) {
                    String stderr = stderrWrapper[0];
                    // ** MonitorExit[var10_16] (shouldn't be in output)
                    if (stderr == null) {
                        stderr = "";
                    }
                    return new ProcessResult(exitVal, stdout, stderr);
                }
            }
        }
        catch (InterruptedException err) {
            Thread.currentThread().interrupt();
            InterruptedIOException ioErr = new InterruptedIOException();
            ioErr.initCause(err);
            throw ioErr;
        }
    }

    private ProcessResult(int exitVal, String stdout, String stderr) {
        this.exitVal = exitVal;
        this.stdout = stdout;
        this.stderr = stderr;
    }

    public int getExitVal() {
        return this.exitVal;
    }

    public String getStdout() {
        return this.stdout;
    }

    public String getStderr() {
        return this.stderr;
    }
}

