/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.encoding;

import com.aoindustries.encoding.MediaEncoder;
import com.aoindustries.encoding.MediaType;
import com.aoindustries.encoding.XhtmlValidator;
import java.io.IOException;
import java.io.Writer;

public class TextInXhtmlEncoder
extends MediaEncoder {
    public static final TextInXhtmlEncoder textInXhtmlEncoder = new TextInXhtmlEncoder();

    private static String getEscapedCharacter(char c) throws IOException {
        switch (c) {
            case '<': {
                return "&lt;";
            }
            case '>': {
                return "&gt;";
            }
            case '&': {
                return "&amp;";
            }
        }
        XhtmlValidator.checkCharacter(c);
        return null;
    }

    public static void encodeTextInXhtml(char ch, Appendable out) throws IOException {
        String escaped = TextInXhtmlEncoder.getEscapedCharacter(ch);
        if (escaped != null) {
            out.append(escaped);
        } else {
            out.append(ch);
        }
    }

    public static void encodeTextInXhtml(char[] cbuf, Writer out) throws IOException {
        TextInXhtmlEncoder.encodeTextInXhtml(cbuf, 0, cbuf.length, out);
    }

    public static void encodeTextInXhtml(char[] cbuf, int start, int len, Writer out) throws IOException {
        int end = start + len;
        int toPrint = 0;
        for (int c = start; c < end; ++c) {
            String escaped = TextInXhtmlEncoder.getEscapedCharacter(cbuf[c]);
            if (escaped != null) {
                if (toPrint > 0) {
                    out.write(cbuf, c - toPrint, toPrint);
                    toPrint = 0;
                }
                out.write(escaped);
                continue;
            }
            ++toPrint;
        }
        if (toPrint > 0) {
            out.write(cbuf, end - toPrint, toPrint);
        }
    }

    public static void encodeTextInXhtml(CharSequence S, Appendable out) throws IOException {
        if (S != null) {
            TextInXhtmlEncoder.encodeTextInXhtml(S, 0, S.length(), out);
        }
    }

    public static void encodeTextInXhtml(CharSequence S, int start, int end, Appendable out) throws IOException {
        if (S != null) {
            int toPrint = 0;
            for (int c = start; c < end; ++c) {
                String escaped = TextInXhtmlEncoder.getEscapedCharacter(S.charAt(c));
                if (escaped != null) {
                    if (toPrint > 0) {
                        out.append(S, c - toPrint, c);
                        toPrint = 0;
                    }
                    out.append(escaped);
                    continue;
                }
                ++toPrint;
            }
            if (toPrint > 0) {
                out.append(S, end - toPrint, end);
            }
        }
    }

    private TextInXhtmlEncoder() {
    }

    @Override
    public boolean isValidatingMediaInputType(MediaType inputType) {
        return inputType == MediaType.TEXT;
    }

    @Override
    public MediaType getValidMediaOutputType() {
        return MediaType.XHTML;
    }

    @Override
    public void write(int c, Writer out) throws IOException {
        TextInXhtmlEncoder.encodeTextInXhtml((char)c, (Appendable)out);
    }

    @Override
    public void write(char[] cbuf, Writer out) throws IOException {
        TextInXhtmlEncoder.encodeTextInXhtml(cbuf, out);
    }

    @Override
    public void write(char[] cbuf, int off, int len, Writer out) throws IOException {
        TextInXhtmlEncoder.encodeTextInXhtml(cbuf, off, len, out);
    }

    @Override
    public void write(String str, Writer out) throws IOException {
        if (str == null) {
            throw new IllegalArgumentException("str is null");
        }
        TextInXhtmlEncoder.encodeTextInXhtml(str, (Appendable)out);
    }

    @Override
    public void write(String str, int off, int len, Writer out) throws IOException {
        if (str == null) {
            throw new IllegalArgumentException("str is null");
        }
        TextInXhtmlEncoder.encodeTextInXhtml(str, off, off + len, (Appendable)out);
    }

    @Override
    public TextInXhtmlEncoder append(char c, Appendable out) throws IOException {
        TextInXhtmlEncoder.encodeTextInXhtml(c, out);
        return this;
    }

    @Override
    public TextInXhtmlEncoder append(CharSequence csq, Appendable out) throws IOException {
        TextInXhtmlEncoder.encodeTextInXhtml(csq == null ? "null" : csq, out);
        return this;
    }

    @Override
    public TextInXhtmlEncoder append(CharSequence csq, int start, int end, Appendable out) throws IOException {
        TextInXhtmlEncoder.encodeTextInXhtml(csq == null ? "null" : csq, start, end, out);
        return this;
    }
}

