/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.encoding;

import com.aoindustries.encoding.MediaEncoder;
import com.aoindustries.encoding.MediaType;
import com.aoindustries.encoding.NewEncodingUtils;
import java.io.IOException;
import java.io.Writer;

public final class TextInJavaScriptEncoder
extends MediaEncoder {
    public static final TextInJavaScriptEncoder textInJavaScriptEncoder = new TextInJavaScriptEncoder(MediaType.JAVASCRIPT);
    public static final TextInJavaScriptEncoder textInJsonEncoder = new TextInJavaScriptEncoder(MediaType.JSON);
    public static final TextInJavaScriptEncoder textInLdJsonEncoder = new TextInJavaScriptEncoder(MediaType.LD_JSON);
    private final MediaType outputType;

    private static String getEscapedCharacter(char ch) {
        switch (ch) {
            case '\"': {
                return "\\\"";
            }
            case '\'': {
                return "\\'";
            }
            case '\\': {
                return "\\\\";
            }
            case '\b': {
                return "\\b";
            }
            case '\f': {
                return "\\f";
            }
            case '\r': {
                return "\\r";
            }
            case '\n': {
                return "\\n";
            }
            case '\t': {
                return "\\t";
            }
            case '&': {
                return "\\u0026";
            }
            case '<': {
                return "\\u003c";
            }
            case '>': {
                return "\\u003e";
            }
        }
        if (ch < ' ') {
            return NewEncodingUtils.getJavaScriptUnicodeEscapeString(ch);
        }
        return null;
    }

    public static void encodeTextInJavaScript(char ch, Appendable out) throws IOException {
        String escaped = TextInJavaScriptEncoder.getEscapedCharacter(ch);
        if (escaped != null) {
            out.append(escaped);
        } else {
            out.append(ch);
        }
    }

    public static void encodeTextInJavaScript(char[] cbuf, Writer out) throws IOException {
        TextInJavaScriptEncoder.encodeTextInJavaScript(cbuf, 0, cbuf.length, out);
    }

    public static void encodeTextInJavaScript(char[] cbuf, int start, int len, Writer out) throws IOException {
        int end = start + len;
        int toPrint = 0;
        for (int c = start; c < end; ++c) {
            String escaped = TextInJavaScriptEncoder.getEscapedCharacter(cbuf[c]);
            if (escaped != null) {
                if (toPrint > 0) {
                    out.write(cbuf, c - toPrint, toPrint);
                    toPrint = 0;
                }
                out.write(escaped);
                continue;
            }
            ++toPrint;
        }
        if (toPrint > 0) {
            out.write(cbuf, end - toPrint, toPrint);
        }
    }

    public static void encodeTextInJavaScript(CharSequence S, Appendable out) throws IOException {
        if (S != null) {
            TextInJavaScriptEncoder.encodeTextInJavaScript(S, 0, S.length(), out);
        }
    }

    public static void encodeTextInJavaScript(CharSequence S, int start, int end, Appendable out) throws IOException {
        if (S != null) {
            int toPrint = 0;
            for (int c = start; c < end; ++c) {
                String escaped = TextInJavaScriptEncoder.getEscapedCharacter(S.charAt(c));
                if (escaped != null) {
                    if (toPrint > 0) {
                        out.append(S, c - toPrint, c);
                        toPrint = 0;
                    }
                    out.append(escaped);
                    continue;
                }
                ++toPrint;
            }
            if (toPrint > 0) {
                out.append(S, end - toPrint, end);
            }
        }
    }

    private TextInJavaScriptEncoder(MediaType outputType) {
        this.outputType = outputType;
    }

    @Override
    public boolean isValidatingMediaInputType(MediaType inputType) {
        return inputType == MediaType.TEXT;
    }

    @Override
    public MediaType getValidMediaOutputType() {
        return this.outputType;
    }

    @Override
    public void writePrefixTo(Appendable out) throws IOException {
        out.append('\"');
    }

    @Override
    public void write(int c, Writer out) throws IOException {
        TextInJavaScriptEncoder.encodeTextInJavaScript((char)c, (Appendable)out);
    }

    @Override
    public void write(char[] cbuf, Writer out) throws IOException {
        TextInJavaScriptEncoder.encodeTextInJavaScript(cbuf, out);
    }

    @Override
    public void write(char[] cbuf, int off, int len, Writer out) throws IOException {
        TextInJavaScriptEncoder.encodeTextInJavaScript(cbuf, off, len, out);
    }

    @Override
    public void write(String str, Writer out) throws IOException {
        if (str == null) {
            throw new IllegalArgumentException("str is null");
        }
        TextInJavaScriptEncoder.encodeTextInJavaScript(str, (Appendable)out);
    }

    @Override
    public void write(String str, int off, int len, Writer out) throws IOException {
        if (str == null) {
            throw new IllegalArgumentException("str is null");
        }
        TextInJavaScriptEncoder.encodeTextInJavaScript(str, off, off + len, (Appendable)out);
    }

    @Override
    public TextInJavaScriptEncoder append(char c, Appendable out) throws IOException {
        TextInJavaScriptEncoder.encodeTextInJavaScript(c, out);
        return this;
    }

    @Override
    public TextInJavaScriptEncoder append(CharSequence csq, Appendable out) throws IOException {
        TextInJavaScriptEncoder.encodeTextInJavaScript(csq == null ? "null" : csq, out);
        return this;
    }

    @Override
    public TextInJavaScriptEncoder append(CharSequence csq, int start, int end, Appendable out) throws IOException {
        TextInJavaScriptEncoder.encodeTextInJavaScript(csq == null ? "null" : csq, start, end, out);
        return this;
    }

    @Override
    public void writeSuffixTo(Appendable out) throws IOException {
        out.append('\"');
    }
}

