/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.encoding;

import com.aoindustries.encoding.ApplicationResources;
import com.aoindustries.encoding.MediaException;
import com.aoindustries.util.i18n.MarkupType;

public enum MediaType {
    XHTML("application/xhtml+xml"){

        @Override
        boolean isUsedFor(String contentType) {
            return "application/xhtml+xml".equalsIgnoreCase(contentType) || "text/html".equalsIgnoreCase(contentType) || "application/xml".equalsIgnoreCase(contentType) || "text/xml".equalsIgnoreCase(contentType);
        }

        @Override
        public MarkupType getMarkupType() {
            return MarkupType.XHTML;
        }
    }
    ,
    XHTML_ATTRIBUTE("application/xhtml+xml+attribute"){

        @Override
        boolean isUsedFor(String contentType) {
            return "application/xhtml+xml+attribute".equalsIgnoreCase(contentType);
        }

        @Override
        public MarkupType getMarkupType() {
            return MarkupType.NONE;
        }
    }
    ,
    JAVASCRIPT("text/javascript"){

        @Override
        boolean isUsedFor(String contentType) {
            return "text/javascript".equalsIgnoreCase(contentType);
        }

        @Override
        public MarkupType getMarkupType() {
            return MarkupType.JAVASCRIPT;
        }
    }
    ,
    JSON("application/json"){

        @Override
        boolean isUsedFor(String contentType) {
            return "application/json".equalsIgnoreCase(contentType);
        }

        @Override
        public MarkupType getMarkupType() {
            return MarkupType.JAVASCRIPT;
        }
    }
    ,
    LD_JSON("application/ld+json"){

        @Override
        boolean isUsedFor(String contentType) {
            return "application/ld+json".equalsIgnoreCase(contentType);
        }

        @Override
        public MarkupType getMarkupType() {
            return MarkupType.JAVASCRIPT;
        }
    }
    ,
    TEXT("text/plain"){

        @Override
        boolean isUsedFor(String contentType) {
            return "text/plain".equalsIgnoreCase(contentType);
        }

        @Override
        public MarkupType getMarkupType() {
            return MarkupType.TEXT;
        }
    }
    ,
    URL("text/url"){

        @Override
        boolean isUsedFor(String contentType) {
            return "text/url".equalsIgnoreCase(contentType);
        }

        @Override
        public MarkupType getMarkupType() {
            return MarkupType.NONE;
        }
    };

    private final String contentType;
    private static final MediaType[] values;

    private MediaType(String contentType) {
        this.contentType = contentType;
    }

    abstract boolean isUsedFor(String var1);

    public String getContentType() {
        return this.contentType;
    }

    public abstract MarkupType getMarkupType();

    public static MediaType getMediaTypeByName(String name) {
        for (MediaType value : values) {
            if (!value.name().equalsIgnoreCase(name)) continue;
            return value;
        }
        return null;
    }

    public static MediaType getMediaTypeForContentType(String fullContentType) throws MediaException {
        int semiPos = fullContentType.indexOf(59);
        String contentType = (semiPos == -1 ? fullContentType : fullContentType.substring(0, semiPos)).trim();
        for (MediaType value : values) {
            if (!value.isUsedFor(contentType)) continue;
            return value;
        }
        throw new MediaException(ApplicationResources.accessor.getMessage("MediaType.getMediaType.unknownType", new Object[]{fullContentType}));
    }

    static {
        values = MediaType.values();
    }
}

