/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.encoding;

import com.aoindustries.encoding.MediaEncoder;
import com.aoindustries.encoding.MediaValidator;
import com.aoindustries.encoding.MediaWriter;
import com.aoindustries.io.Encoder;
import com.aoindustries.io.Writable;
import com.aoindustries.util.EncodingUtils;
import java.io.IOException;
import java.io.Writer;
import java.lang.reflect.Field;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Node;

public final class Coercion {
    private static final Logger logger;
    private static final String BODY_CONTENT_IMPL_CLASS = "org.apache.jasper.runtime.BodyContentImpl";
    private static final String WRITER_FIELD = "writer";
    private static final Class<?> bodyContentImplClass;
    private static final Field writerField;

    public static String toString(Object value) {
        return EncodingUtils.toString((Object)value);
    }

    private static Writer unwrap(Writer out) throws IOException {
        Class<?> outClass;
        while ((outClass = out.getClass()) == bodyContentImplClass) {
            try {
                Writer writer = (Writer)writerField.get(out);
                if (writer != null) {
                    out = writer;
                    continue;
                }
                return out;
            }
            catch (IllegalAccessException e) {
                throw new IOException(e);
            }
        }
        return out;
    }

    public static void write(Object value, Writer out) throws IOException {
        if (out instanceof MediaWriter) {
            MediaWriter mediaWriter = (MediaWriter)((Object)out);
            Coercion.write(value, mediaWriter.getEncoder(), mediaWriter.getOut());
        } else if (value instanceof String) {
            out.write((String)value);
        } else if (value != null) {
            if (value instanceof Writable) {
                Writable writable = (Writable)value;
                if (writable.isFastToString()) {
                    out.write(writable.toString());
                } else {
                    writable.writeTo(Coercion.unwrap(out));
                }
            } else if (value instanceof Node) {
                try {
                    TransformerFactory transFactory = TransformerFactory.newInstance();
                    Transformer transformer = transFactory.newTransformer();
                    transformer.setOutputProperty("omit-xml-declaration", "yes");
                    transformer.transform(new DOMSource((Node)value), new StreamResult(Coercion.unwrap(out)));
                }
                catch (TransformerException e) {
                    throw new IOException(e);
                }
            } else {
                out.write(value.toString());
            }
        }
    }

    public static void write(Object value, MediaEncoder encoder, Writer out) throws IOException {
        if (encoder == null) {
            Coercion.write(value, out);
        } else if (value != null) {
            MediaValidator validator;
            while ((out = Coercion.unwrap(out)) instanceof MediaValidator && (validator = (MediaValidator)out).canSkipValidation(encoder.getValidMediaOutputType())) {
                out = validator.getOut();
            }
            if (value instanceof String) {
                encoder.write((String)value, out);
            } else if (value instanceof Writable) {
                Writable writable = (Writable)value;
                if (writable.isFastToString()) {
                    encoder.write(writable.toString(), out);
                } else {
                    writable.writeTo((Encoder)encoder, out);
                }
            } else if (value instanceof Node) {
                try {
                    TransformerFactory transFactory = TransformerFactory.newInstance();
                    Transformer transformer = transFactory.newTransformer();
                    transformer.setOutputProperty("omit-xml-declaration", "yes");
                    transformer.transform(new DOMSource((Node)value), new StreamResult((Writer)((Object)new MediaWriter(encoder, out))));
                }
                catch (TransformerException e) {
                    throw new IOException(e);
                }
            } else {
                encoder.write(value.toString(), out);
            }
        }
    }

    public static boolean isEmpty(Object value) throws IOException {
        if (value instanceof String) {
            return ((String)value).isEmpty();
        }
        if (value == null) {
            return true;
        }
        if (value instanceof Writable) {
            return ((Writable)value).getLength() == 0L;
        }
        if (value instanceof Node) {
            return false;
        }
        return value.toString().isEmpty();
    }

    public static <T> T nullIfEmpty(T value) throws IOException {
        return Coercion.isEmpty(value) ? null : (T)value;
    }

    public static int zeroIfEmpty(Integer value) throws IOException {
        return Coercion.isEmpty(value) ? 0 : value;
    }

    private Coercion() {
    }

    static {
        Field field;
        Class<?> clazz;
        logger = Logger.getLogger(Coercion.class.getName());
        try {
            clazz = Class.forName(BODY_CONTENT_IMPL_CLASS);
            field = clazz.getDeclaredField(WRITER_FIELD);
            field.setAccessible(true);
        }
        catch (Exception e) {
            if (logger.isLoggable(Level.INFO)) {
                logger.log(Level.INFO, "Cannot get direct access to the org.apache.jasper.runtime.BodyContentImpl.writer field.  Unwrapping of BodyContent disabled.  The system will behave correctly, but some optimizations are disabled.", e);
            }
            clazz = null;
            field = null;
        }
        bodyContentImplClass = clazz;
        writerField = field;
    }
}

