/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.encoding;

import com.aoindustries.encoding.MediaEncoder;
import java.io.IOException;
import java.io.Writer;

public abstract class BufferedEncoder
extends MediaEncoder {
    private final StringBuilder buffer;

    protected BufferedEncoder(int initialCapacity) {
        this.buffer = new StringBuilder(initialCapacity);
    }

    @Override
    public final void write(int c, Writer out) {
        this.buffer.append((char)c);
    }

    @Override
    public final void write(char[] cbuf, Writer out) {
        this.buffer.append(cbuf);
    }

    @Override
    public final void write(char[] cbuf, int off, int len, Writer out) {
        this.buffer.append(cbuf, off, len);
    }

    @Override
    public final void write(String str, Writer out) {
        if (str == null) {
            throw new IllegalArgumentException("str is null");
        }
        this.buffer.append(str);
    }

    @Override
    public final void write(String str, int off, int len, Writer out) {
        if (str == null) {
            throw new IllegalArgumentException("str is null");
        }
        this.buffer.append(str, off, off + len);
    }

    @Override
    public final BufferedEncoder append(char c, Appendable out) {
        this.buffer.append(c);
        return this;
    }

    @Override
    public final BufferedEncoder append(CharSequence csq, Appendable out) {
        this.buffer.append(csq);
        return this;
    }

    @Override
    public final BufferedEncoder append(CharSequence csq, int start, int end, Appendable out) {
        this.buffer.append(csq, start, end);
        return this;
    }

    @Override
    public final void writeSuffixTo(Appendable out) throws IOException {
        this.writeSuffix(this.buffer, out);
        this.buffer.setLength(0);
    }

    protected abstract void writeSuffix(StringBuilder var1, Appendable var2) throws IOException;
}

