/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.internal.incremental;

import com.android.annotations.NonNull;
import com.android.builder.internal.incremental.FileManager;
import com.android.ide.common.res2.FileStatus;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Map;

public class ChangeManager {
    private static final String FN_INPUTS_DATA = "inputs.data";
    private static final String FN_OUTPUTS_DATA = "outputs.data";
    private FileManager mInputs = new FileManager();
    private FileManager mOutputs = new FileManager();

    public boolean load(File incrementalFolder) {
        File inputs = new File(incrementalFolder, FN_INPUTS_DATA);
        File outputs = new File(incrementalFolder, FN_OUTPUTS_DATA);
        return inputs.exists() && outputs.exists() && this.mInputs.load(inputs) && this.mOutputs.load(outputs);
    }

    public void write(File incrementalFolder) throws IOException {
        if (!incrementalFolder.isDirectory() && !incrementalFolder.mkdirs()) {
            throw new IOException("Failed to create directory " + incrementalFolder);
        }
        this.mInputs.write(new File(incrementalFolder, FN_INPUTS_DATA));
        this.mOutputs.write(new File(incrementalFolder, FN_OUTPUTS_DATA));
    }

    public static void delete(File incrementalFolder) {
        File file = new File(incrementalFolder, FN_INPUTS_DATA);
        file.delete();
        file = new File(incrementalFolder, FN_OUTPUTS_DATA);
        file.delete();
    }

    public void addInput(File file) {
        this.mInputs.addFile(file);
    }

    public void addOutput(File file) {
        this.mOutputs.addFile(file);
    }

    @NonNull
    public Map<File, FileStatus> getChangedInputs() {
        return this.mInputs.getChangedFiles();
    }

    @NonNull
    public Map<File, FileStatus> getChangedOutputs() {
        return this.mOutputs.getChangedFiles();
    }

    public void updateOutputs(Collection<File> outputs) {
        this.mOutputs.update(outputs);
    }
}

