/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.oss.testing;

import com.aliyun.oss.OSSClient;
import com.aliyun.oss.model.OSSObject;
import com.aliyun.oss.model.PutObjectResult;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.concurrent.atomic.AtomicInteger;
import junit.framework.Assert;
import org.junit.Ignore;

public class ConcurrencyTest {
    private static final String endpoint = "<valid endpoint>";
    private static final String accessId = "<your access id>";
    private static final String accessKey = "<your access key>";
    private OSSClient client = new OSSClient("<valid endpoint>", "<your access id>", "<your access key>");
    private static final String bucketName = "<your bucket name>";
    private static final String key = "<object name>";
    private static final String fileLocation = "<root directory>";
    private static final String filePrefix = "get_object_";
    private AtomicInteger fileNumber = new AtomicInteger(0);
    private AtomicInteger completedCount = new AtomicInteger(0);

    @Ignore
    public void testGetObjectConcurrently() {
        int threadCount = 100;
        try {
            try {
                Thread[] ts = new Thread[100];
                int i = 0;
                while (i < 100) {
                    Runnable r = new Runnable(){

                        @Override
                        public void run() {
                            block21: {
                                OSSObject o = ConcurrencyTest.this.client.getObject(ConcurrencyTest.bucketName, ConcurrencyTest.key);
                                File f = new File(ConcurrencyTest.this.buildFilePath());
                                FileOutputStream fout = null;
                                InputStream fin = null;
                                try {
                                    try {
                                        fout = new FileOutputStream(f);
                                        fin = o.getObjectContent();
                                        byte[] buf = new byte[1024];
                                        int len = 0;
                                        while ((len = fin.read(buf)) != -1) {
                                            ((OutputStream)fout).write(buf, 0, len);
                                        }
                                        fout.flush();
                                        ConcurrencyTest.this.completedCount.incrementAndGet();
                                        System.out.println(String.valueOf(f.getName()) + " done.");
                                    }
                                    catch (IOException e) {
                                        e.printStackTrace();
                                        if (fout != null) {
                                            try {
                                                ((OutputStream)fout).close();
                                            }
                                            catch (IOException e2) {
                                                e2.printStackTrace();
                                            }
                                        }
                                        if (fin == null) break block21;
                                        try {
                                            fin.close();
                                        }
                                        catch (IOException e3) {
                                            e3.printStackTrace();
                                        }
                                    }
                                }
                                finally {
                                    if (fout != null) {
                                        try {
                                            ((OutputStream)fout).close();
                                        }
                                        catch (IOException e) {
                                            e.printStackTrace();
                                        }
                                    }
                                    if (fin != null) {
                                        try {
                                            fin.close();
                                        }
                                        catch (IOException e) {
                                            e.printStackTrace();
                                        }
                                    }
                                }
                            }
                        }
                    };
                    ts[i] = new Thread(r);
                    ++i;
                }
                i = 0;
                while (i < 100) {
                    ts[i].start();
                    ++i;
                }
                i = 0;
                while (i < 100) {
                    ts[i].join();
                    ++i;
                }
            }
            catch (Exception ex) {
                Assert.fail((String)ex.getMessage());
                int totalCompleted = this.completedCount.get();
                Assert.assertEquals((int)100, (int)totalCompleted);
            }
        }
        finally {
            int totalCompleted = this.completedCount.get();
            Assert.assertEquals((int)100, (int)totalCompleted);
        }
    }

    @Ignore
    public void testPutObjectConcurrently() {
        int threadCount = 100;
        String filePath = "D:\\software\\aliw.exe";
        try {
            try {
                Thread[] ts = new Thread[100];
                int i = 0;
                while (i < 100) {
                    final int seqNum = i;
                    Runnable r = new Runnable(){

                        @Override
                        public void run() {
                            try {
                                PutObjectResult result = ConcurrencyTest.this.client.putObject(ConcurrencyTest.bucketName, ConcurrencyTest.this.buildObjectKey(ConcurrencyTest.key, seqNum), new File("D:\\software\\aliw.exe"));
                                ConcurrencyTest.this.completedCount.incrementAndGet();
                                System.out.println(result.getETag());
                            }
                            catch (Exception e) {
                                System.out.println(e.getMessage());
                            }
                        }
                    };
                    ts[i] = new Thread(r);
                    ++i;
                }
                i = 0;
                while (i < 100) {
                    ts[i].start();
                    ++i;
                }
                i = 0;
                while (i < 100) {
                    ts[i].join();
                    ++i;
                }
            }
            catch (Exception ex) {
                Assert.fail((String)ex.getMessage());
                int totalCompleted = this.completedCount.get();
                Assert.assertEquals((int)100, (int)totalCompleted);
            }
        }
        finally {
            int totalCompleted = this.completedCount.get();
            Assert.assertEquals((int)100, (int)totalCompleted);
        }
    }

    private String buildFilePath() {
        int value = this.fileNumber.incrementAndGet();
        return "<root directory>get_object_" + value + "_" + key + ".exe";
    }

    private String buildObjectKey(String keyPrefix, int seqNum) {
        return String.valueOf(keyPrefix) + seqNum;
    }
}

