/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.oss.integrationtests;

import com.aliyun.oss.ClientException;
import com.aliyun.oss.OSSException;
import com.aliyun.oss.common.auth.Credentials;
import com.aliyun.oss.common.auth.CredentialsProvider;
import com.aliyun.oss.common.auth.DefaultCredentials;
import com.aliyun.oss.integrationtests.TestBase;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

public class SwitchCredentialsAndEndpointTest
extends TestBase {
    private volatile boolean switchStarted = false;
    private static final int loopTimes = 100;
    private static final int switchInterval = 50;

    @Ignore
    public void testSwitchValidCredentialsAndEndpoint() {
        CredentialsProvider credsProvider = defaultClient.getCredentialsProvider();
        Credentials defaultCreds = credsProvider.getCredentials();
        Assert.assertEquals((Object)"k6v3sL0ZTaIaVvMs", (Object)defaultCreds.getAccessKeyId());
        Assert.assertEquals((Object)"aIEyqeEnFhBi9LqsODzFaHP9lPodTQ", (Object)defaultCreds.getSecretAccessKey());
        try {
            String loc = defaultClient.getBucketLocation(bucketName);
            Assert.assertEquals((Object)"oss-cn-hangzhou", (Object)loc);
        }
        catch (OSSException ex) {
            Assert.fail((String)"Unable to get bucket location with default credentials.");
        }
        Credentials defaultCreds2 = new DefaultCredentials("tSxyiUM3NKswPMEp", "RzDB60Y6x4P5JmlLvgZKX0SXyYT3M8");
        defaultClient.switchCredentials(defaultCreds2);
        defaultCreds2 = credsProvider.getCredentials();
        Assert.assertEquals((Object)"tSxyiUM3NKswPMEp", (Object)defaultCreds2.getAccessKeyId());
        Assert.assertEquals((Object)"RzDB60Y6x4P5JmlLvgZKX0SXyYT3M8", (Object)defaultCreds2.getSecretAccessKey());
        try {
            String loc = defaultClient.getBucketLocation(bucketName);
            Assert.assertEquals((Object)"oss-cn-hangzhou", (Object)loc);
        }
        catch (OSSException ex) {
            SwitchCredentialsAndEndpointTest.restoreDefaultCredentials();
            Assert.fail((String)"Unable to get bucket location with another default credentials.");
        }
        Credentials secondCreds = new DefaultCredentials("nz2pc56s936cv9l", "dGkyeDRoa3NwdmJnajN2ZnVmMjA");
        defaultClient.switchCredentials(secondCreds);
        secondCreds = credsProvider.getCredentials();
        Assert.assertEquals((Object)"nz2pc56s936cv9l", (Object)secondCreds.getAccessKeyId());
        Assert.assertEquals((Object)"dGkyeDRoa3NwdmJnajN2ZnVmMjA", (Object)secondCreds.getSecretAccessKey());
        try {
            defaultClient.getBucketLocation(bucketName);
            Assert.fail((String)"Should not be able to get bucket location with second credentials.");
        }
        catch (OSSException ex) {
            Assert.assertEquals((Object)"InvalidAccessKeyId", (Object)ex.getErrorCode());
        }
        defaultClient.setEndpoint("http://oss-test.aliyun-inc.com");
        try {
            try {
                Assert.assertEquals((Object)"http://oss-test.aliyun-inc.com", (Object)defaultClient.getEndpoint().toString());
                String loc = defaultClient.getBucketLocation(bucketName);
                Assert.assertEquals((Object)"oss-cn-hangzhou", (Object)loc);
                Assert.assertEquals((Object)"http://oss-test.aliyun-inc.com", (Object)secondClient.getEndpoint().toString());
                loc = secondClient.getBucketLocation(bucketName);
                Assert.assertEquals((Object)"oss-cn-hangzhou", (Object)loc);
            }
            catch (OSSException ex) {
                Assert.fail((String)"Unable to create bucket with second credentials.");
                SwitchCredentialsAndEndpointTest.restoreDefaultCredentials();
                SwitchCredentialsAndEndpointTest.restoreDefaultEndpoint();
            }
        }
        finally {
            SwitchCredentialsAndEndpointTest.restoreDefaultCredentials();
            SwitchCredentialsAndEndpointTest.restoreDefaultEndpoint();
        }
    }

    @Test
    public void testSwitchInvalidCredentialsAndEndpoint() {
        CredentialsProvider credsProvider = defaultClient.getCredentialsProvider();
        Credentials defaultCreds = credsProvider.getCredentials();
        Assert.assertEquals((Object)"k6v3sL0ZTaIaVvMs", (Object)defaultCreds.getAccessKeyId());
        Assert.assertEquals((Object)"aIEyqeEnFhBi9LqsODzFaHP9lPodTQ", (Object)defaultCreds.getSecretAccessKey());
        DefaultCredentials invalidCreds = new DefaultCredentials("InvalidAccessId", "InvalidAccessKey");
        defaultClient.switchCredentials(invalidCreds);
        try {
            defaultClient.getBucketLocation(bucketName);
            Assert.fail((String)"Should not be able to get bucket location with invalid credentials.");
        }
        catch (OSSException ex) {
            Assert.assertEquals((Object)"InvalidAccessKeyId", (Object)ex.getErrorCode());
        }
        defaultClient.setEndpoint("http://InvalidEndpoint");
        try {
            try {
                defaultClient.getBucketLocation(bucketName);
                Assert.fail((String)"Should not be able to get bucket location with second credentials.");
            }
            catch (ClientException ex) {
                Assert.assertEquals((Object)"UnknownHost", (Object)ex.getErrorCode());
                SwitchCredentialsAndEndpointTest.restoreDefaultCredentials();
                SwitchCredentialsAndEndpointTest.restoreDefaultEndpoint();
            }
        }
        finally {
            SwitchCredentialsAndEndpointTest.restoreDefaultCredentials();
            SwitchCredentialsAndEndpointTest.restoreDefaultEndpoint();
        }
    }

    @Test
    public void testSwitchCredentialsSynchronously() throws Exception {
        final Object ensureSwitchFirst = new Object();
        final Object verifySynchronizer = new Object();
        final Object switchSynchronizer = new Object();
        Thread verifyThread = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Object object = ensureSwitchFirst;
                synchronized (object) {
                    if (!SwitchCredentialsAndEndpointTest.this.switchStarted) {
                        try {
                            ensureSwitchFirst.wait();
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                }
                int l = 0;
                do {
                    Object object2 = verifySynchronizer;
                    synchronized (object2) {
                        try {
                            verifySynchronizer.wait();
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                    CredentialsProvider credsProvider = defaultClient.getCredentialsProvider();
                    Credentials currentCreds = credsProvider.getCredentials();
                    try {
                        String loc = defaultClient.getBucketLocation(bucketName);
                        Assert.assertEquals((Object)"oss-cn-hangzhou", (Object)loc);
                        Assert.assertEquals((Object)"k6v3sL0ZTaIaVvMs", (Object)currentCreds.getAccessKeyId());
                        Assert.assertEquals((Object)"aIEyqeEnFhBi9LqsODzFaHP9lPodTQ", (Object)currentCreds.getSecretAccessKey());
                    }
                    catch (OSSException ex) {
                        Assert.assertEquals((Object)"InvalidAccessKeyId", (Object)ex.getErrorCode());
                        Assert.assertEquals((Object)"nz2pc56s936cv9l", (Object)currentCreds.getAccessKeyId());
                        Assert.assertEquals((Object)"dGkyeDRoa3NwdmJnajN2ZnVmMjA", (Object)currentCreds.getSecretAccessKey());
                    }
                    Object object3 = switchSynchronizer;
                    synchronized (object3) {
                        switchSynchronizer.notify();
                    }
                } while (++l < 100);
            }
        });
        Thread switchThread = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                int l = 0;
                boolean firstSwitch = false;
                do {
                    Object object;
                    Credentials secondCreds = new DefaultCredentials("nz2pc56s936cv9l", "dGkyeDRoa3NwdmJnajN2ZnVmMjA");
                    defaultClient.switchCredentials(secondCreds);
                    CredentialsProvider credsProvider = defaultClient.getCredentialsProvider();
                    secondCreds = credsProvider.getCredentials();
                    Assert.assertEquals((Object)"nz2pc56s936cv9l", (Object)secondCreds.getAccessKeyId());
                    Assert.assertEquals((Object)"dGkyeDRoa3NwdmJnajN2ZnVmMjA", (Object)secondCreds.getSecretAccessKey());
                    if (!firstSwitch) {
                        object = ensureSwitchFirst;
                        synchronized (object) {
                            SwitchCredentialsAndEndpointTest.this.switchStarted = true;
                            ensureSwitchFirst.notify();
                        }
                        firstSwitch = true;
                    }
                    try {
                        Thread.sleep(50L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    object = verifySynchronizer;
                    synchronized (object) {
                        verifySynchronizer.notify();
                    }
                    object = switchSynchronizer;
                    synchronized (object) {
                        try {
                            switchSynchronizer.wait();
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                } while (++l < 100);
            }
        });
        verifyThread.start();
        switchThread.start();
        verifyThread.join();
        switchThread.join();
        SwitchCredentialsAndEndpointTest.restoreDefaultCredentials();
    }

    @Test
    public void testSwitchEndpointSynchronously() throws Exception {
        final Object ensureSwitchFirst = new Object();
        final Object verifySynchronizer = new Object();
        final Object switchSynchronizer = new Object();
        Thread verifyThread = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Object object = ensureSwitchFirst;
                synchronized (object) {
                    if (!SwitchCredentialsAndEndpointTest.this.switchStarted) {
                        try {
                            ensureSwitchFirst.wait();
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                }
                int l = 0;
                do {
                    Object object2 = verifySynchronizer;
                    synchronized (object2) {
                        try {
                            verifySynchronizer.wait();
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                    CredentialsProvider credsProvider = defaultClient.getCredentialsProvider();
                    Credentials currentCreds = credsProvider.getCredentials();
                    String loc = defaultClient.getBucketLocation(bucketName);
                    Assert.assertEquals((Object)"oss-cn-hangzhou", (Object)loc);
                    Assert.assertEquals((Object)"nz2pc56s936cv9l", (Object)currentCreds.getAccessKeyId());
                    Assert.assertEquals((Object)"dGkyeDRoa3NwdmJnajN2ZnVmMjA", (Object)currentCreds.getSecretAccessKey());
                    String secondLoc = secondClient.getBucketLocation(bucketName);
                    Assert.assertEquals((Object)loc, (Object)secondLoc);
                    Assert.assertEquals((Object)"oss-cn-hangzhou", (Object)secondLoc);
                    CredentialsProvider secondCredsProvider = secondClient.getCredentialsProvider();
                    Credentials secondCreds = secondCredsProvider.getCredentials();
                    Assert.assertEquals((Object)"nz2pc56s936cv9l", (Object)secondCreds.getAccessKeyId());
                    Assert.assertEquals((Object)"dGkyeDRoa3NwdmJnajN2ZnVmMjA", (Object)secondCreds.getSecretAccessKey());
                    Object object3 = switchSynchronizer;
                    synchronized (object3) {
                        SwitchCredentialsAndEndpointTest.restoreDefaultCredentials();
                        SwitchCredentialsAndEndpointTest.restoreDefaultEndpoint();
                        switchSynchronizer.notify();
                    }
                } while (++l < 100);
            }
        });
        Thread switchThread = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                int l = 0;
                boolean firstSwitch = false;
                do {
                    Object object;
                    DefaultCredentials secondCreds = new DefaultCredentials("nz2pc56s936cv9l", "dGkyeDRoa3NwdmJnajN2ZnVmMjA");
                    defaultClient.switchCredentials(secondCreds);
                    defaultClient.setEndpoint("http://oss-test.aliyun-inc.com");
                    if (!firstSwitch) {
                        object = ensureSwitchFirst;
                        synchronized (object) {
                            SwitchCredentialsAndEndpointTest.this.switchStarted = true;
                            ensureSwitchFirst.notify();
                        }
                        firstSwitch = true;
                    }
                    try {
                        Thread.sleep(50L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    object = verifySynchronizer;
                    synchronized (object) {
                        verifySynchronizer.notify();
                    }
                    object = switchSynchronizer;
                    synchronized (object) {
                        try {
                            switchSynchronizer.wait();
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                } while (++l < 100);
            }
        });
        verifyThread.start();
        switchThread.start();
        verifyThread.join();
        switchThread.join();
        SwitchCredentialsAndEndpointTest.restoreDefaultCredentials();
        SwitchCredentialsAndEndpointTest.restoreDefaultEndpoint();
    }
}

