/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.oss.integrationtests;

import com.aliyun.oss.event.ProgressEvent;
import com.aliyun.oss.event.ProgressEventType;
import com.aliyun.oss.event.ProgressListener;
import com.aliyun.oss.integrationtests.TestBase;
import com.aliyun.oss.integrationtests.TestUtils;
import com.aliyun.oss.model.CompleteMultipartUploadRequest;
import com.aliyun.oss.model.GetObjectRequest;
import com.aliyun.oss.model.ObjectMetadata;
import com.aliyun.oss.model.PartETag;
import com.aliyun.oss.model.PutObjectRequest;
import com.aliyun.oss.model.UploadPartRequest;
import com.aliyun.oss.model.UploadPartResult;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import junit.framework.Assert;
import org.junit.Ignore;
import org.junit.Test;

public class ProgressBarTest
extends TestBase {
    @Test
    public void testSimpleObjectProgressBar() throws Exception {
        String key = "put-object-progress-bar";
        int instreamLength = 65536;
        String filePath = TestUtils.buildFilePath();
        try {
            File fileToUpload = new File(TestUtils.genFixedLengthFile(65536L));
            secondClient.putObject((PutObjectRequest)new PutObjectRequest(bucketName, "put-object-progress-bar", fileToUpload).withProgressListener(new PutObjectProgressListener()));
            ObjectMetadata metadata = secondClient.getObject((GetObjectRequest)new GetObjectRequest(bucketName, "put-object-progress-bar").withProgressListener(new GetObjectProgressListener()), new File(filePath));
            Assert.assertEquals((long)65536L, (long)metadata.getContentLength());
        }
        catch (Exception ex) {
            Assert.fail((String)ex.getMessage());
        }
    }

    @Ignore
    public void testMultipartsProgressBar() throws Exception {
        String key = "multiparts-progress-bar";
        int instreamLength = 0x4000000;
        ExecutorService executorService = Executors.newFixedThreadPool(5);
        List<PartETag> partETags = Collections.synchronizedList(new ArrayList());
        String uploadId = TestUtils.claimUploadId(secondClient, bucketName, "multiparts-progress-bar");
        long partSize = 0x500000L;
        File tempFile = new File(TestUtils.genFixedLengthFile(0x4000000L));
        long fileLength = tempFile.length();
        int partCount = (int)(fileLength / 0x500000L);
        if (fileLength % 0x500000L != 0L) {
            ++partCount;
        }
        int i = 0;
        while (i < partCount) {
            long startPos = (long)i * 0x500000L;
            long curPartSize = i + 1 == partCount ? fileLength - startPos : 0x500000L;
            executorService.execute(new PartUploader("multiparts-progress-bar", tempFile, startPos, curPartSize, i + 1, uploadId, partETags, new UploadPartProgressListener(i + 1)));
            ++i;
        }
        executorService.shutdown();
        while (!executorService.isTerminated()) {
            try {
                executorService.awaitTermination(5L, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        Assert.assertEquals((int)partCount, (int)partETags.size());
        Collections.sort(partETags, new Comparator<PartETag>(){

            @Override
            public int compare(PartETag p1, PartETag p2) {
                return p1.getPartNumber() - p2.getPartNumber();
            }
        });
        try {
            CompleteMultipartUploadRequest completeMultipartUploadRequest = new CompleteMultipartUploadRequest(bucketName, "multiparts-progress-bar", uploadId, partETags);
            secondClient.completeMultipartUpload(completeMultipartUploadRequest);
        }
        catch (Exception e) {
            Assert.fail((String)e.getMessage());
        }
    }

    static class GetObjectProgressListener
    implements ProgressListener {
        private long bytesRead = 0L;
        private long totalBytes = -1L;
        private boolean succeed = false;

        GetObjectProgressListener() {
        }

        @Override
        public void progressChanged(ProgressEvent progressEvent) {
            long bytes = progressEvent.getBytes();
            ProgressEventType eventType = progressEvent.getEventType();
            switch (eventType) {
                case TRANSFER_STARTED_EVENT: {
                    System.out.println("Start to download......");
                    break;
                }
                case RESPONSE_CONTENT_LENGTH_EVENT: {
                    this.totalBytes = bytes;
                    System.out.println(String.valueOf(this.totalBytes) + " bytes in total will be downloaded to a local file");
                    break;
                }
                case RESPONSE_BYTE_TRANSFER_EVENT: {
                    this.bytesRead += bytes;
                    if (this.totalBytes != -1L) {
                        int percent = (int)((double)this.bytesRead * 100.0 / (double)this.totalBytes);
                        System.out.println(String.valueOf(bytes) + " bytes have been read at this time, download progress: " + percent + "%(" + this.bytesRead + "/" + this.totalBytes + ")");
                        break;
                    }
                    System.out.println(String.valueOf(bytes) + " bytes have been read at this time, download ratio: unknown" + "(" + this.bytesRead + "/...)");
                    break;
                }
                case TRANSFER_COMPLETED_EVENT: {
                    this.succeed = true;
                    System.out.println("Succeed to download, " + this.bytesRead + " bytes have been transferred in total");
                    break;
                }
                case TRANSFER_FAILED_EVENT: {
                    System.out.println("Failed to download, " + this.bytesRead + " bytes have been transferred");
                    break;
                }
            }
        }

        public boolean isSucceed() {
            return this.succeed;
        }
    }

    private static class PartUploader
    implements Runnable {
        private String key;
        private File localFile;
        private long startPos;
        private long partSize;
        private int partNumber;
        private String uploadId;
        private List<PartETag> partETags;
        private ProgressListener listener;

        public PartUploader(String key, File localFile, long startPos, long partSize, int partNumber, String uploadId, List<PartETag> partETags, ProgressListener listener) {
            this.key = key;
            this.localFile = localFile;
            this.startPos = startPos;
            this.partSize = partSize;
            this.partNumber = partNumber;
            this.uploadId = uploadId;
            this.partETags = partETags;
            this.listener = listener;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            block15: {
                FileInputStream instream = null;
                try {
                    try {
                        instream = new FileInputStream(this.localFile);
                        ((InputStream)instream).skip(this.startPos);
                        UploadPartRequest uploadPartRequest = new UploadPartRequest();
                        uploadPartRequest.setBucketName(bucketName);
                        uploadPartRequest.setKey(this.key);
                        uploadPartRequest.setUploadId(this.uploadId);
                        uploadPartRequest.setInputStream(instream);
                        uploadPartRequest.setPartSize(this.partSize);
                        uploadPartRequest.setPartNumber(this.partNumber);
                        uploadPartRequest.setProgressListener(this.listener);
                        UploadPartResult uploadPartResult = secondClient.uploadPart(uploadPartRequest);
                        List<PartETag> list = this.partETags;
                        synchronized (list) {
                            this.partETags.add(uploadPartResult.getPartETag());
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        if (instream == null) break block15;
                        try {
                            ((InputStream)instream).close();
                        }
                        catch (IOException e2) {
                            e2.printStackTrace();
                        }
                    }
                }
                finally {
                    if (instream != null) {
                        try {
                            ((InputStream)instream).close();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                }
            }
        }
    }

    static class PutObjectProgressListener
    implements ProgressListener {
        private long bytesWritten = 0L;
        private long totalBytes = -1L;
        private boolean succeed = false;

        PutObjectProgressListener() {
        }

        @Override
        public void progressChanged(ProgressEvent progressEvent) {
            long bytes = progressEvent.getBytes();
            ProgressEventType eventType = progressEvent.getEventType();
            switch (eventType) {
                case TRANSFER_STARTED_EVENT: {
                    System.out.println("Start to upload......");
                    break;
                }
                case REQUEST_CONTENT_LENGTH_EVENT: {
                    this.totalBytes = bytes;
                    System.out.println(String.valueOf(this.totalBytes) + " bytes in total will be uploaded to OSS");
                    break;
                }
                case REQUEST_BYTE_TRANSFER_EVENT: {
                    this.bytesWritten += bytes;
                    if (this.totalBytes != -1L) {
                        int percent = (int)((double)this.bytesWritten * 100.0 / (double)this.totalBytes);
                        System.out.println(String.valueOf(bytes) + " bytes have been written at this time, upload progress: " + percent + "%(" + this.bytesWritten + "/" + this.totalBytes + ")");
                        break;
                    }
                    System.out.println(String.valueOf(bytes) + " bytes have been written at this time, upload ratio: unknown" + "(" + this.bytesWritten + "/...)");
                    break;
                }
                case TRANSFER_COMPLETED_EVENT: {
                    this.succeed = true;
                    System.out.println("Succeed to upload, " + this.bytesWritten + " bytes have been transferred in total");
                    break;
                }
                case TRANSFER_FAILED_EVENT: {
                    System.out.println("Failed to upload, " + this.bytesWritten + " bytes have been transferred");
                    break;
                }
            }
        }

        public boolean isSucceed() {
            return this.succeed;
        }
    }

    static class UploadPartProgressListener
    implements ProgressListener {
        private int partNumber;
        private long bytesWritten = 0L;
        private long totalBytes = -1L;
        private boolean succeed = false;

        public UploadPartProgressListener(int partNumber) {
            this.partNumber = partNumber;
        }

        @Override
        public void progressChanged(ProgressEvent progressEvent) {
            long bytes = progressEvent.getBytes();
            ProgressEventType eventType = progressEvent.getEventType();
            switch (eventType) {
                case TRANSFER_PART_STARTED_EVENT: {
                    System.out.println("Start to upload part #" + this.partNumber + " ......");
                    break;
                }
                case REQUEST_CONTENT_LENGTH_EVENT: {
                    this.totalBytes = bytes;
                    System.out.println("part #" + this.partNumber + " with " + this.totalBytes + " bytes will be uploaded to OSS");
                    break;
                }
                case REQUEST_BYTE_TRANSFER_EVENT: {
                    this.bytesWritten += bytes;
                    if (this.totalBytes != -1L) {
                        int percent = (int)((double)this.bytesWritten * 100.0 / (double)this.totalBytes);
                        System.out.println(String.valueOf(bytes) + " bytes have been written at this time, part #" + this.partNumber + "upload progress: " + percent + "%(" + this.bytesWritten + "/" + this.totalBytes + ")");
                        break;
                    }
                    System.out.println(String.valueOf(bytes) + " bytes have been written at this time, part #" + this.partNumber + "upload ratio: unknown(" + this.bytesWritten + "/...)");
                    break;
                }
                case TRANSFER_PART_COMPLETED_EVENT: {
                    this.succeed = true;
                    System.out.println("Succeed to upload part #" + this.partNumber + ", " + this.bytesWritten + " bytes have been transferred in total");
                    break;
                }
                case TRANSFER_PART_FAILED_EVENT: {
                    System.out.println("Failed to upload part #" + this.partNumber + ", " + this.bytesWritten + " bytes have been transferred");
                    break;
                }
            }
        }

        public boolean isSucceed() {
            return this.succeed;
        }
    }
}

