/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.oss.integrationtests;

import com.aliyun.oss.OSSException;
import com.aliyun.oss.integrationtests.TestBase;
import com.aliyun.oss.integrationtests.TestUtils;
import com.aliyun.oss.model.CopyObjectRequest;
import com.aliyun.oss.model.CopyObjectResult;
import com.aliyun.oss.model.CreateBucketRequest;
import com.aliyun.oss.model.OSSObject;
import com.aliyun.oss.model.ObjectMetadata;
import com.aliyun.oss.model.PutObjectResult;
import java.io.ByteArrayInputStream;
import java.util.ArrayList;
import java.util.Date;
import junit.framework.Assert;
import org.junit.Ignore;
import org.junit.Test;

public class CopyObjectTest
extends TestBase {
    @Test
    public void testCopyExistingObject() {
        String sourceBucket = "copy-existing-object-source-bucket";
        String targetBucket = "copy-existing-object-target-bucket";
        String sourceKey = "copy-existing-object-source-object";
        String targetKey = "copy-existing-object-target-object";
        String userMetaKey0 = "user";
        String userMetaValue0 = "aliy";
        String userMetaKey1 = "tag";
        String userMetaValue1 = "copy-object";
        String contentType = "application/txt";
        try {
            try {
                secondClient.createBucket("copy-existing-object-source-bucket");
                secondClient.createBucket("copy-existing-object-target-bucket");
                byte[] content = new byte[]{65, 108, 105, 121, 117, 110};
                ObjectMetadata metadata = new ObjectMetadata();
                metadata.setContentLength(content.length);
                metadata.setContentType("application/octet-stream");
                metadata.addUserMetadata("user", "aliy");
                PutObjectResult putObjectResult = secondClient.putObject("copy-existing-object-source-bucket", "copy-existing-object-source-object", new ByteArrayInputStream(content), metadata);
                CopyObjectResult copyObjectResult = secondClient.copyObject("copy-existing-object-source-bucket", "copy-existing-object-source-object", "copy-existing-object-target-bucket", "copy-existing-object-target-object");
                String sourceETag = putObjectResult.getETag();
                String targetETag = copyObjectResult.getETag();
                Assert.assertEquals((String)sourceETag, (String)targetETag);
                OSSObject ossObject = secondClient.getObject("copy-existing-object-target-bucket", "copy-existing-object-target-object");
                ObjectMetadata newObjectMetadata = ossObject.getObjectMetadata();
                Assert.assertEquals((String)"application/octet-stream", (String)newObjectMetadata.getContentType());
                Assert.assertEquals((String)"aliy", (String)newObjectMetadata.getUserMetadata().get("user"));
                String sourceBucketAsTarget = "copy-existing-object-source-bucket";
                String sourceKeyAsTarget = "copy-existing-object-source-object";
                newObjectMetadata = new ObjectMetadata();
                newObjectMetadata.setContentLength(content.length);
                newObjectMetadata.setContentType("application/txt");
                newObjectMetadata.addUserMetadata("tag", "copy-object");
                CopyObjectRequest copyObjectRequest = new CopyObjectRequest("copy-existing-object-source-bucket", "copy-existing-object-source-object", "copy-existing-object-source-bucket", "copy-existing-object-source-object");
                copyObjectRequest.setNewObjectMetadata(newObjectMetadata);
                copyObjectResult = secondClient.copyObject(copyObjectRequest);
                Assert.assertEquals((String)sourceETag, (String)copyObjectResult.getETag());
                ossObject = secondClient.getObject("copy-existing-object-source-bucket", "copy-existing-object-source-object");
                newObjectMetadata = ossObject.getObjectMetadata();
                Assert.assertEquals((String)"application/txt", (String)newObjectMetadata.getContentType());
                Assert.assertEquals((String)"copy-object", (String)newObjectMetadata.getUserMetadata().get("tag"));
            }
            catch (Exception e) {
                Assert.fail((String)e.getMessage());
                TestUtils.waitForCacheExpiration(5);
                CopyObjectTest.deleteBucketWithObjects(secondClient, "copy-existing-object-source-bucket");
                CopyObjectTest.deleteBucketWithObjects(secondClient, "copy-existing-object-target-bucket");
            }
        }
        finally {
            TestUtils.waitForCacheExpiration(5);
            CopyObjectTest.deleteBucketWithObjects(secondClient, "copy-existing-object-source-bucket");
            CopyObjectTest.deleteBucketWithObjects(secondClient, "copy-existing-object-target-bucket");
        }
    }

    @Ignore
    public void testCopyNonexistentObject() {
        String existingSourceBucket = "copy-nonexistent-object-existing-source-bucket";
        String existingSourceKey = "copy-nonexistent-object-existing-source-object";
        String nonexistentSourceBucket = "copy-nonexistent-object-nonexistent-source-bucket";
        String nonexistentSourceKey = "copy-nonexistent-object-nonexistent-source-object";
        String existingTargetBucket = "copy-nonexistent-object-existing-target-bucket";
        String nonexistentTargetBucket = "copy-nonexistent-object-nonexistent-target-bucket";
        String targetKey = "copy-nonexistent-object-target";
        try {
            try {
                secondClient.createBucket("copy-nonexistent-object-existing-source-bucket");
                secondClient.createBucket("copy-nonexistent-object-existing-target-bucket");
                try {
                    secondClient.copyObject("copy-nonexistent-object-nonexistent-source-bucket", "copy-nonexistent-object-nonexistent-source-object", "copy-nonexistent-object-existing-target-bucket", "copy-nonexistent-object-target");
                    Assert.fail((String)"Copy object should not be successful");
                }
                catch (OSSException e) {
                    Assert.assertEquals((String)"NoSuchBucket", (String)e.getErrorCode());
                    Assert.assertTrue((boolean)e.getMessage().startsWith("The specified bucket does not exist."));
                }
                try {
                    secondClient.copyObject("copy-nonexistent-object-existing-source-bucket", "copy-nonexistent-object-nonexistent-source-object", "copy-nonexistent-object-existing-target-bucket", "copy-nonexistent-object-target");
                    Assert.fail((String)"Copy object should not be successful");
                }
                catch (OSSException e) {
                    Assert.assertEquals((String)"NoSuchKey", (String)e.getErrorCode());
                    Assert.assertTrue((boolean)e.getMessage().startsWith("The specified key does not exist."));
                }
                try {
                    byte[] content = new byte[]{65, 108, 105, 121, 117, 110};
                    secondClient.putObject("copy-nonexistent-object-existing-source-bucket", "copy-nonexistent-object-existing-source-object", new ByteArrayInputStream(content), null);
                }
                catch (Exception e) {
                    Assert.fail((String)e.getMessage());
                }
                try {
                    secondClient.copyObject("copy-nonexistent-object-existing-source-bucket", "copy-nonexistent-object-existing-source-object", "copy-nonexistent-object-nonexistent-target-bucket", "copy-nonexistent-object-target");
                    Assert.fail((String)"Copy object should not be successful");
                }
                catch (OSSException e) {
                    Assert.assertEquals((String)"NoSuchBucket", (String)e.getErrorCode());
                    Assert.assertTrue((boolean)e.getMessage().startsWith("The specified bucket does not exist."));
                }
            }
            catch (Exception e) {
                Assert.fail((String)e.getMessage());
                CopyObjectTest.deleteBucketWithObjects(secondClient, "copy-nonexistent-object-existing-source-bucket");
                CopyObjectTest.deleteBucketWithObjects(secondClient, "copy-nonexistent-object-existing-target-bucket");
            }
        }
        finally {
            CopyObjectTest.deleteBucketWithObjects(secondClient, "copy-nonexistent-object-existing-source-bucket");
            CopyObjectTest.deleteBucketWithObjects(secondClient, "copy-nonexistent-object-existing-target-bucket");
        }
    }

    @Ignore
    public void testCopyObjectWithDiffLocation() {
        String sourceBucket = "copy-object-with-diff-location-source-bucket";
        String targetBucket = "copy-object-with-diff-location-target-bucket";
        String sourceKey = "copy-object-with-diff-location-source-key";
        String targetKey = "copy-object-with-diff-location-target-key";
        try {
            try {
                CreateBucketRequest createSourceBucketRequest = new CreateBucketRequest("copy-object-with-diff-location-source-bucket");
                createSourceBucketRequest.setLocationConstraint("oss-cn-hangzhou");
                defaultClient.createBucket(createSourceBucketRequest);
                defaultClient.setEndpoint("http://oss-cn-beijing.aliyuncs.com");
                CreateBucketRequest createTargetBucketRequest = new CreateBucketRequest("copy-object-with-diff-location-target-bucket");
                createTargetBucketRequest.setLocationConstraint("oss-cn-beijing");
                defaultClient.createBucket(createTargetBucketRequest);
                CopyObjectTest.restoreDefaultEndpoint();
                try {
                    byte[] content = new byte[]{65, 108, 105, 121, 117, 110};
                    defaultClient.putObject("copy-object-with-diff-location-source-bucket", "copy-object-with-diff-location-source-key", new ByteArrayInputStream(content), null);
                }
                catch (Exception e) {
                    Assert.fail((String)e.getMessage());
                }
                try {
                    try {
                        defaultClient.setEndpoint("http://oss-cn-beijing.aliyuncs.com");
                        defaultClient.copyObject("copy-object-with-diff-location-source-bucket", "copy-object-with-diff-location-source-key", "copy-object-with-diff-location-target-bucket", "copy-object-with-diff-location-target-key");
                        Assert.fail((String)"Copy object should not be successful");
                    }
                    catch (OSSException e) {
                        Assert.assertEquals((String)"AccessDenied", (String)e.getErrorCode());
                        Assert.assertTrue((boolean)e.getMessage().startsWith("Target object does not reside in the same data center as source object."));
                        CopyObjectTest.restoreDefaultEndpoint();
                    }
                }
                finally {
                    CopyObjectTest.restoreDefaultEndpoint();
                }
            }
            catch (Exception e) {
                Assert.fail((String)e.getMessage());
                CopyObjectTest.deleteBucketWithObjects(defaultClient, "copy-object-with-diff-location-source-bucket");
                defaultClient.setEndpoint("http://oss-cn-beijing.aliyuncs.com");
                CopyObjectTest.deleteBucketWithObjects(defaultClient, "copy-object-with-diff-location-target-bucket");
                CopyObjectTest.restoreDefaultEndpoint();
            }
        }
        finally {
            CopyObjectTest.deleteBucketWithObjects(defaultClient, "copy-object-with-diff-location-source-bucket");
            defaultClient.setEndpoint("http://oss-cn-beijing.aliyuncs.com");
            CopyObjectTest.deleteBucketWithObjects(defaultClient, "copy-object-with-diff-location-target-bucket");
            CopyObjectTest.restoreDefaultEndpoint();
        }
    }

    @Ignore
    public void testCopyObjectWithSpecialChars() {
        String sourceBucket = "copy-existing-object-source-bucket";
        String targetBucket = "copy-existing-object-target-bucket";
        String sourceKey = "\u6d4b\\r\u8bd5-\u4e2d.~,+\"'*&\uffe5#@%\uff01\uff08\u6587\uff09+\u5b57\u7b26|\uff1f/.zip";
        String targetKey = "\u6d4b\\r\u8bd5-\u4e2d.~,+\"'*&\uffe5#@%\uff01\uff08\u6587\uff09+\u5b57\u7b26|\uff1f/-2.zip";
        String userMetaKey0 = "user";
        String userMetaValue0 = "\u963f\u91cc\u4eba";
        String userMetaKey1 = "tag";
        String userMetaValue1 = "\u6807\u7b7e1";
        String contentType = "application/txt";
        try {
            try {
                secondClient.createBucket("copy-existing-object-source-bucket");
                secondClient.createBucket("copy-existing-object-target-bucket");
                byte[] content = new byte[]{65, 108, 105, 121, 117, 110};
                ObjectMetadata metadata = new ObjectMetadata();
                metadata.setContentLength(content.length);
                metadata.setContentType("application/octet-stream");
                metadata.addUserMetadata("user", "\u963f\u91cc\u4eba");
                PutObjectResult putObjectResult = secondClient.putObject("copy-existing-object-source-bucket", "\u6d4b\\r\u8bd5-\u4e2d.~,+\"'*&\uffe5#@%\uff01\uff08\u6587\uff09+\u5b57\u7b26|\uff1f/.zip", new ByteArrayInputStream(content), metadata);
                CopyObjectResult copyObjectResult = secondClient.copyObject("copy-existing-object-source-bucket", "\u6d4b\\r\u8bd5-\u4e2d.~,+\"'*&\uffe5#@%\uff01\uff08\u6587\uff09+\u5b57\u7b26|\uff1f/.zip", "copy-existing-object-target-bucket", "\u6d4b\\r\u8bd5-\u4e2d.~,+\"'*&\uffe5#@%\uff01\uff08\u6587\uff09+\u5b57\u7b26|\uff1f/-2.zip");
                String sourceETag = putObjectResult.getETag();
                String targetETag = copyObjectResult.getETag();
                Assert.assertEquals((String)sourceETag, (String)targetETag);
                OSSObject ossObject = secondClient.getObject("copy-existing-object-target-bucket", "\u6d4b\\r\u8bd5-\u4e2d.~,+\"'*&\uffe5#@%\uff01\uff08\u6587\uff09+\u5b57\u7b26|\uff1f/-2.zip");
                ObjectMetadata newObjectMetadata = ossObject.getObjectMetadata();
                Assert.assertEquals((String)"application/octet-stream", (String)newObjectMetadata.getContentType());
                Assert.assertEquals((String)"\u963f\u91cc\u4eba", (String)newObjectMetadata.getUserMetadata().get("user"));
                String sourceBucketAsTarget = "copy-existing-object-source-bucket";
                String sourceKeyAsTarget = "\u6d4b\\r\u8bd5-\u4e2d.~,+\"'*&\uffe5#@%\uff01\uff08\u6587\uff09+\u5b57\u7b26|\uff1f/.zip";
                newObjectMetadata = new ObjectMetadata();
                newObjectMetadata.setContentLength(content.length);
                newObjectMetadata.setContentType("application/txt");
                newObjectMetadata.addUserMetadata("tag", "\u6807\u7b7e1");
                CopyObjectRequest copyObjectRequest = new CopyObjectRequest("copy-existing-object-source-bucket", "\u6d4b\\r\u8bd5-\u4e2d.~,+\"'*&\uffe5#@%\uff01\uff08\u6587\uff09+\u5b57\u7b26|\uff1f/.zip", "copy-existing-object-source-bucket", "\u6d4b\\r\u8bd5-\u4e2d.~,+\"'*&\uffe5#@%\uff01\uff08\u6587\uff09+\u5b57\u7b26|\uff1f/.zip");
                copyObjectRequest.setNewObjectMetadata(newObjectMetadata);
                copyObjectResult = secondClient.copyObject(copyObjectRequest);
                Assert.assertEquals((String)sourceETag, (String)copyObjectResult.getETag());
                ossObject = secondClient.getObject("copy-existing-object-source-bucket", "\u6d4b\\r\u8bd5-\u4e2d.~,+\"'*&\uffe5#@%\uff01\uff08\u6587\uff09+\u5b57\u7b26|\uff1f/.zip");
                newObjectMetadata = ossObject.getObjectMetadata();
                Assert.assertEquals((String)"application/txt", (String)newObjectMetadata.getContentType());
                Assert.assertEquals((String)"\u6807\u7b7e1", (String)newObjectMetadata.getUserMetadata().get("tag"));
            }
            catch (Exception e) {
                Assert.fail((String)e.getMessage());
                CopyObjectTest.deleteBucketWithObjects(secondClient, "copy-existing-object-source-bucket");
                CopyObjectTest.deleteBucketWithObjects(secondClient, "copy-existing-object-target-bucket");
            }
        }
        finally {
            CopyObjectTest.deleteBucketWithObjects(secondClient, "copy-existing-object-source-bucket");
            CopyObjectTest.deleteBucketWithObjects(secondClient, "copy-existing-object-target-bucket");
        }
    }

    @Ignore
    public void testCopyObjectWithInvalidEncryptionAlgo() {
        String sourceBucket = "copy-object-with-invalid-encryption-algo-source-bucket";
        String targetBucket = "copy-object-with-invalid-encryption-algo-target-bucket";
        String sourceKey = "copy-object-with-invalid-encryption-algo-source-key";
        String targetKey = "copy-object-with-invalid-encryption-algo-target-key";
        try {
            try {
                secondClient.createBucket("copy-object-with-invalid-encryption-algo-source-bucket");
                secondClient.createBucket("copy-object-with-invalid-encryption-algo-target-bucket");
                String invalidEncryptionAlgo = "Invalid-Encryption-Algo";
                try {
                    CopyObjectRequest request = new CopyObjectRequest("copy-object-with-invalid-encryption-algo-source-bucket", "copy-object-with-invalid-encryption-algo-source-key", "copy-object-with-invalid-encryption-algo-target-bucket", "copy-object-with-invalid-encryption-algo-target-key");
                    request.setServerSideEncryption("Invalid-Encryption-Algo");
                    secondClient.copyObject(request);
                    Assert.fail((String)"Copy object should not be successful");
                }
                catch (OSSException e) {
                    Assert.assertEquals((String)"InvalidEncryptionAlgorithmError", (String)e.getErrorCode());
                    Assert.assertTrue((boolean)e.getMessage().startsWith("The Encryption request you specified is not valid. Supported value: AES25"));
                }
            }
            catch (Exception e) {
                Assert.fail((String)e.getMessage());
                CopyObjectTest.deleteBucketWithObjects(secondClient, "copy-object-with-invalid-encryption-algo-source-bucket");
                CopyObjectTest.deleteBucketWithObjects(secondClient, "copy-object-with-invalid-encryption-algo-target-bucket");
            }
        }
        finally {
            CopyObjectTest.deleteBucketWithObjects(secondClient, "copy-object-with-invalid-encryption-algo-source-bucket");
            CopyObjectTest.deleteBucketWithObjects(secondClient, "copy-object-with-invalid-encryption-algo-target-bucket");
        }
    }

    @Ignore
    public void testCopyObjectWithMiscConstraints() throws Exception {
        String sourceBucket = "copy-object-with-misc-constraints-source-bucket";
        String targetBucket = "copy-object-with-misc-constraints-target-bucket";
        String sourceKey = "copy-object-with-misc-constraints-source-key";
        String targetKey = "copy-object-with-misc-constraints-target-key";
        try {
            try {
                Date modifiedSinceConstraint;
                CopyObjectResult result;
                CopyObjectRequest request;
                block53: {
                    String eTag;
                    Date beforeModifiedTime;
                    block51: {
                        Date unmodifiedSinceConstraint;
                        block49: {
                            block47: {
                                ArrayList<String> nonmatchingETagConstraints;
                                block45: {
                                    block43: {
                                        ArrayList<String> matchingETagConstraints;
                                        block41: {
                                            secondClient.createBucket("copy-object-with-misc-constraints-source-bucket");
                                            secondClient.createBucket("copy-object-with-misc-constraints-target-bucket");
                                            beforeModifiedTime = new Date();
                                            Thread.sleep(1000L);
                                            eTag = null;
                                            try {
                                                PutObjectResult result2 = secondClient.putObject("copy-object-with-misc-constraints-source-bucket", "copy-object-with-misc-constraints-source-key", TestUtils.genFixedLengthInputStream(1024L), null);
                                                eTag = result2.getETag();
                                            }
                                            catch (Exception e) {
                                                Assert.fail((String)e.getMessage());
                                            }
                                            matchingETagConstraints = new ArrayList<String>();
                                            matchingETagConstraints.add(eTag);
                                            request = new CopyObjectRequest("copy-object-with-misc-constraints-source-bucket", "copy-object-with-misc-constraints-source-key", "copy-object-with-misc-constraints-target-bucket", "copy-object-with-misc-constraints-target-key");
                                            request.setMatchingETagConstraints(matchingETagConstraints);
                                            result = null;
                                            try {
                                                try {
                                                    result = secondClient.copyObject(request);
                                                    Assert.assertEquals((String)eTag, (String)result.getETag());
                                                }
                                                catch (Exception e) {
                                                    Assert.fail((String)e.getMessage());
                                                    request.clearMatchingETagConstraints();
                                                    break block41;
                                                }
                                            }
                                            catch (Throwable throwable) {
                                                request.clearMatchingETagConstraints();
                                                throw throwable;
                                            }
                                            request.clearMatchingETagConstraints();
                                        }
                                        matchingETagConstraints.clear();
                                        matchingETagConstraints.add("nonmatching-etag");
                                        request.setMatchingETagConstraints(matchingETagConstraints);
                                        try {
                                            try {
                                                result = secondClient.copyObject(request);
                                                Assert.fail((String)"Copy object should not be successful.");
                                            }
                                            catch (OSSException e) {
                                                Assert.assertEquals((String)"PreconditionFailed", (String)e.getErrorCode());
                                                request.clearMatchingETagConstraints();
                                                break block43;
                                            }
                                        }
                                        catch (Throwable throwable) {
                                            request.clearMatchingETagConstraints();
                                            throw throwable;
                                        }
                                        request.clearMatchingETagConstraints();
                                    }
                                    nonmatchingETagConstraints = new ArrayList<String>();
                                    nonmatchingETagConstraints.add("nonmatching-etag");
                                    request.setNonmatchingETagConstraints(nonmatchingETagConstraints);
                                    try {
                                        try {
                                            result = secondClient.copyObject(request);
                                            Assert.assertEquals((String)eTag, (String)result.getETag());
                                        }
                                        catch (Exception e) {
                                            Assert.fail((String)e.getMessage());
                                            request.clearNonmatchingETagConstraints();
                                            break block45;
                                        }
                                    }
                                    catch (Throwable throwable) {
                                        request.clearNonmatchingETagConstraints();
                                        throw throwable;
                                    }
                                    request.clearNonmatchingETagConstraints();
                                }
                                nonmatchingETagConstraints.clear();
                                nonmatchingETagConstraints.add(eTag);
                                request.setNonmatchingETagConstraints(nonmatchingETagConstraints);
                                try {
                                    try {
                                        result = secondClient.copyObject(request);
                                        Assert.fail((String)"Copy object should not be successful.");
                                    }
                                    catch (OSSException e) {
                                        Assert.assertEquals((String)"NotModified", (String)e.getErrorCode());
                                        Assert.assertTrue((boolean)e.getMessage().startsWith("Not Modified"));
                                        request.clearNonmatchingETagConstraints();
                                        break block47;
                                    }
                                }
                                catch (Throwable throwable) {
                                    request.clearNonmatchingETagConstraints();
                                    throw throwable;
                                }
                                request.clearNonmatchingETagConstraints();
                            }
                            unmodifiedSinceConstraint = new Date();
                            request.setUnmodifiedSinceConstraint(unmodifiedSinceConstraint);
                            try {
                                try {
                                    result = secondClient.copyObject(request);
                                    Assert.assertEquals((String)eTag, (String)result.getETag());
                                }
                                catch (OSSException e) {
                                    Assert.fail((String)e.getMessage());
                                    request.setUnmodifiedSinceConstraint(null);
                                    break block49;
                                }
                            }
                            catch (Throwable throwable) {
                                request.setUnmodifiedSinceConstraint(null);
                                throw throwable;
                            }
                            request.setUnmodifiedSinceConstraint(null);
                        }
                        unmodifiedSinceConstraint = beforeModifiedTime;
                        request.setUnmodifiedSinceConstraint(unmodifiedSinceConstraint);
                        try {
                            try {
                                result = secondClient.copyObject(request);
                                Assert.fail((String)"Copy object should not be successful.");
                            }
                            catch (OSSException e) {
                                Assert.assertEquals((String)"PreconditionFailed", (String)e.getErrorCode());
                                request.setUnmodifiedSinceConstraint(null);
                                break block51;
                            }
                        }
                        catch (Throwable throwable) {
                            request.setUnmodifiedSinceConstraint(null);
                            throw throwable;
                        }
                        request.setUnmodifiedSinceConstraint(null);
                    }
                    modifiedSinceConstraint = beforeModifiedTime;
                    request.setModifiedSinceConstraint(modifiedSinceConstraint);
                    try {
                        try {
                            result = secondClient.copyObject(request);
                            Assert.assertEquals((String)eTag, (String)result.getETag());
                        }
                        catch (OSSException e) {
                            Assert.fail((String)e.getMessage());
                            request.setModifiedSinceConstraint(null);
                            break block53;
                        }
                    }
                    catch (Throwable throwable) {
                        request.setModifiedSinceConstraint(null);
                        throw throwable;
                    }
                    request.setModifiedSinceConstraint(null);
                }
                modifiedSinceConstraint = new Date();
                request.setModifiedSinceConstraint(modifiedSinceConstraint);
                try {
                    try {
                        result = secondClient.copyObject(request);
                        Assert.fail((String)"Copy object should not be successful.");
                    }
                    catch (OSSException e) {
                        Assert.assertEquals((String)"NotModified", (String)e.getErrorCode());
                        Assert.assertTrue((boolean)e.getMessage().startsWith("Not Modified"));
                        request.setModifiedSinceConstraint(null);
                    }
                }
                finally {
                    request.setModifiedSinceConstraint(null);
                }
            }
            catch (Exception e) {
                Assert.fail((String)e.getMessage());
                CopyObjectTest.deleteBucketWithObjects(secondClient, "copy-object-with-misc-constraints-source-bucket");
                CopyObjectTest.deleteBucketWithObjects(secondClient, "copy-object-with-misc-constraints-target-bucket");
            }
        }
        finally {
            CopyObjectTest.deleteBucketWithObjects(secondClient, "copy-object-with-misc-constraints-source-bucket");
            CopyObjectTest.deleteBucketWithObjects(secondClient, "copy-object-with-misc-constraints-target-bucket");
        }
    }
}

