/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.oss.integrationtests;

import com.aliyun.oss.OSSException;
import com.aliyun.oss.integrationtests.TestBase;
import com.aliyun.oss.integrationtests.TestUtils;
import com.aliyun.oss.model.AppendObjectRequest;
import com.aliyun.oss.model.AppendObjectResult;
import com.aliyun.oss.model.OSSObject;
import java.io.File;
import java.io.InputStream;
import junit.framework.Assert;
import org.junit.Test;

public class AppendObjectTest
extends TestBase {
    @Test
    public void testNormalAppendObject() throws Exception {
        String key = "normal-append-object";
        long instreamLength = 131072L;
        int i = 0;
        while (i < 10) {
            try {
                InputStream instream = TestUtils.genFixedLengthInputStream(131072L);
                AppendObjectRequest appendObjectRequest = new AppendObjectRequest(bucketName, key, instream, null);
                appendObjectRequest.setPosition((long)(2 * i) * 131072L);
                AppendObjectResult appendObjectResult = secondClient.appendObject(appendObjectRequest);
                OSSObject o = secondClient.getObject(bucketName, key);
                Assert.assertEquals((String)key, (String)o.getKey());
                Assert.assertEquals((long)((long)(2 * i + 1) * 131072L), (long)o.getObjectMetadata().getContentLength());
                Assert.assertEquals((String)"Appendable", (String)o.getObjectMetadata().getObjectType());
                if (appendObjectResult.getNextPosition() != null) {
                    Assert.assertEquals((long)((long)(2 * i + 1) * 131072L), (long)appendObjectResult.getNextPosition());
                }
                String filePath = TestUtils.genFixedLengthFile(131072L);
                appendObjectRequest = new AppendObjectRequest(bucketName, key, new File(filePath));
                appendObjectRequest.setPosition(appendObjectResult.getNextPosition());
                appendObjectResult = secondClient.appendObject(appendObjectRequest);
                o = secondClient.getObject(bucketName, key);
                Assert.assertEquals((long)(262144L * (long)(i + 1)), (long)o.getObjectMetadata().getContentLength());
                Assert.assertEquals((String)"Appendable", (String)o.getObjectMetadata().getObjectType());
                if (appendObjectResult.getNextPosition() != null) {
                    Assert.assertEquals((long)(262144L * (long)(i + 1)), (long)appendObjectResult.getNextPosition());
                }
            }
            catch (Exception ex) {
                Assert.fail((String)ex.getMessage());
            }
            ++i;
        }
    }

    @Test
    public void testAppendExistingNormalObject() throws Exception {
        String key = "append-existing-normal-object";
        long instreamLength = 131072L;
        try {
            InputStream instream = TestUtils.genFixedLengthInputStream(131072L);
            defaultClient.putObject(bucketName, key, instream, null);
            OSSObject o = defaultClient.getObject(bucketName, key);
            Assert.assertEquals((String)key, (String)o.getKey());
            Assert.assertEquals((long)131072L, (long)o.getObjectMetadata().getContentLength());
            o.getObjectContent().close();
            try {
                instream = TestUtils.genFixedLengthInputStream(131072L);
                AppendObjectRequest appendObjectRequest = new AppendObjectRequest(bucketName, key, instream, null);
                appendObjectRequest.setPosition(131072L);
                defaultClient.appendObject(appendObjectRequest);
            }
            catch (OSSException ex) {
                Assert.assertEquals((String)"ObjectNotAppendable", (String)ex.getErrorCode());
                Assert.assertTrue((boolean)ex.getMessage().startsWith("The object is not appendable"));
            }
        }
        catch (Exception ex) {
            Assert.fail((String)ex.getMessage());
        }
    }

    @Test
    public void testAppendObjectAtIllegalPosition() throws Exception {
        String key = "append-object-at-illlegal-position";
        long instreamLength = 131072L;
        try {
            InputStream instream = TestUtils.genFixedLengthInputStream(131072L);
            AppendObjectRequest appendObjectRequest = new AppendObjectRequest(bucketName, key, instream, null);
            appendObjectRequest.setPosition(0L);
            AppendObjectResult appendObjectResult = defaultClient.appendObject(appendObjectRequest);
            OSSObject o = defaultClient.getObject(bucketName, key);
            Assert.assertEquals((String)key, (String)o.getKey());
            Assert.assertEquals((long)131072L, (long)o.getObjectMetadata().getContentLength());
            Assert.assertEquals((String)"Appendable", (String)o.getObjectMetadata().getObjectType());
            if (appendObjectResult.getNextPosition() != null) {
                Assert.assertEquals((long)131072L, (long)appendObjectResult.getNextPosition());
            }
            o.getObjectContent().close();
            try {
                instream = TestUtils.genFixedLengthInputStream(131072L);
                appendObjectRequest = new AppendObjectRequest(bucketName, key, instream, null);
                appendObjectRequest.setPosition(131071L);
                defaultClient.appendObject(appendObjectRequest);
            }
            catch (OSSException ex) {
                Assert.assertEquals((String)"PositionNotEqualToLength", (String)ex.getErrorCode());
                Assert.assertTrue((boolean)ex.getMessage().startsWith("Position is not equal to file length"));
            }
        }
        catch (Exception ex) {
            Assert.fail((String)ex.getMessage());
        }
    }

    @Test
    public void testAppendObjectMissingArguments() throws Exception {
        String key = "append-object-missing-arguments";
        long instreamLength = 131072L;
        try {
            Assert.assertEquals((boolean)true, (boolean)defaultClient.doesBucketExist(bucketName));
            InputStream instream = TestUtils.genFixedLengthInputStream(131072L);
            AppendObjectRequest appendObjectRequest = new AppendObjectRequest(bucketName, key, instream, null);
            defaultClient.appendObject(appendObjectRequest);
        }
        catch (OSSException ex) {
            Assert.assertEquals((String)"MissingArgument", (String)ex.getErrorCode());
            Assert.assertTrue((boolean)ex.getMessage().startsWith("Missing Some Required Arguments."));
        }
    }
}

