/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.oss.common.comm;

import com.aliyun.oss.HttpMethod;
import com.aliyun.oss.common.comm.ExecutionContext;
import com.aliyun.oss.common.comm.HttpRequestFactory;
import com.aliyun.oss.common.comm.ServiceClient;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.junit.Assert;
import org.junit.Test;

public class HttpFactoryTest {
    @Test
    public void testCreateHttpRequest() throws Exception {
        ExecutionContext context = new ExecutionContext();
        String url = "http://127.0.0.1";
        String content = "This is a test request";
        byte[] contentBytes = null;
        try {
            contentBytes = content.getBytes(context.getCharset());
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
        HttpRequestFactory factory = new HttpRequestFactory();
        ServiceClient.Request request = new ServiceClient.Request();
        request.setUrl(url);
        HttpRequestBase httpRequest = null;
        request.setMethod(HttpMethod.GET);
        httpRequest = factory.createHttpRequest(request, context);
        HttpGet getMethod = (HttpGet)httpRequest;
        Assert.assertEquals((Object)url, (Object)getMethod.getURI().toString());
        request.setMethod(HttpMethod.DELETE);
        httpRequest = factory.createHttpRequest(request, context);
        HttpDelete delMethod = (HttpDelete)httpRequest;
        Assert.assertEquals((Object)url, (Object)delMethod.getURI().toString());
        request.setMethod(HttpMethod.HEAD);
        httpRequest = factory.createHttpRequest(request, context);
        HttpHead headMethod = (HttpHead)httpRequest;
        Assert.assertEquals((Object)url, (Object)headMethod.getURI().toString());
        request.setContent(new ByteArrayInputStream(contentBytes));
        request.setContentLength(contentBytes.length);
        request.setMethod(HttpMethod.POST);
        httpRequest = factory.createHttpRequest(request, context);
        HttpPost postMethod = (HttpPost)httpRequest;
        Assert.assertEquals((Object)url, (Object)postMethod.getURI().toString());
        HttpEntity entity = postMethod.getEntity();
        try {
            Assert.assertEquals((Object)content, (Object)this.readSting(entity.getContent()));
        }
        catch (IllegalStateException e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
        catch (IOException e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
        request.setContent(new ByteArrayInputStream(contentBytes));
        request.setContentLength(contentBytes.length);
        request.setMethod(HttpMethod.PUT);
        httpRequest = factory.createHttpRequest(request, context);
        HttpPut putMethod = (HttpPut)httpRequest;
        Assert.assertEquals((Object)url, (Object)putMethod.getURI().toString());
        entity = putMethod.getEntity();
        try {
            Assert.assertEquals((Object)content, (Object)this.readSting(entity.getContent()));
        }
        catch (IllegalStateException e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
        catch (IOException e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
        try {
            request.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    /*
     * Loose catch block
     */
    private String readSting(InputStream input) {
        InputStreamReader reader = new InputStreamReader(input);
        BufferedReader br = new BufferedReader(reader);
        StringBuilder sb = new StringBuilder();
        String line = null;
        while ((line = br.readLine()) != null) {
            sb.append(line);
        }
        String string = sb.toString();
        try {
            br.close();
            reader.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return string;
        catch (IOException e) {
            try {
                br.close();
                reader.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return null;
            catch (Throwable throwable) {
                try {
                    br.close();
                    reader.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                throw throwable;
            }
        }
    }
}

