/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.util;

import com.alibaba.druid.sql.SQLUtils;
import com.alibaba.druid.sql.ast.SQLStatement;
import com.alibaba.druid.sql.ast.statement.SQLCreateTableStatement;
import com.alibaba.druid.util.JdbcUtils;
import com.alibaba.druid.util.Utils;
import com.mysql.jdbc.ConnectionImpl;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.sql.XAConnection;

public class MySqlUtils {
    static Class<?> utilClass;
    static boolean utilClassError;
    static boolean utilClass_isJdbc4;
    static Class<?> connectionClass;
    static Method getPinGlobalTxToPhysicalConnectionMethod;
    static Class<?> suspendableXAConnectionClass;
    static Constructor<?> suspendableXAConnectionConstructor;
    static Class<?> JDBC4SuspendableXAConnectionClass;
    static Constructor<?> JDBC4SuspendableXAConnectionConstructor;
    static Class<?> MysqlXAConnectionClass;
    static Constructor<?> MysqlXAConnectionConstructor;
    private static Set<String> keywords;

    public static XAConnection createXAConnection(Driver driver, Connection physicalConn) throws SQLException {
        int major = driver.getMajorVersion();
        if (major == 5) {
            if (utilClass == null && !utilClassError) {
                try {
                    utilClass = Class.forName("com.mysql.jdbc.Util");
                    Method method = utilClass.getMethod("isJdbc4", new Class[0]);
                    utilClass_isJdbc4 = (Boolean)method.invoke(null, new Object[0]);
                    connectionClass = Class.forName("com.mysql.jdbc.Connection");
                    getPinGlobalTxToPhysicalConnectionMethod = connectionClass.getMethod("getPinGlobalTxToPhysicalConnection", new Class[0]);
                    suspendableXAConnectionClass = Class.forName("com.mysql.jdbc.jdbc2.optional.SuspendableXAConnection");
                    suspendableXAConnectionConstructor = suspendableXAConnectionClass.getConstructor(connectionClass);
                    JDBC4SuspendableXAConnectionClass = Class.forName("com.mysql.jdbc.jdbc2.optional.JDBC4SuspendableXAConnection");
                    JDBC4SuspendableXAConnectionConstructor = JDBC4SuspendableXAConnectionClass.getConstructor(connectionClass);
                    MysqlXAConnectionClass = Class.forName("com.mysql.jdbc.jdbc2.optional.MysqlXAConnection");
                    MysqlXAConnectionConstructor = MysqlXAConnectionClass.getConstructor(connectionClass, Boolean.TYPE);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    utilClassError = true;
                }
            }
            try {
                boolean pinGlobTx = (Boolean)getPinGlobalTxToPhysicalConnectionMethod.invoke((Object)physicalConn, new Object[0]);
                if (pinGlobTx) {
                    if (!utilClass_isJdbc4) {
                        return (XAConnection)suspendableXAConnectionConstructor.newInstance(physicalConn);
                    }
                    return (XAConnection)JDBC4SuspendableXAConnectionConstructor.newInstance(physicalConn);
                }
                return (XAConnection)MysqlXAConnectionConstructor.newInstance(physicalConn, Boolean.FALSE);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        throw new SQLFeatureNotSupportedException();
    }

    public static String buildKillQuerySql(Connection connection, SQLException error) throws SQLException {
        try {
            ConnectionImpl connImpl = (ConnectionImpl)connection;
            long threadId = connImpl.getId();
            return "KILL QUERY " + threadId;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static boolean isKeyword(String name) {
        if (name == null) {
            return false;
        }
        String name_lower = name.toLowerCase();
        Set<String> words = keywords;
        if (words == null) {
            words = new HashSet<String>();
            Utils.loadFromFile("META-INF/druid/parser/mysql/keywords", words);
            keywords = words;
        }
        return words.contains(name_lower);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> showTables(Connection conn) throws SQLException {
        ArrayList<String> tables = new ArrayList<String>();
        Statement stmt = null;
        ResultSet rs = null;
        try {
            stmt = conn.createStatement();
            rs = stmt.executeQuery("show tables");
            while (rs.next()) {
                String tableName = rs.getString(1);
                tables.add(tableName);
            }
        }
        catch (Throwable throwable) {
            JdbcUtils.close(rs);
            JdbcUtils.close(stmt);
            throw throwable;
        }
        JdbcUtils.close(rs);
        JdbcUtils.close(stmt);
        return tables;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static List<String> getTableDDL(Connection conn, List<String> tables) throws SQLException {
        ArrayList<String> ddlList = new ArrayList<String>();
        Statement stmt = null;
        try {
            for (String table : tables) {
                ResultSet rs;
                block8: {
                    if (stmt == null) {
                        stmt = conn.createStatement();
                    }
                    if (MySqlUtils.isKeyword(table)) {
                        table = "`" + table + "`";
                    }
                    rs = null;
                    try {
                        rs = stmt.executeQuery("show create table " + table);
                        if (!rs.next()) break block8;
                        String ddl = rs.getString(2);
                        ddlList.add(ddl);
                    }
                    catch (Throwable throwable) {
                        JdbcUtils.close(rs);
                        throw throwable;
                        return ddlList;
                    }
                }
                JdbcUtils.close(rs);
            }
        }
        finally {
            JdbcUtils.close(stmt);
        }
    }

    public static String getCreateTableScript(Connection conn) throws SQLException {
        return MySqlUtils.getCreateTableScript(conn, true, true);
    }

    public static String getCreateTableScript(Connection conn, boolean sorted, boolean simplify) throws SQLException {
        List<String> tables = MySqlUtils.showTables(conn);
        List<String> ddlList = MySqlUtils.getTableDDL(conn, tables);
        StringBuilder buf = new StringBuilder();
        for (String ddl : ddlList) {
            buf.append(ddl);
            buf.append(';');
        }
        String ddlScript = buf.toString();
        if (!sorted && !simplify) {
            return ddlScript;
        }
        List<SQLStatement> stmtList = SQLUtils.parseStatements(ddlScript, "mysql");
        if (simplify) {
            for (SQLStatement o : stmtList) {
                if (!(o instanceof SQLCreateTableStatement)) continue;
                SQLCreateTableStatement createTableStmt = (SQLCreateTableStatement)o;
                createTableStmt.simplify();
            }
        }
        if (sorted) {
            SQLCreateTableStatement.sort(stmtList);
        }
        return SQLUtils.toSQLString(stmtList, "mysql");
    }

    static {
        utilClassError = false;
        utilClass_isJdbc4 = false;
        connectionClass = null;
        getPinGlobalTxToPhysicalConnectionMethod = null;
        suspendableXAConnectionClass = null;
        suspendableXAConnectionConstructor = null;
        JDBC4SuspendableXAConnectionClass = null;
        JDBC4SuspendableXAConnectionConstructor = null;
        MysqlXAConnectionClass = null;
        MysqlXAConnectionConstructor = null;
    }
}

