/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.sql.dialect.postgresql.parser;

import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.SQLName;
import com.alibaba.druid.sql.ast.SQLObjectImpl;
import com.alibaba.druid.sql.ast.SQLStatement;
import com.alibaba.druid.sql.ast.expr.SQLCurrentOfCursorExpr;
import com.alibaba.druid.sql.ast.expr.SQLQueryExpr;
import com.alibaba.druid.sql.ast.statement.SQLInsertStatement;
import com.alibaba.druid.sql.ast.statement.SQLTableSource;
import com.alibaba.druid.sql.ast.statement.SQLUpdateStatement;
import com.alibaba.druid.sql.dialect.postgresql.ast.PGWithClause;
import com.alibaba.druid.sql.dialect.postgresql.ast.PGWithQuery;
import com.alibaba.druid.sql.dialect.postgresql.ast.stmt.PGDeleteStatement;
import com.alibaba.druid.sql.dialect.postgresql.ast.stmt.PGInsertStatement;
import com.alibaba.druid.sql.dialect.postgresql.ast.stmt.PGSelectStatement;
import com.alibaba.druid.sql.dialect.postgresql.ast.stmt.PGUpdateStatement;
import com.alibaba.druid.sql.dialect.postgresql.parser.PGExprParser;
import com.alibaba.druid.sql.dialect.postgresql.parser.PGSelectParser;
import com.alibaba.druid.sql.parser.Lexer;
import com.alibaba.druid.sql.parser.ParserException;
import com.alibaba.druid.sql.parser.SQLStatementParser;
import com.alibaba.druid.sql.parser.Token;
import java.util.List;

public class PGSQLStatementParser
extends SQLStatementParser {
    public PGSQLStatementParser(String sql) {
        super(new PGExprParser(sql));
    }

    public PGSQLStatementParser(Lexer lexer) {
        super(new PGExprParser(lexer));
    }

    @Override
    public PGSelectParser createSQLSelectParser() {
        return new PGSelectParser(this.exprParser);
    }

    @Override
    public SQLUpdateStatement parseUpdateStatement() {
        this.accept(Token.UPDATE);
        PGUpdateStatement udpateStatement = new PGUpdateStatement();
        SQLTableSource tableSource = this.exprParser.createSelectParser().parseTableSource();
        udpateStatement.setTableSource(tableSource);
        this.parseUpdateSet(udpateStatement);
        if (this.lexer.token() == Token.WHERE) {
            this.lexer.nextToken();
            udpateStatement.setWhere(this.exprParser.expr());
        }
        if (this.lexer.token() == Token.RETURNING) {
            this.lexer.nextToken();
            while (true) {
                udpateStatement.getReturning().add(this.exprParser.expr());
                if (this.lexer.token() != Token.COMMA) break;
                this.lexer.nextToken();
            }
        }
        return udpateStatement;
    }

    @Override
    public PGInsertStatement parseInsert() {
        PGInsertStatement stmt = new PGInsertStatement();
        if (this.lexer.token() == Token.INSERT) {
            this.lexer.nextToken();
            this.accept(Token.INTO);
            SQLName tableName = this.exprParser.name();
            stmt.setTableName(tableName);
            if (this.lexer.token() == Token.IDENTIFIER) {
                stmt.setAlias(this.lexer.stringVal());
                this.lexer.nextToken();
            }
        }
        if (this.lexer.token() == Token.LPAREN) {
            this.lexer.nextToken();
            this.exprParser.exprList(stmt.getColumns());
            this.accept(Token.RPAREN);
        }
        if (this.lexer.token() == Token.VALUES) {
            this.lexer.nextToken();
            while (true) {
                this.accept(Token.LPAREN);
                SQLInsertStatement.ValuesClause valuesCaluse = new SQLInsertStatement.ValuesClause();
                this.exprParser.exprList(valuesCaluse.getValues());
                stmt.addValueCause(valuesCaluse);
                this.accept(Token.RPAREN);
                if (this.lexer.token() == Token.COMMA) {
                    this.lexer.nextToken();
                    continue;
                }
                break;
            }
        } else if (this.lexer.token() == Token.SELECT) {
            SQLQueryExpr queryExpr = (SQLQueryExpr)this.exprParser.expr();
            stmt.setQuery(queryExpr.getSubQuery());
        }
        if (this.lexer.token() == Token.RETURNING) {
            this.lexer.nextToken();
            SQLExpr returning = this.exprParser.expr();
            stmt.setReturning(returning);
        }
        return stmt;
    }

    @Override
    public PGDeleteStatement parseDeleteStatement() {
        this.lexer.nextToken();
        PGDeleteStatement deleteStatement = new PGDeleteStatement();
        if (this.lexer.token() == Token.FROM) {
            this.lexer.nextToken();
        }
        if (this.lexer.token() == Token.ONLY) {
            this.lexer.nextToken();
            deleteStatement.setOnly(true);
        }
        SQLName tableName = this.exprParser.name();
        deleteStatement.setTableName(tableName);
        if (this.lexer.token() == Token.USING) {
            this.lexer.nextToken();
            while (true) {
                SQLName name = this.exprParser.name();
                deleteStatement.getUsing().add(name);
                if (this.lexer.token() != Token.COMMA) break;
                this.lexer.nextToken();
            }
        }
        if (this.lexer.token() == Token.WHERE) {
            this.lexer.nextToken();
            if (this.lexer.token() == Token.CURRENT) {
                this.lexer.nextToken();
                this.accept(Token.OF);
                SQLName cursorName = this.exprParser.name();
                SQLCurrentOfCursorExpr where = new SQLCurrentOfCursorExpr(cursorName);
                deleteStatement.setWhere(where);
            } else {
                SQLExpr where = this.exprParser.expr();
                deleteStatement.setWhere(where);
            }
        }
        if (this.lexer.token() == Token.RETURNING) {
            this.lexer.nextToken();
            this.accept(Token.STAR);
            deleteStatement.setReturning(true);
        }
        return deleteStatement;
    }

    @Override
    public boolean parseStatementListDialect(List<SQLStatement> statementList) {
        if (this.lexer.token() == Token.WITH) {
            SQLStatement stmt = this.parseWith();
            statementList.add(stmt);
            return true;
        }
        return false;
    }

    public PGWithClause parseWithClause() {
        this.lexer.nextToken();
        PGWithClause withClause = new PGWithClause();
        if (this.lexer.token() == Token.RECURSIVE) {
            this.lexer.nextToken();
            withClause.setRecursive(true);
        }
        while (true) {
            PGWithQuery withQuery = this.withQuery();
            withClause.getWithQuery().add(withQuery);
            if (this.lexer.token() != Token.COMMA) break;
            this.lexer.nextToken();
        }
        return withClause;
    }

    private PGWithQuery withQuery() {
        PGWithQuery withQuery = new PGWithQuery();
        withQuery.setName(this.exprParser.expr());
        if (this.lexer.token() == Token.LPAREN) {
            this.lexer.nextToken();
            while (true) {
                SQLExpr expr = this.exprParser.expr();
                withQuery.getColumns().add(expr);
                if (this.lexer.token() != Token.COMMA) break;
                this.lexer.nextToken();
            }
            this.accept(Token.RPAREN);
        }
        this.accept(Token.AS);
        if (this.lexer.token() == Token.LPAREN) {
            SQLObjectImpl query;
            this.lexer.nextToken();
            if (this.lexer.token() == Token.SELECT) {
                query = this.parseSelect();
            } else if (this.lexer.token() == Token.INSERT) {
                query = this.parseInsert();
            } else if (this.lexer.token() == Token.UPDATE) {
                query = this.parseUpdateStatement();
            } else if (this.lexer.token() == Token.DELETE) {
                query = this.parseDeleteStatement();
            } else {
                throw new ParserException("syntax error, support token '" + (Object)((Object)this.lexer.token()) + "'");
            }
            withQuery.setQuery((SQLStatement)((Object)query));
            this.accept(Token.RPAREN);
        }
        return withQuery;
    }

    @Override
    public PGSelectStatement parseSelect() {
        return new PGSelectStatement(this.createSQLSelectParser().select());
    }

    public SQLStatement parseWith() {
        PGWithClause with = this.parseWithClause();
        if (this.lexer.token() == Token.INSERT) {
            PGInsertStatement stmt = this.parseInsert();
            stmt.setWith(with);
            return stmt;
        }
        if (this.lexer.token() == Token.SELECT) {
            PGSelectStatement stmt = this.parseSelect();
            stmt.setWith(with);
            return stmt;
        }
        throw new ParserException("TODO");
    }
}

