/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.pool.vendor;

import com.alibaba.druid.pool.DruidPooledConnection;
import com.alibaba.druid.pool.ValidConnectionChecker;
import com.alibaba.druid.pool.ValidConnectionCheckerAdapter;
import com.alibaba.druid.proxy.jdbc.ConnectionProxy;
import com.alibaba.druid.support.logging.Log;
import com.alibaba.druid.support.logging.LogFactory;
import com.alibaba.druid.util.JdbcUtils;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public class PGValidConnectionChecker
extends ValidConnectionCheckerAdapter
implements ValidConnectionChecker,
Serializable {
    private static final long serialVersionUID = -2227528634302168877L;
    private static final Log LOG = LogFactory.getLog(PGValidConnectionChecker.class);
    private String defaultValidateQuery = "SELECT 'x' FROM DUAL";

    public PGValidConnectionChecker() {
        this.configFromProperties(System.getProperties());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean isValidConnection(Connection conn, String validateQuery, int validationQueryTimeout) {
        if (validateQuery == null || validateQuery.isEmpty()) {
            validateQuery = this.defaultValidateQuery;
        }
        try {
            if (conn.isClosed()) {
                return false;
            }
        }
        catch (SQLException ex) {
            return false;
        }
        try {
            boolean bl;
            if (conn instanceof DruidPooledConnection) {
                conn = ((DruidPooledConnection)conn).getConnection();
            }
            if (conn instanceof ConnectionProxy) {
                conn = ((ConnectionProxy)conn).getRawObject();
            }
            Statement stmt = null;
            ResultSet rs = null;
            try {
                stmt = conn.createStatement();
                rs = stmt.executeQuery(validateQuery);
                bl = true;
            }
            catch (SQLException e) {
                boolean bl2 = false;
                {
                    catch (Throwable throwable) {
                        JdbcUtils.close(rs);
                        JdbcUtils.close(stmt);
                        throw throwable;
                    }
                }
                JdbcUtils.close(rs);
                JdbcUtils.close(stmt);
                return bl2;
                catch (Exception e2) {
                    LOG.warn("Unexpected error in ping", e2);
                    boolean bl3 = false;
                    JdbcUtils.close(rs);
                    JdbcUtils.close(stmt);
                    return bl3;
                }
            }
            JdbcUtils.close(rs);
            JdbcUtils.close(stmt);
            return bl;
        }
        catch (Exception e) {
            LOG.warn("Unexpected error in pingDatabase", e);
            return false;
        }
    }
}

